/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.fx;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.currency.FxRate;
import com.opengamma.strata.calc.marketdata.MarketDataConfig;
import com.opengamma.strata.calc.marketdata.MarketDataFunction;
import com.opengamma.strata.calc.marketdata.MarketDataRequirements;
import com.opengamma.strata.collect.TypedString;
import com.opengamma.strata.data.FxRateId;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.scenario.MarketDataBox;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.market.observable.QuoteId;
import com.opengamma.strata.measure.fx.FxRateConfig;
import java.util.Optional;

public class FxRateMarketDataFunction
implements MarketDataFunction<FxRate, FxRateId> {
    public MarketDataRequirements requirements(FxRateId id, MarketDataConfig marketDataConfig) {
        FxRateConfig fxRateConfig = (FxRateConfig)marketDataConfig.get(FxRateConfig.class, (TypedString)id.getObservableSource());
        Optional<QuoteId> optional = fxRateConfig.getObservableRateKey(id.getPair());
        return optional.map(key -> MarketDataRequirements.of((MarketDataId)key)).orElse(MarketDataRequirements.empty());
    }

    public MarketDataBox<FxRate> build(FxRateId id, MarketDataConfig marketDataConfig, ScenarioMarketData marketData, ReferenceData refData) {
        FxRateConfig fxRateConfig = (FxRateConfig)marketDataConfig.get(FxRateConfig.class, (TypedString)id.getObservableSource());
        Optional<QuoteId> optional = fxRateConfig.getObservableRateKey(id.getPair());
        return optional.map(key -> this.buildFxRate(id, (QuoteId)key, marketData)).orElseThrow(() -> new IllegalArgumentException("No FX rate configuration available for " + id.getPair()));
    }

    private MarketDataBox<FxRate> buildFxRate(FxRateId id, QuoteId key, ScenarioMarketData marketData) {
        MarketDataBox quote = marketData.getValue((MarketDataId)key);
        return quote.map(rate -> FxRate.of((CurrencyPair)id.getPair(), (double)rate));
    }

    public Class<FxRateId> getMarketDataIdType() {
        return FxRateId.class;
    }
}

