/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.fx;

import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.FxRate;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.data.scenario.CurrencyScenarioArray;
import com.opengamma.strata.data.scenario.MultiCurrencyScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.measure.fx.FxNdfMeasureCalculations;
import com.opengamma.strata.measure.rate.RatesMarketDataLookup;
import com.opengamma.strata.pricer.fx.DiscountingFxNdfTradePricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.fx.ResolvedFxNdfTrade;

public class FxNdfTradeCalculations {
    public static final FxNdfTradeCalculations DEFAULT = new FxNdfTradeCalculations(DiscountingFxNdfTradePricer.DEFAULT);
    private final FxNdfMeasureCalculations calc;

    public FxNdfTradeCalculations(DiscountingFxNdfTradePricer tradePricer) {
        this.calc = new FxNdfMeasureCalculations(tradePricer);
    }

    public CurrencyScenarioArray presentValue(ResolvedFxNdfTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.presentValue(trade, lookup.marketDataView(marketData));
    }

    public CurrencyAmount presentValue(ResolvedFxNdfTrade trade, RatesProvider ratesProvider) {
        return this.calc.presentValue(trade, ratesProvider);
    }

    public MultiCurrencyScenarioArray pv01CalibratedSum(ResolvedFxNdfTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.pv01CalibratedSum(trade, lookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount pv01CalibratedSum(ResolvedFxNdfTrade trade, RatesProvider ratesProvider) {
        return this.calc.pv01CalibratedSum(trade, ratesProvider);
    }

    public ScenarioArray<CurrencyParameterSensitivities> pv01CalibratedBucketed(ResolvedFxNdfTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.pv01CalibratedBucketed(trade, lookup.marketDataView(marketData));
    }

    public CurrencyParameterSensitivities pv01CalibratedBucketed(ResolvedFxNdfTrade trade, RatesProvider ratesProvider) {
        return this.calc.pv01CalibratedBucketed(trade, ratesProvider);
    }

    public MultiCurrencyScenarioArray pv01MarketQuoteSum(ResolvedFxNdfTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.pv01MarketQuoteSum(trade, lookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount pv01MarketQuoteSum(ResolvedFxNdfTrade trade, RatesProvider ratesProvider) {
        return this.calc.pv01MarketQuoteSum(trade, ratesProvider);
    }

    public ScenarioArray<CurrencyParameterSensitivities> pv01MarketQuoteBucketed(ResolvedFxNdfTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.pv01MarketQuoteBucketed(trade, lookup.marketDataView(marketData));
    }

    public CurrencyParameterSensitivities pv01MarketQuoteBucketed(ResolvedFxNdfTrade trade, RatesProvider ratesProvider) {
        return this.calc.pv01MarketQuoteBucketed(trade, ratesProvider);
    }

    public MultiCurrencyScenarioArray currencyExposure(ResolvedFxNdfTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.currencyExposure(trade, lookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount currencyExposure(ResolvedFxNdfTrade trade, RatesProvider ratesProvider) {
        return this.calc.currencyExposure(trade, ratesProvider);
    }

    public CurrencyScenarioArray currentCash(ResolvedFxNdfTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.currentCash(trade, lookup.marketDataView(marketData));
    }

    public CurrencyAmount currentCash(ResolvedFxNdfTrade trade, RatesProvider ratesProvider) {
        return this.calc.currentCash(trade, ratesProvider);
    }

    public ScenarioArray<FxRate> forwardFxRate(ResolvedFxNdfTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.forwardFxRate(trade, lookup.marketDataView(marketData));
    }

    public FxRate forwardFxRate(ResolvedFxNdfTrade trade, RatesProvider ratesProvider) {
        return this.calc.forwardFxRate(trade, ratesProvider);
    }
}

