/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.fra;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.calc.Measure;
import com.opengamma.strata.calc.runner.CalculationFunction;
import com.opengamma.strata.calc.runner.CalculationParameters;
import com.opengamma.strata.calc.runner.FunctionRequirements;
import com.opengamma.strata.collect.result.FailureReason;
import com.opengamma.strata.collect.result.Result;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.measure.AdvancedMeasures;
import com.opengamma.strata.measure.Measures;
import com.opengamma.strata.measure.fra.FraMeasureCalculations;
import com.opengamma.strata.measure.rate.RatesMarketDataLookup;
import com.opengamma.strata.measure.rate.RatesScenarioMarketData;
import com.opengamma.strata.product.fra.Fra;
import com.opengamma.strata.product.fra.FraTrade;
import com.opengamma.strata.product.fra.ResolvedFraTrade;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class FraTradeCalculationFunction
implements CalculationFunction<FraTrade> {
    private static final ImmutableMap<Measure, SingleMeasureCalculation> CALCULATORS = ImmutableMap.builder().put((Object)Measures.PRESENT_VALUE, FraMeasureCalculations.DEFAULT::presentValue).put((Object)Measures.EXPLAIN_PRESENT_VALUE, FraMeasureCalculations.DEFAULT::explainPresentValue).put((Object)Measures.PV01_CALIBRATED_SUM, FraMeasureCalculations.DEFAULT::pv01CalibratedSum).put((Object)Measures.PV01_CALIBRATED_BUCKETED, FraMeasureCalculations.DEFAULT::pv01CalibratedBucketed).put((Object)Measures.PV01_MARKET_QUOTE_SUM, FraMeasureCalculations.DEFAULT::pv01MarketQuoteSum).put((Object)Measures.PV01_MARKET_QUOTE_BUCKETED, FraMeasureCalculations.DEFAULT::pv01MarketQuoteBucketed).put((Object)Measures.PAR_RATE, FraMeasureCalculations.DEFAULT::parRate).put((Object)Measures.PAR_SPREAD, FraMeasureCalculations.DEFAULT::parSpread).put((Object)Measures.CASH_FLOWS, FraMeasureCalculations.DEFAULT::cashFlows).put((Object)Measures.CURRENCY_EXPOSURE, FraMeasureCalculations.DEFAULT::currencyExposure).put((Object)Measures.CURRENT_CASH, FraMeasureCalculations.DEFAULT::currentCash).put((Object)Measures.RESOLVED_TARGET, (rt, smd) -> rt).put((Object)AdvancedMeasures.PV01_SEMI_PARALLEL_GAMMA_BUCKETED, FraMeasureCalculations.DEFAULT::pv01SemiParallelGammaBucketed).put((Object)AdvancedMeasures.PV01_SINGLE_NODE_GAMMA_BUCKETED, FraMeasureCalculations.DEFAULT::pv01SingleNodeGammaBucketed).build();
    private static final ImmutableSet<Measure> MEASURES = CALCULATORS.keySet();

    public Class<FraTrade> targetType() {
        return FraTrade.class;
    }

    public Set<Measure> supportedMeasures() {
        return MEASURES;
    }

    public Optional<String> identifier(FraTrade target) {
        return target.getInfo().getId().map(id -> id.toString());
    }

    public Currency naturalCurrency(FraTrade trade, ReferenceData refData) {
        return trade.getProduct().getCurrency();
    }

    public FunctionRequirements requirements(FraTrade trade, Set<Measure> measures, CalculationParameters parameters, ReferenceData refData) {
        Fra product = trade.getProduct();
        HashSet<IborIndex> indices = new HashSet<IborIndex>();
        indices.add(product.getIndex());
        product.getIndexInterpolated().ifPresent(indices::add);
        ImmutableSet currencies = ImmutableSet.of((Object)product.getCurrency());
        RatesMarketDataLookup ratesLookup = (RatesMarketDataLookup)parameters.getParameter(RatesMarketDataLookup.class);
        return ratesLookup.requirements((Set<Currency>)currencies, indices);
    }

    public Map<Measure, Result<?>> calculate(FraTrade trade, Set<Measure> measures, CalculationParameters parameters, ScenarioMarketData scenarioMarketData, ReferenceData refData) {
        ResolvedFraTrade resolved = trade.resolve(refData);
        RatesMarketDataLookup ratesLookup = (RatesMarketDataLookup)parameters.getParameter(RatesMarketDataLookup.class);
        RatesScenarioMarketData marketData = ratesLookup.marketDataView(scenarioMarketData);
        HashMap results = new HashMap();
        for (Measure measure : measures) {
            results.put(measure, this.calculate(measure, resolved, marketData));
        }
        return results;
    }

    private Result<?> calculate(Measure measure, ResolvedFraTrade trade, RatesScenarioMarketData marketData) {
        SingleMeasureCalculation calculator = (SingleMeasureCalculation)CALCULATORS.get((Object)measure);
        if (calculator == null) {
            return Result.failure((FailureReason)FailureReason.UNSUPPORTED, (String)"Unsupported measure for FraTrade: {}", (Object[])new Object[]{measure});
        }
        return Result.of(() -> calculator.calculate(trade, marketData));
    }

    @FunctionalInterface
    static interface SingleMeasureCalculation {
        public Object calculate(ResolvedFraTrade var1, RatesScenarioMarketData var2);
    }
}

