/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.fra;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.scenario.CurrencyScenarioArray;
import com.opengamma.strata.data.scenario.DoubleScenarioArray;
import com.opengamma.strata.data.scenario.MultiCurrencyScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.market.amount.CashFlows;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.market.curve.CurveId;
import com.opengamma.strata.market.explain.ExplainMap;
import com.opengamma.strata.market.param.CrossGammaParameterSensitivities;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.CurrencyParameterSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.measure.rate.RatesMarketData;
import com.opengamma.strata.measure.rate.RatesScenarioMarketData;
import com.opengamma.strata.pricer.fra.DiscountingFraTradePricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.sensitivity.CurveGammaCalculator;
import com.opengamma.strata.pricer.sensitivity.MarketQuoteSensitivityCalculator;
import com.opengamma.strata.product.fra.ResolvedFraTrade;
import java.util.Set;

final class FraMeasureCalculations {
    public static final FraMeasureCalculations DEFAULT = new FraMeasureCalculations(DiscountingFraTradePricer.DEFAULT);
    private static final MarketQuoteSensitivityCalculator MARKET_QUOTE_SENS = MarketQuoteSensitivityCalculator.DEFAULT;
    private static final CurveGammaCalculator CROSS_GAMMA = CurveGammaCalculator.DEFAULT;
    private static final double ONE_BASIS_POINT = 1.0E-4;
    private final DiscountingFraTradePricer tradePricer;

    FraMeasureCalculations(DiscountingFraTradePricer tradePricer) {
        this.tradePricer = (DiscountingFraTradePricer)ArgChecker.notNull((Object)tradePricer, (String)"tradePricer");
    }

    CurrencyScenarioArray presentValue(ResolvedFraTrade trade, RatesScenarioMarketData marketData) {
        return CurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.presentValue(trade, marketData.scenario(i).ratesProvider()));
    }

    CurrencyAmount presentValue(ResolvedFraTrade trade, RatesProvider ratesProvider) {
        return this.tradePricer.presentValue(trade, ratesProvider);
    }

    ScenarioArray<ExplainMap> explainPresentValue(ResolvedFraTrade trade, RatesScenarioMarketData marketData) {
        return ScenarioArray.of((int)marketData.getScenarioCount(), i -> this.explainPresentValue(trade, marketData.scenario(i).ratesProvider()));
    }

    ExplainMap explainPresentValue(ResolvedFraTrade trade, RatesProvider ratesProvider) {
        return this.tradePricer.explainPresentValue(trade, ratesProvider);
    }

    MultiCurrencyScenarioArray pv01CalibratedSum(ResolvedFraTrade trade, RatesScenarioMarketData marketData) {
        return MultiCurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01CalibratedSum(trade, marketData.scenario(i).ratesProvider()));
    }

    MultiCurrencyAmount pv01CalibratedSum(ResolvedFraTrade trade, RatesProvider ratesProvider) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivity(trade, ratesProvider);
        return ratesProvider.parameterSensitivity(pointSensitivity).total().multipliedBy(1.0E-4);
    }

    ScenarioArray<CurrencyParameterSensitivities> pv01CalibratedBucketed(ResolvedFraTrade trade, RatesScenarioMarketData marketData) {
        return ScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01CalibratedBucketed(trade, marketData.scenario(i).ratesProvider()));
    }

    CurrencyParameterSensitivities pv01CalibratedBucketed(ResolvedFraTrade trade, RatesProvider ratesProvider) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivity(trade, ratesProvider);
        return ratesProvider.parameterSensitivity(pointSensitivity).multipliedBy(1.0E-4);
    }

    MultiCurrencyScenarioArray pv01MarketQuoteSum(ResolvedFraTrade trade, RatesScenarioMarketData marketData) {
        return MultiCurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01MarketQuoteSum(trade, marketData.scenario(i).ratesProvider()));
    }

    MultiCurrencyAmount pv01MarketQuoteSum(ResolvedFraTrade trade, RatesProvider ratesProvider) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivity(trade, ratesProvider);
        CurrencyParameterSensitivities parameterSensitivity = ratesProvider.parameterSensitivity(pointSensitivity);
        return MARKET_QUOTE_SENS.sensitivity(parameterSensitivity, ratesProvider).total().multipliedBy(1.0E-4);
    }

    ScenarioArray<CurrencyParameterSensitivities> pv01MarketQuoteBucketed(ResolvedFraTrade trade, RatesScenarioMarketData marketData) {
        return ScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01MarketQuoteBucketed(trade, marketData.scenario(i).ratesProvider()));
    }

    CurrencyParameterSensitivities pv01MarketQuoteBucketed(ResolvedFraTrade trade, RatesProvider ratesProvider) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivity(trade, ratesProvider);
        CurrencyParameterSensitivities parameterSensitivity = ratesProvider.parameterSensitivity(pointSensitivity);
        return MARKET_QUOTE_SENS.sensitivity(parameterSensitivity, ratesProvider).multipliedBy(1.0E-4);
    }

    ScenarioArray<CurrencyParameterSensitivities> pv01SemiParallelGammaBucketed(ResolvedFraTrade trade, RatesScenarioMarketData marketData) {
        return ScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01SemiParallelGammaBucketed(trade, marketData.scenario(i)));
    }

    private CurrencyParameterSensitivities pv01SemiParallelGammaBucketed(ResolvedFraTrade trade, RatesMarketData marketData) {
        ImmutableSet forwardIds;
        Currency currency = trade.getProduct().getCurrency();
        Set indices = trade.getProduct().allIndices();
        ImmutableSet<MarketDataId<?>> discountIds = marketData.getLookup().getDiscountMarketDataIds(currency);
        Sets.SetView allIds = Sets.union(discountIds, (Set)(forwardIds = (ImmutableSet)indices.stream().flatMap(idx -> marketData.getLookup().getForwardMarketDataIds((Index)idx).stream()).collect(Guavate.toImmutableSet())));
        if (allIds.size() != 1) {
            throw new IllegalArgumentException(Messages.format((String)"Implementation only supports a single curve, but lookup refers to more than one: {}", (Object)allIds));
        }
        MarketDataId singleId = (MarketDataId)allIds.iterator().next();
        if (!(singleId instanceof CurveId)) {
            throw new IllegalArgumentException(Messages.format((String)"Implementation only supports a single curve, but lookup does not refer to a curve: {} {}", (Object[])new Object[]{singleId.getClass().getName(), singleId}));
        }
        CurveId curveId = (CurveId)singleId;
        Curve curve = (Curve)marketData.getMarketData().getValue((MarketDataId)curveId);
        CurrencyParameterSensitivity gamma = CurveGammaCalculator.DEFAULT.calculateSemiParallelGamma(curve, currency, c -> this.calculateCurveSensitivity(trade, marketData, curveId, (Curve)c));
        return CurrencyParameterSensitivities.of((CurrencyParameterSensitivity)gamma).multipliedBy(1.0E-8);
    }

    private CurrencyParameterSensitivity calculateCurveSensitivity(ResolvedFraTrade trade, RatesMarketData marketData, CurveId curveId, Curve bumpedCurve) {
        MarketData bumpedMarketData = marketData.getMarketData().withValue((MarketDataId)curveId, (Object)bumpedCurve);
        RatesProvider bumpedRatesProvider = marketData.withMarketData(bumpedMarketData).ratesProvider();
        PointSensitivities pointSensitivities = this.tradePricer.presentValueSensitivity(trade, bumpedRatesProvider);
        CurrencyParameterSensitivities paramSensitivities = bumpedRatesProvider.parameterSensitivity(pointSensitivities);
        return (CurrencyParameterSensitivity)Iterables.getOnlyElement((Iterable)paramSensitivities.getSensitivities());
    }

    ScenarioArray<CurrencyParameterSensitivities> pv01SingleNodeGammaBucketed(ResolvedFraTrade trade, RatesScenarioMarketData marketData) {
        return ScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01SingleNodeGammaBucketed(trade, marketData.scenario(i).ratesProvider()));
    }

    private CurrencyParameterSensitivities pv01SingleNodeGammaBucketed(ResolvedFraTrade trade, RatesProvider ratesProvider) {
        CrossGammaParameterSensitivities crossGamma = CROSS_GAMMA.calculateCrossGammaIntraCurve(ratesProvider, p -> p.parameterSensitivity(this.tradePricer.presentValueSensitivity(trade, (RatesProvider)p)));
        return crossGamma.diagonal().multipliedBy(1.0E-8);
    }

    DoubleScenarioArray parRate(ResolvedFraTrade trade, RatesScenarioMarketData marketData) {
        return DoubleScenarioArray.of((int)marketData.getScenarioCount(), i -> this.parRate(trade, marketData.scenario(i).ratesProvider()));
    }

    double parRate(ResolvedFraTrade trade, RatesProvider ratesProvider) {
        return this.tradePricer.parRate(trade, ratesProvider);
    }

    DoubleScenarioArray parSpread(ResolvedFraTrade trade, RatesScenarioMarketData marketData) {
        return DoubleScenarioArray.of((int)marketData.getScenarioCount(), i -> this.parSpread(trade, marketData.scenario(i).ratesProvider()));
    }

    double parSpread(ResolvedFraTrade trade, RatesProvider ratesProvider) {
        return this.tradePricer.parSpread(trade, ratesProvider);
    }

    ScenarioArray<CashFlows> cashFlows(ResolvedFraTrade trade, RatesScenarioMarketData marketData) {
        return ScenarioArray.of((int)marketData.getScenarioCount(), i -> this.cashFlows(trade, marketData.scenario(i).ratesProvider()));
    }

    CashFlows cashFlows(ResolvedFraTrade trade, RatesProvider ratesProvider) {
        return this.tradePricer.cashFlows(trade, ratesProvider);
    }

    MultiCurrencyScenarioArray currencyExposure(ResolvedFraTrade trade, RatesScenarioMarketData marketData) {
        return MultiCurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.currencyExposure(trade, marketData.scenario(i).ratesProvider()));
    }

    MultiCurrencyAmount currencyExposure(ResolvedFraTrade trade, RatesProvider ratesProvider) {
        return this.tradePricer.currencyExposure(trade, ratesProvider);
    }

    CurrencyScenarioArray currentCash(ResolvedFraTrade trade, RatesScenarioMarketData marketData) {
        return CurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.currentCash(trade, marketData.scenario(i).ratesProvider()));
    }

    CurrencyAmount currentCash(ResolvedFraTrade trade, RatesProvider ratesProvider) {
        return this.tradePricer.currentCash(trade, ratesProvider);
    }
}

