/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.deposit;

import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.data.scenario.CurrencyScenarioArray;
import com.opengamma.strata.data.scenario.DoubleScenarioArray;
import com.opengamma.strata.data.scenario.MultiCurrencyScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.measure.deposit.TermDepositMeasureCalculations;
import com.opengamma.strata.measure.rate.RatesMarketDataLookup;
import com.opengamma.strata.pricer.deposit.DiscountingTermDepositTradePricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.deposit.ResolvedTermDepositTrade;

public class TermDepositTradeCalculations {
    public static final TermDepositTradeCalculations DEFAULT = new TermDepositTradeCalculations(DiscountingTermDepositTradePricer.DEFAULT);
    private final TermDepositMeasureCalculations calc;

    public TermDepositTradeCalculations(DiscountingTermDepositTradePricer tradePricer) {
        this.calc = new TermDepositMeasureCalculations(tradePricer);
    }

    public CurrencyScenarioArray presentValue(ResolvedTermDepositTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.presentValue(trade, lookup.marketDataView(marketData));
    }

    public CurrencyAmount presentValue(ResolvedTermDepositTrade trade, RatesProvider ratesProvider) {
        return this.calc.presentValue(trade, ratesProvider);
    }

    public MultiCurrencyScenarioArray pv01CalibratedSum(ResolvedTermDepositTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.pv01CalibratedSum(trade, lookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount pv01CalibratedSum(ResolvedTermDepositTrade trade, RatesProvider ratesProvider) {
        return this.calc.pv01CalibratedSum(trade, ratesProvider);
    }

    public ScenarioArray<CurrencyParameterSensitivities> pv01CalibratedBucketed(ResolvedTermDepositTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.pv01CalibratedBucketed(trade, lookup.marketDataView(marketData));
    }

    public CurrencyParameterSensitivities pv01CalibratedBucketed(ResolvedTermDepositTrade trade, RatesProvider ratesProvider) {
        return this.calc.pv01CalibratedBucketed(trade, ratesProvider);
    }

    public MultiCurrencyScenarioArray pv01MarketQuoteSum(ResolvedTermDepositTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.pv01MarketQuoteSum(trade, lookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount pv01MarketQuoteSum(ResolvedTermDepositTrade trade, RatesProvider ratesProvider) {
        return this.calc.pv01MarketQuoteSum(trade, ratesProvider);
    }

    public ScenarioArray<CurrencyParameterSensitivities> pv01MarketQuoteBucketed(ResolvedTermDepositTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.pv01MarketQuoteBucketed(trade, lookup.marketDataView(marketData));
    }

    public CurrencyParameterSensitivities pv01MarketQuoteBucketed(ResolvedTermDepositTrade trade, RatesProvider ratesProvider) {
        return this.calc.pv01MarketQuoteBucketed(trade, ratesProvider);
    }

    public DoubleScenarioArray parRate(ResolvedTermDepositTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.parRate(trade, lookup.marketDataView(marketData));
    }

    public double parRate(ResolvedTermDepositTrade trade, RatesProvider ratesProvider) {
        return this.calc.parRate(trade, ratesProvider);
    }

    public DoubleScenarioArray parSpread(ResolvedTermDepositTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.parSpread(trade, lookup.marketDataView(marketData));
    }

    public double parSpread(ResolvedTermDepositTrade trade, RatesProvider ratesProvider) {
        return this.calc.parSpread(trade, ratesProvider);
    }

    public MultiCurrencyScenarioArray currencyExposure(ResolvedTermDepositTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.currencyExposure(trade, lookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount currencyExposure(ResolvedTermDepositTrade trade, RatesProvider ratesProvider) {
        return this.calc.currencyExposure(trade, ratesProvider);
    }

    public CurrencyScenarioArray currentCash(ResolvedTermDepositTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.currentCash(trade, lookup.marketDataView(marketData));
    }

    public CurrencyAmount currentCash(ResolvedTermDepositTrade trade, RatesProvider ratesProvider) {
        return this.calc.currentCash(trade, ratesProvider);
    }
}

