/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.curve;

import com.opengamma.strata.collect.ArgChecker;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class RootFinderConfig
implements ImmutableBean,
Serializable {
    public static final double DEFAULT_ABSOLUTE_TOLERANCE = 1.0E-9;
    public static final double DEFAULT_RELATIVE_TOLERANCE = 1.0E-9;
    public static final int DEFAULT_MAXIMUM_STEPS = 1000;
    private static final RootFinderConfig STANDARD = new RootFinderConfig(1.0E-9, 1.0E-9, 1000);
    @PropertyDefinition(validate="ArgChecker.notNegativeOrZero")
    private final double absoluteTolerance;
    @PropertyDefinition(validate="ArgChecker.notNegativeOrZero")
    private final double relativeTolerance;
    @PropertyDefinition(validate="ArgChecker.notNegativeOrZero")
    private final int maximumSteps;
    private static final long serialVersionUID = 1L;

    public static RootFinderConfig standard() {
        return STANDARD;
    }

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.absoluteTolerance(1.0E-9);
        builder.relativeTolerance(1.0E-9);
        builder.maximumSteps(1000);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private RootFinderConfig(double absoluteTolerance, double relativeTolerance, int maximumSteps) {
        ArgChecker.notNegativeOrZero((double)absoluteTolerance, (String)"absoluteTolerance");
        ArgChecker.notNegativeOrZero((double)relativeTolerance, (String)"relativeTolerance");
        ArgChecker.notNegativeOrZero((int)maximumSteps, (String)"maximumSteps");
        this.absoluteTolerance = absoluteTolerance;
        this.relativeTolerance = relativeTolerance;
        this.maximumSteps = maximumSteps;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public double getAbsoluteTolerance() {
        return this.absoluteTolerance;
    }

    public double getRelativeTolerance() {
        return this.relativeTolerance;
    }

    public int getMaximumSteps() {
        return this.maximumSteps;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            RootFinderConfig other = (RootFinderConfig)obj;
            return JodaBeanUtils.equal((double)this.absoluteTolerance, (double)other.absoluteTolerance) && JodaBeanUtils.equal((double)this.relativeTolerance, (double)other.relativeTolerance) && this.maximumSteps == other.maximumSteps;
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.absoluteTolerance);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.relativeTolerance);
        hash = hash * 31 + JodaBeanUtils.hashCode((int)this.maximumSteps);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("RootFinderConfig{");
        buf.append("absoluteTolerance").append('=').append(JodaBeanUtils.toString((Object)this.absoluteTolerance)).append(',').append(' ');
        buf.append("relativeTolerance").append('=').append(JodaBeanUtils.toString((Object)this.relativeTolerance)).append(',').append(' ');
        buf.append("maximumSteps").append('=').append(JodaBeanUtils.toString((Object)this.maximumSteps));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<RootFinderConfig> {
        private double absoluteTolerance;
        private double relativeTolerance;
        private int maximumSteps;

        private Builder() {
            RootFinderConfig.applyDefaults(this);
        }

        private Builder(RootFinderConfig beanToCopy) {
            this.absoluteTolerance = beanToCopy.getAbsoluteTolerance();
            this.relativeTolerance = beanToCopy.getRelativeTolerance();
            this.maximumSteps = beanToCopy.getMaximumSteps();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -402212778: {
                    return this.absoluteTolerance;
                }
                case 1517353633: {
                    return this.relativeTolerance;
                }
                case 715849959: {
                    return this.maximumSteps;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -402212778: {
                    this.absoluteTolerance = (Double)newValue;
                    break;
                }
                case 1517353633: {
                    this.relativeTolerance = (Double)newValue;
                    break;
                }
                case 715849959: {
                    this.maximumSteps = (Integer)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public RootFinderConfig build() {
            return new RootFinderConfig(this.absoluteTolerance, this.relativeTolerance, this.maximumSteps);
        }

        public Builder absoluteTolerance(double absoluteTolerance) {
            ArgChecker.notNegativeOrZero((double)absoluteTolerance, (String)"absoluteTolerance");
            this.absoluteTolerance = absoluteTolerance;
            return this;
        }

        public Builder relativeTolerance(double relativeTolerance) {
            ArgChecker.notNegativeOrZero((double)relativeTolerance, (String)"relativeTolerance");
            this.relativeTolerance = relativeTolerance;
            return this;
        }

        public Builder maximumSteps(int maximumSteps) {
            ArgChecker.notNegativeOrZero((int)maximumSteps, (String)"maximumSteps");
            this.maximumSteps = maximumSteps;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("RootFinderConfig.Builder{");
            buf.append("absoluteTolerance").append('=').append(JodaBeanUtils.toString((Object)this.absoluteTolerance)).append(',').append(' ');
            buf.append("relativeTolerance").append('=').append(JodaBeanUtils.toString((Object)this.relativeTolerance)).append(',').append(' ');
            buf.append("maximumSteps").append('=').append(JodaBeanUtils.toString((Object)this.maximumSteps));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Double> absoluteTolerance = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"absoluteTolerance", RootFinderConfig.class, Double.TYPE);
        private final MetaProperty<Double> relativeTolerance = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"relativeTolerance", RootFinderConfig.class, Double.TYPE);
        private final MetaProperty<Integer> maximumSteps = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"maximumSteps", RootFinderConfig.class, Integer.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"absoluteTolerance", "relativeTolerance", "maximumSteps"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -402212778: {
                    return this.absoluteTolerance;
                }
                case 1517353633: {
                    return this.relativeTolerance;
                }
                case 715849959: {
                    return this.maximumSteps;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends RootFinderConfig> beanType() {
            return RootFinderConfig.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Double> absoluteTolerance() {
            return this.absoluteTolerance;
        }

        public MetaProperty<Double> relativeTolerance() {
            return this.relativeTolerance;
        }

        public MetaProperty<Integer> maximumSteps() {
            return this.maximumSteps;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -402212778: {
                    return ((RootFinderConfig)bean).getAbsoluteTolerance();
                }
                case 1517353633: {
                    return ((RootFinderConfig)bean).getRelativeTolerance();
                }
                case 715849959: {
                    return ((RootFinderConfig)bean).getMaximumSteps();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

