/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.credit;

import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.data.MarketDataNotFoundException;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.market.curve.CurveId;
import com.opengamma.strata.market.curve.CurveName;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.CurrencyParameterSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.measure.credit.DefaultCreditRatesMarketDataLookup;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import com.opengamma.strata.pricer.credit.CreditCurveZeroRateSensitivity;
import com.opengamma.strata.pricer.credit.CreditDiscountFactors;
import com.opengamma.strata.pricer.credit.CreditRatesProvider;
import com.opengamma.strata.pricer.credit.ImmutableCreditRatesProvider;
import com.opengamma.strata.pricer.credit.LegalEntitySurvivalProbabilities;
import com.opengamma.strata.pricer.credit.RecoveryRates;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Optional;
import java.util.stream.Stream;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
final class DefaultLookupCreditRatesProvider
implements CreditRatesProvider,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final DefaultCreditRatesMarketDataLookup lookup;
    @PropertyDefinition(validate="notNull")
    private final MarketData marketData;
    private static final TypedMetaBean<DefaultLookupCreditRatesProvider> META_BEAN = LightMetaBean.of(DefaultLookupCreditRatesProvider.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"lookup", "marketData"}, (Object[])new Object[0]);
    private static final long serialVersionUID = 1L;

    public static DefaultLookupCreditRatesProvider of(DefaultCreditRatesMarketDataLookup lookup, MarketData marketData) {
        return new DefaultLookupCreditRatesProvider(lookup, marketData);
    }

    @ImmutableConstructor
    private DefaultLookupCreditRatesProvider(DefaultCreditRatesMarketDataLookup lookup, MarketData marketData) {
        this.lookup = (DefaultCreditRatesMarketDataLookup)ArgChecker.notNull((Object)lookup, (String)"lookup");
        this.marketData = (MarketData)ArgChecker.notNull((Object)marketData, (String)"marketData");
    }

    private Object readResolve() {
        return new DefaultLookupCreditRatesProvider(this.lookup, this.marketData);
    }

    public LocalDate getValuationDate() {
        return this.marketData.getValuationDate();
    }

    public LegalEntitySurvivalProbabilities survivalProbabilities(StandardId legalEntityId, Currency currency) {
        CurveId curveId = (CurveId)this.lookup.getCreditCurveIds().get((Object)Pair.of((Object)legalEntityId, (Object)currency));
        if (curveId == null) {
            throw new MarketDataNotFoundException("Unable to find credit curve: " + legalEntityId + ", " + currency);
        }
        Curve curve = (Curve)this.marketData.getValue((MarketDataId)curveId);
        CreditDiscountFactors survivalProbabilities = CreditDiscountFactors.of((Currency)currency, (LocalDate)this.getValuationDate(), (Curve)curve);
        return LegalEntitySurvivalProbabilities.of((StandardId)legalEntityId, (CreditDiscountFactors)survivalProbabilities);
    }

    public CreditDiscountFactors discountFactors(Currency currency) {
        CurveId curveId = (CurveId)this.lookup.getDiscountCurveIds().get((Object)currency);
        if (curveId == null) {
            throw new MarketDataNotFoundException("Unable to find discount curve: " + currency);
        }
        Curve curve = (Curve)this.marketData.getValue((MarketDataId)curveId);
        return CreditDiscountFactors.of((Currency)currency, (LocalDate)this.getValuationDate(), (Curve)curve);
    }

    public RecoveryRates recoveryRates(StandardId legalEntityId) {
        CurveId curveId = (CurveId)this.lookup.getRecoveryRateCurveIds().get((Object)legalEntityId);
        if (curveId == null) {
            throw new MarketDataNotFoundException("Unable to find recovery rate curve: " + legalEntityId);
        }
        Curve curve = (Curve)this.marketData.getValue((MarketDataId)curveId);
        return RecoveryRates.of((StandardId)legalEntityId, (LocalDate)this.getValuationDate(), (Curve)curve);
    }

    public CurrencyParameterSensitivities parameterSensitivity(PointSensitivities pointSensitivities) {
        CurrencyParameterSensitivities sens = CurrencyParameterSensitivities.empty();
        for (PointSensitivity point : pointSensitivities.getSensitivities()) {
            LegalEntitySurvivalProbabilities factors;
            CreditCurveZeroRateSensitivity pt;
            if (point instanceof CreditCurveZeroRateSensitivity) {
                pt = (CreditCurveZeroRateSensitivity)point;
                factors = this.survivalProbabilities(pt.getLegalEntityId(), pt.getCurveCurrency());
                sens = sens.combinedWith(factors.parameterSensitivity(pt));
                continue;
            }
            if (!(point instanceof ZeroRateSensitivity)) continue;
            pt = (ZeroRateSensitivity)point;
            factors = this.discountFactors(pt.getCurveCurrency());
            sens = sens.combinedWith(factors.parameterSensitivity((ZeroRateSensitivity)pt));
        }
        return sens;
    }

    public CurrencyParameterSensitivity singleCreditCurveParameterSensitivity(PointSensitivities pointSensitivities, StandardId legalEntityId, Currency currency) {
        CurrencyParameterSensitivities sens = CurrencyParameterSensitivities.empty();
        for (PointSensitivity point : pointSensitivities.getSensitivities()) {
            CreditCurveZeroRateSensitivity pt;
            if (!(point instanceof CreditCurveZeroRateSensitivity) || !(pt = (CreditCurveZeroRateSensitivity)point).getLegalEntityId().equals((Object)legalEntityId) || !pt.getCurrency().equals((Object)currency)) continue;
            LegalEntitySurvivalProbabilities factors = this.survivalProbabilities(pt.getLegalEntityId(), pt.getCurveCurrency());
            sens = sens.combinedWith(factors.parameterSensitivity(pt));
        }
        ArgChecker.isTrue((sens.size() == 1 ? 1 : 0) != 0, (String)"sensitivity must be unique");
        return (CurrencyParameterSensitivity)sens.getSensitivities().get(0);
    }

    public CurrencyParameterSensitivity singleDiscountCurveParameterSensitivity(PointSensitivities pointSensitivities, Currency currency) {
        CurrencyParameterSensitivities sens = CurrencyParameterSensitivities.empty();
        for (PointSensitivity point : pointSensitivities.getSensitivities()) {
            ZeroRateSensitivity pt;
            if (!(point instanceof ZeroRateSensitivity) || !(pt = (ZeroRateSensitivity)point).getCurrency().equals((Object)currency)) continue;
            CreditDiscountFactors factors = this.discountFactors(pt.getCurveCurrency());
            sens = sens.combinedWith(factors.parameterSensitivity(pt));
        }
        ArgChecker.isTrue((sens.size() == 1 ? 1 : 0) != 0, (String)"sensitivity must be unique");
        return (CurrencyParameterSensitivity)sens.getSensitivities().get(0);
    }

    public <T> Optional<T> findData(MarketDataName<T> name) {
        if (name instanceof CurveName) {
            return Stream.concat(this.lookup.getRecoveryRateCurveIds().values().stream(), Stream.concat(this.lookup.getCreditCurveIds().values().stream(), this.lookup.getDiscountCurveIds().values().stream())).filter(id -> id.getMarketDataName().equals((Object)name)).findFirst().flatMap(id -> this.marketData.findValue((MarketDataId)id)).map(v -> name.getMarketDataType().cast(v));
        }
        return Optional.empty();
    }

    public ImmutableCreditRatesProvider toImmutableCreditRatesProvider() {
        LocalDate valuationDate = this.getValuationDate();
        HashMap<Pair, LegalEntitySurvivalProbabilities> creditCurves = new HashMap<Pair, LegalEntitySurvivalProbabilities>();
        for (Pair pair : this.lookup.getCreditCurveIds().keySet()) {
            CurveId curveId = (CurveId)this.lookup.getCreditCurveIds().get((Object)pair);
            if (!this.marketData.containsValue((MarketDataId)curveId)) continue;
            Curve curve = (Curve)this.marketData.getValue((MarketDataId)curveId);
            CreditDiscountFactors survivalProbabilities = CreditDiscountFactors.of((Currency)((Currency)pair.getSecond()), (LocalDate)valuationDate, (Curve)curve);
            creditCurves.put(pair, LegalEntitySurvivalProbabilities.of((StandardId)((StandardId)pair.getFirst()), (CreditDiscountFactors)survivalProbabilities));
        }
        HashMap<Currency, CreditDiscountFactors> discountCurves = new HashMap<Currency, CreditDiscountFactors>();
        for (Currency currency : this.lookup.getDiscountCurveIds().keySet()) {
            CurveId curveId = (CurveId)this.lookup.getDiscountCurveIds().get((Object)currency);
            if (!this.marketData.containsValue((MarketDataId)curveId)) continue;
            Curve curve = (Curve)this.marketData.getValue((MarketDataId)curveId);
            discountCurves.put(currency, CreditDiscountFactors.of((Currency)currency, (LocalDate)valuationDate, (Curve)curve));
        }
        HashMap<StandardId, RecoveryRates> recoveryRateCurves = new HashMap<StandardId, RecoveryRates>();
        for (StandardId legalEntityId : this.lookup.getRecoveryRateCurveIds().keySet()) {
            CurveId curveId = (CurveId)this.lookup.getRecoveryRateCurveIds().get((Object)legalEntityId);
            if (!this.marketData.containsValue((MarketDataId)curveId)) continue;
            Curve curve = (Curve)this.marketData.getValue((MarketDataId)curveId);
            RecoveryRates recoveryRate = RecoveryRates.of((StandardId)legalEntityId, (LocalDate)valuationDate, (Curve)curve);
            recoveryRateCurves.put(legalEntityId, recoveryRate);
        }
        return ImmutableCreditRatesProvider.builder().valuationDate(valuationDate).creditCurves(creditCurves).discountCurves(discountCurves).recoveryRateCurves(recoveryRateCurves).build();
    }

    public static TypedMetaBean<DefaultLookupCreditRatesProvider> meta() {
        return META_BEAN;
    }

    public TypedMetaBean<DefaultLookupCreditRatesProvider> metaBean() {
        return META_BEAN;
    }

    public DefaultCreditRatesMarketDataLookup getLookup() {
        return this.lookup;
    }

    public MarketData getMarketData() {
        return this.marketData;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            DefaultLookupCreditRatesProvider other = (DefaultLookupCreditRatesProvider)obj;
            return JodaBeanUtils.equal((Object)this.lookup, (Object)other.lookup) && JodaBeanUtils.equal((Object)this.marketData, (Object)other.marketData);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.lookup);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.marketData);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("DefaultLookupCreditRatesProvider{");
        buf.append("lookup").append('=').append(JodaBeanUtils.toString((Object)this.lookup)).append(',').append(' ');
        buf.append("marketData").append('=').append(JodaBeanUtils.toString((Object)this.marketData));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

