/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.credit;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.measure.credit.CreditRatesMarketData;
import com.opengamma.strata.measure.credit.CreditRatesMarketDataLookup;
import com.opengamma.strata.pricer.credit.CreditRatesProvider;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
final class DefaultCreditRatesMarketData
implements CreditRatesMarketData,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final CreditRatesMarketDataLookup lookup;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final MarketData marketData;
    private final transient CreditRatesProvider creditRatesProvider;
    private static final TypedMetaBean<DefaultCreditRatesMarketData> META_BEAN = LightMetaBean.of(DefaultCreditRatesMarketData.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"lookup", "marketData"}, (Object[])new Object[0]);
    private static final long serialVersionUID = 1L;

    static DefaultCreditRatesMarketData of(CreditRatesMarketDataLookup lookup, MarketData marketData) {
        return new DefaultCreditRatesMarketData(lookup, marketData);
    }

    @ImmutableConstructor
    private DefaultCreditRatesMarketData(CreditRatesMarketDataLookup lookup, MarketData marketData) {
        this.lookup = (CreditRatesMarketDataLookup)ArgChecker.notNull((Object)lookup, (String)"lookup");
        this.marketData = (MarketData)ArgChecker.notNull((Object)marketData, (String)"marketData");
        this.creditRatesProvider = lookup.creditRatesProvider(marketData);
    }

    private Object readResolve() {
        return new DefaultCreditRatesMarketData(this.lookup, this.marketData);
    }

    @Override
    public CreditRatesMarketData withMarketData(MarketData marketData) {
        return DefaultCreditRatesMarketData.of(this.lookup, marketData);
    }

    @Override
    public CreditRatesProvider creditRatesProvider() {
        return this.creditRatesProvider;
    }

    public static TypedMetaBean<DefaultCreditRatesMarketData> meta() {
        return META_BEAN;
    }

    public TypedMetaBean<DefaultCreditRatesMarketData> metaBean() {
        return META_BEAN;
    }

    @Override
    public CreditRatesMarketDataLookup getLookup() {
        return this.lookup;
    }

    @Override
    public MarketData getMarketData() {
        return this.marketData;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            DefaultCreditRatesMarketData other = (DefaultCreditRatesMarketData)obj;
            return JodaBeanUtils.equal((Object)this.lookup, (Object)other.lookup) && JodaBeanUtils.equal((Object)this.marketData, (Object)other.marketData);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.lookup);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.marketData);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("DefaultCreditRatesMarketData{");
        buf.append("lookup").append('=').append(JodaBeanUtils.toString((Object)this.lookup)).append(',').append(' ');
        buf.append("marketData").append('=').append(JodaBeanUtils.toString((Object)this.marketData));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

