/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.credit;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.calc.runner.CalculationParameter;
import com.opengamma.strata.calc.runner.FunctionRequirements;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.ObservableSource;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.market.curve.CurveId;
import com.opengamma.strata.measure.credit.CreditRatesMarketData;
import com.opengamma.strata.measure.credit.CreditRatesScenarioMarketData;
import com.opengamma.strata.measure.credit.DefaultCreditRatesMarketData;
import com.opengamma.strata.measure.credit.DefaultCreditRatesMarketDataLookup;
import com.opengamma.strata.measure.credit.DefaultCreditRatesScenarioMarketData;
import com.opengamma.strata.pricer.credit.CreditRatesProvider;
import java.util.Map;

public interface CreditRatesMarketDataLookup
extends CalculationParameter {
    public static CreditRatesMarketDataLookup of(Map<Pair<StandardId, Currency>, CurveId> creditCurveIds, Map<Currency, CurveId> discountCurveIds, Map<StandardId, CurveId> recoveryRateCurveIds) {
        return DefaultCreditRatesMarketDataLookup.of(creditCurveIds, discountCurveIds, recoveryRateCurveIds, ObservableSource.NONE);
    }

    public static CreditRatesMarketDataLookup of(Map<Pair<StandardId, Currency>, CurveId> creditCurveIds, Map<Currency, CurveId> discountCurveIds, Map<StandardId, CurveId> recoveryRateCurveIds, ObservableSource observableSource) {
        return DefaultCreditRatesMarketDataLookup.of(creditCurveIds, discountCurveIds, recoveryRateCurveIds, observableSource);
    }

    default public Class<? extends CalculationParameter> queryType() {
        return CreditRatesMarketDataLookup.class;
    }

    public ImmutableSet<Currency> getDiscountCurrencies();

    public ImmutableSet<MarketDataId<?>> getDiscountMarketDataIds(Currency var1);

    public ImmutableSet<Pair<StandardId, Currency>> getCreditLegalEntities();

    public ImmutableSet<MarketDataId<?>> getCreditMarketDataIds(StandardId var1, Currency var2);

    public ImmutableSet<StandardId> getRecoveryRateLegalEntities();

    public ImmutableSet<MarketDataId<?>> getRecoveryRateMarketDataIds(StandardId var1);

    public FunctionRequirements requirements(StandardId var1, Currency var2);

    default public CreditRatesScenarioMarketData marketDataView(ScenarioMarketData marketData) {
        return DefaultCreditRatesScenarioMarketData.of(this, marketData);
    }

    default public CreditRatesMarketData marketDataView(MarketData marketData) {
        return DefaultCreditRatesMarketData.of(this, marketData);
    }

    public CreditRatesProvider creditRatesProvider(MarketData var1);
}

