/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.cms;

import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.basics.index.RateIndex;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.data.scenario.MultiCurrencyScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.measure.cms.CmsSabrExtrapolationParams;
import com.opengamma.strata.measure.rate.RatesScenarioMarketData;
import com.opengamma.strata.measure.swaption.SwaptionScenarioMarketData;
import com.opengamma.strata.pricer.cms.SabrExtrapolationReplicationCmsLegPricer;
import com.opengamma.strata.pricer.cms.SabrExtrapolationReplicationCmsPeriodPricer;
import com.opengamma.strata.pricer.cms.SabrExtrapolationReplicationCmsProductPricer;
import com.opengamma.strata.pricer.cms.SabrExtrapolationReplicationCmsTradePricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.sensitivity.MarketQuoteSensitivityCalculator;
import com.opengamma.strata.pricer.swaption.SabrSwaptionVolatilities;
import com.opengamma.strata.pricer.swaption.SwaptionVolatilities;
import com.opengamma.strata.product.cms.ResolvedCmsTrade;

final class CmsMeasureCalculations {
    private static final MarketQuoteSensitivityCalculator MARKET_QUOTE_SENS = MarketQuoteSensitivityCalculator.DEFAULT;
    private static final double ONE_BASIS_POINT = 1.0E-4;
    private final SabrExtrapolationReplicationCmsTradePricer tradePricer;

    CmsMeasureCalculations(CmsSabrExtrapolationParams cmsParams) {
        SabrExtrapolationReplicationCmsPeriodPricer periodPricer = SabrExtrapolationReplicationCmsPeriodPricer.of((double)cmsParams.getCutOffStrike(), (double)cmsParams.getMu());
        SabrExtrapolationReplicationCmsLegPricer legPricer = new SabrExtrapolationReplicationCmsLegPricer(periodPricer);
        SabrExtrapolationReplicationCmsProductPricer productPricer = new SabrExtrapolationReplicationCmsProductPricer(legPricer);
        SabrExtrapolationReplicationCmsTradePricer tradePricer = new SabrExtrapolationReplicationCmsTradePricer(productPricer);
        this.tradePricer = (SabrExtrapolationReplicationCmsTradePricer)ArgChecker.notNull((Object)tradePricer, (String)"tradePricer");
    }

    CmsMeasureCalculations(SabrExtrapolationReplicationCmsTradePricer tradePricer) {
        this.tradePricer = (SabrExtrapolationReplicationCmsTradePricer)ArgChecker.notNull((Object)tradePricer, (String)"tradePricer");
    }

    MultiCurrencyScenarioArray presentValue(ResolvedCmsTrade trade, RatesScenarioMarketData ratesMarketData, SwaptionScenarioMarketData swaptionMarketData) {
        RateIndex index = CmsMeasureCalculations.cmsLegRateIndex(trade);
        return MultiCurrencyScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.presentValue(trade, ratesMarketData.scenario(i).ratesProvider(), swaptionMarketData.scenario(i).volatilities(index)));
    }

    MultiCurrencyAmount presentValue(ResolvedCmsTrade trade, RatesProvider ratesProvider, SwaptionVolatilities volatilities) {
        return this.tradePricer.presentValue(trade, ratesProvider, CmsMeasureCalculations.checkSabr(volatilities));
    }

    MultiCurrencyScenarioArray pv01RatesCalibratedSum(ResolvedCmsTrade trade, RatesScenarioMarketData ratesMarketData, SwaptionScenarioMarketData swaptionMarketData) {
        RateIndex index = CmsMeasureCalculations.cmsLegRateIndex(trade);
        return MultiCurrencyScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.pv01RatesCalibratedSum(trade, ratesMarketData.scenario(i).ratesProvider(), swaptionMarketData.scenario(i).volatilities(index)));
    }

    MultiCurrencyAmount pv01RatesCalibratedSum(ResolvedCmsTrade trade, RatesProvider ratesProvider, SwaptionVolatilities volatilities) {
        PointSensitivities pointSensitivity = this.pointSensitivity(trade, ratesProvider, volatilities);
        return ratesProvider.parameterSensitivity(pointSensitivity).total().multipliedBy(1.0E-4);
    }

    ScenarioArray<CurrencyParameterSensitivities> pv01RatesCalibratedBucketed(ResolvedCmsTrade trade, RatesScenarioMarketData ratesMarketData, SwaptionScenarioMarketData swaptionMarketData) {
        RateIndex index = CmsMeasureCalculations.cmsLegRateIndex(trade);
        return ScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.pv01RatesCalibratedBucketed(trade, ratesMarketData.scenario(i).ratesProvider(), swaptionMarketData.scenario(i).volatilities(index)));
    }

    CurrencyParameterSensitivities pv01RatesCalibratedBucketed(ResolvedCmsTrade trade, RatesProvider ratesProvider, SwaptionVolatilities volatilities) {
        PointSensitivities pointSensitivity = this.pointSensitivity(trade, ratesProvider, volatilities);
        return ratesProvider.parameterSensitivity(pointSensitivity).multipliedBy(1.0E-4);
    }

    MultiCurrencyScenarioArray pv01RatesMarketQuoteSum(ResolvedCmsTrade trade, RatesScenarioMarketData ratesMarketData, SwaptionScenarioMarketData swaptionMarketData) {
        RateIndex index = CmsMeasureCalculations.cmsLegRateIndex(trade);
        return MultiCurrencyScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.pv01RatesMarketQuoteSum(trade, ratesMarketData.scenario(i).ratesProvider(), swaptionMarketData.scenario(i).volatilities(index)));
    }

    MultiCurrencyAmount pv01RatesMarketQuoteSum(ResolvedCmsTrade trade, RatesProvider ratesProvider, SwaptionVolatilities volatilities) {
        PointSensitivities pointSensitivity = this.pointSensitivity(trade, ratesProvider, volatilities);
        CurrencyParameterSensitivities parameterSensitivity = ratesProvider.parameterSensitivity(pointSensitivity);
        return MARKET_QUOTE_SENS.sensitivity(parameterSensitivity, ratesProvider).total().multipliedBy(1.0E-4);
    }

    ScenarioArray<CurrencyParameterSensitivities> pv01RatesMarketQuoteBucketed(ResolvedCmsTrade trade, RatesScenarioMarketData ratesMarketData, SwaptionScenarioMarketData swaptionMarketData) {
        RateIndex index = CmsMeasureCalculations.cmsLegRateIndex(trade);
        return ScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.pv01RatesMarketQuoteBucketed(trade, ratesMarketData.scenario(i).ratesProvider(), swaptionMarketData.scenario(i).volatilities(index)));
    }

    CurrencyParameterSensitivities pv01RatesMarketQuoteBucketed(ResolvedCmsTrade trade, RatesProvider ratesProvider, SwaptionVolatilities volatilities) {
        PointSensitivities pointSensitivity = this.pointSensitivity(trade, ratesProvider, volatilities);
        CurrencyParameterSensitivities parameterSensitivity = ratesProvider.parameterSensitivity(pointSensitivity);
        return MARKET_QUOTE_SENS.sensitivity(parameterSensitivity, ratesProvider).multipliedBy(1.0E-4);
    }

    private PointSensitivities pointSensitivity(ResolvedCmsTrade trade, RatesProvider ratesProvider, SwaptionVolatilities volatilities) {
        return this.tradePricer.presentValueSensitivityRates(trade, ratesProvider, CmsMeasureCalculations.checkSabr(volatilities));
    }

    MultiCurrencyScenarioArray currencyExposure(ResolvedCmsTrade trade, RatesScenarioMarketData ratesMarketData, SwaptionScenarioMarketData swaptionMarketData) {
        RateIndex index = CmsMeasureCalculations.cmsLegRateIndex(trade);
        return MultiCurrencyScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.currencyExposure(trade, ratesMarketData.scenario(i).ratesProvider(), swaptionMarketData.scenario(i).volatilities(index)));
    }

    MultiCurrencyAmount currencyExposure(ResolvedCmsTrade trade, RatesProvider ratesProvider, SwaptionVolatilities volatilities) {
        return this.tradePricer.currencyExposure(trade, ratesProvider, CmsMeasureCalculations.checkSabr(volatilities));
    }

    MultiCurrencyScenarioArray currentCash(ResolvedCmsTrade trade, RatesScenarioMarketData ratesMarketData, SwaptionScenarioMarketData swaptionMarketData) {
        RateIndex index = CmsMeasureCalculations.cmsLegRateIndex(trade);
        return MultiCurrencyScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.currentCash(trade, ratesMarketData.scenario(i).ratesProvider(), swaptionMarketData.scenario(i).volatilities(index)));
    }

    MultiCurrencyAmount currentCash(ResolvedCmsTrade trade, RatesProvider ratesProvider, SwaptionVolatilities volatilities) {
        return this.tradePricer.currentCash(trade, ratesProvider, CmsMeasureCalculations.checkSabr(volatilities));
    }

    static RateIndex cmsLegRateIndex(ResolvedCmsTrade trade) {
        return trade.getProduct().getCmsLeg().getUnderlyingIndex();
    }

    private static SabrSwaptionVolatilities checkSabr(SwaptionVolatilities volatilities) {
        if (volatilities instanceof SabrSwaptionVolatilities) {
            return (SabrSwaptionVolatilities)volatilities;
        }
        throw new IllegalArgumentException("Swaption volatiliies for pricing CMS must be for SABR model, but was: " + volatilities.getVolatilityType());
    }
}

