/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.capfloor;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.calc.Measure;
import com.opengamma.strata.calc.runner.CalculationFunction;
import com.opengamma.strata.calc.runner.CalculationParameters;
import com.opengamma.strata.calc.runner.FunctionRequirements;
import com.opengamma.strata.collect.result.FailureReason;
import com.opengamma.strata.collect.result.Result;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.measure.Measures;
import com.opengamma.strata.measure.capfloor.IborCapFloorMarketDataLookup;
import com.opengamma.strata.measure.capfloor.IborCapFloorMeasureCalculations;
import com.opengamma.strata.measure.capfloor.IborCapFloorScenarioMarketData;
import com.opengamma.strata.measure.rate.RatesMarketDataLookup;
import com.opengamma.strata.measure.rate.RatesScenarioMarketData;
import com.opengamma.strata.product.capfloor.IborCapFloor;
import com.opengamma.strata.product.capfloor.IborCapFloorTrade;
import com.opengamma.strata.product.capfloor.ResolvedIborCapFloorTrade;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class IborCapFloorTradeCalculationFunction
implements CalculationFunction<IborCapFloorTrade> {
    private static final ImmutableMap<Measure, SingleMeasureCalculation> CALCULATORS = ImmutableMap.builder().put((Object)Measures.PRESENT_VALUE, IborCapFloorMeasureCalculations.DEFAULT::presentValue).put((Object)Measures.PV01_CALIBRATED_SUM, IborCapFloorMeasureCalculations.DEFAULT::pv01RatesCalibratedSum).put((Object)Measures.PV01_CALIBRATED_BUCKETED, IborCapFloorMeasureCalculations.DEFAULT::pv01RatesCalibratedBucketed).put((Object)Measures.PV01_MARKET_QUOTE_SUM, IborCapFloorMeasureCalculations.DEFAULT::pv01RatesMarketQuoteSum).put((Object)Measures.PV01_MARKET_QUOTE_BUCKETED, IborCapFloorMeasureCalculations.DEFAULT::pv01RatesMarketQuoteBucketed).put((Object)Measures.CURRENCY_EXPOSURE, IborCapFloorMeasureCalculations.DEFAULT::currencyExposure).put((Object)Measures.CURRENT_CASH, IborCapFloorMeasureCalculations.DEFAULT::currentCash).put((Object)Measures.RESOLVED_TARGET, (rt, smd, m) -> rt).build();
    private static final ImmutableSet<Measure> MEASURES = CALCULATORS.keySet();

    public Class<IborCapFloorTrade> targetType() {
        return IborCapFloorTrade.class;
    }

    public Set<Measure> supportedMeasures() {
        return MEASURES;
    }

    public Optional<String> identifier(IborCapFloorTrade target) {
        return target.getInfo().getId().map(id -> id.toString());
    }

    public Currency naturalCurrency(IborCapFloorTrade trade, ReferenceData refData) {
        return trade.getProduct().getCapFloorLeg().getCurrency();
    }

    public FunctionRequirements requirements(IborCapFloorTrade trade, Set<Measure> measures, CalculationParameters parameters, ReferenceData refData) {
        IborCapFloor product = trade.getProduct();
        ImmutableSet currencies = product.allPaymentCurrencies();
        ImmutableSet indices = product.allIndices();
        RatesMarketDataLookup ratesLookup = (RatesMarketDataLookup)parameters.getParameter(RatesMarketDataLookup.class);
        FunctionRequirements ratesReqs = ratesLookup.requirements((Set<Currency>)currencies, (Set<? extends Index>)indices);
        IborCapFloorMarketDataLookup capFloorLookup = (IborCapFloorMarketDataLookup)parameters.getParameter(IborCapFloorMarketDataLookup.class);
        FunctionRequirements capFloorReqs = capFloorLookup.requirements(product.getCapFloorLeg().getIndex());
        return ratesReqs.combinedWith(capFloorReqs);
    }

    public Map<Measure, Result<?>> calculate(IborCapFloorTrade trade, Set<Measure> measures, CalculationParameters parameters, ScenarioMarketData scenarioMarketData, ReferenceData refData) {
        ResolvedIborCapFloorTrade resolved = trade.resolve(refData);
        RatesMarketDataLookup ratesLookup = (RatesMarketDataLookup)parameters.getParameter(RatesMarketDataLookup.class);
        RatesScenarioMarketData ratesMarketData = ratesLookup.marketDataView(scenarioMarketData);
        IborCapFloorMarketDataLookup capFloorLookup = (IborCapFloorMarketDataLookup)parameters.getParameter(IborCapFloorMarketDataLookup.class);
        IborCapFloorScenarioMarketData capFloorMarketData = capFloorLookup.marketDataView(scenarioMarketData);
        HashMap results = new HashMap();
        for (Measure measure : measures) {
            results.put(measure, this.calculate(measure, resolved, ratesMarketData, capFloorMarketData));
        }
        return results;
    }

    private Result<?> calculate(Measure measure, ResolvedIborCapFloorTrade trade, RatesScenarioMarketData ratesMarketData, IborCapFloorScenarioMarketData capFloorMarketData) {
        SingleMeasureCalculation calculator = (SingleMeasureCalculation)CALCULATORS.get((Object)measure);
        if (calculator == null) {
            return Result.failure((FailureReason)FailureReason.UNSUPPORTED, (String)"Unsupported measure for IborCapFloorTrade: {}", (Object[])new Object[]{measure});
        }
        return Result.of(() -> calculator.calculate(trade, ratesMarketData, capFloorMarketData));
    }

    @FunctionalInterface
    static interface SingleMeasureCalculation {
        public Object calculate(ResolvedIborCapFloorTrade var1, RatesScenarioMarketData var2, IborCapFloorScenarioMarketData var3);
    }
}

