/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.capfloor;

import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.data.scenario.MultiCurrencyScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.measure.capfloor.IborCapFloorScenarioMarketData;
import com.opengamma.strata.measure.rate.RatesScenarioMarketData;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletVolatilities;
import com.opengamma.strata.pricer.capfloor.VolatilityIborCapFloorTradePricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.sensitivity.MarketQuoteSensitivityCalculator;
import com.opengamma.strata.product.capfloor.ResolvedIborCapFloorTrade;

final class IborCapFloorMeasureCalculations {
    public static final IborCapFloorMeasureCalculations DEFAULT = new IborCapFloorMeasureCalculations(VolatilityIborCapFloorTradePricer.DEFAULT);
    private static final MarketQuoteSensitivityCalculator MARKET_QUOTE_SENS = MarketQuoteSensitivityCalculator.DEFAULT;
    private static final double ONE_BASIS_POINT = 1.0E-4;
    private final VolatilityIborCapFloorTradePricer tradePricer;

    IborCapFloorMeasureCalculations(VolatilityIborCapFloorTradePricer tradePricer) {
        this.tradePricer = (VolatilityIborCapFloorTradePricer)ArgChecker.notNull((Object)tradePricer, (String)"tradePricer");
    }

    MultiCurrencyScenarioArray presentValue(ResolvedIborCapFloorTrade trade, RatesScenarioMarketData ratesMarketData, IborCapFloorScenarioMarketData capFloorMarketData) {
        IborIndex index = trade.getProduct().getCapFloorLeg().getIndex();
        return MultiCurrencyScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.presentValue(trade, ratesMarketData.scenario(i).ratesProvider(), capFloorMarketData.scenario(i).volatilities(index)));
    }

    MultiCurrencyAmount presentValue(ResolvedIborCapFloorTrade trade, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        return this.tradePricer.presentValue(trade, ratesProvider, volatilities);
    }

    MultiCurrencyScenarioArray pv01RatesCalibratedSum(ResolvedIborCapFloorTrade trade, RatesScenarioMarketData ratesMarketData, IborCapFloorScenarioMarketData capFloorMarketData) {
        IborIndex index = trade.getProduct().getCapFloorLeg().getIndex();
        return MultiCurrencyScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.pv01RatesCalibratedSum(trade, ratesMarketData.scenario(i).ratesProvider(), capFloorMarketData.scenario(i).volatilities(index)));
    }

    MultiCurrencyAmount pv01RatesCalibratedSum(ResolvedIborCapFloorTrade trade, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        PointSensitivities pointSensitivity = this.pointSensitivity(trade, ratesProvider, volatilities);
        return ratesProvider.parameterSensitivity(pointSensitivity).total().multipliedBy(1.0E-4);
    }

    ScenarioArray<CurrencyParameterSensitivities> pv01RatesCalibratedBucketed(ResolvedIborCapFloorTrade trade, RatesScenarioMarketData ratesMarketData, IborCapFloorScenarioMarketData capFloorMarketData) {
        IborIndex index = trade.getProduct().getCapFloorLeg().getIndex();
        return ScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.pv01RatesCalibratedBucketed(trade, ratesMarketData.scenario(i).ratesProvider(), capFloorMarketData.scenario(i).volatilities(index)));
    }

    CurrencyParameterSensitivities pv01RatesCalibratedBucketed(ResolvedIborCapFloorTrade trade, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        PointSensitivities pointSensitivity = this.pointSensitivity(trade, ratesProvider, volatilities);
        return ratesProvider.parameterSensitivity(pointSensitivity).multipliedBy(1.0E-4);
    }

    MultiCurrencyScenarioArray pv01RatesMarketQuoteSum(ResolvedIborCapFloorTrade trade, RatesScenarioMarketData ratesMarketData, IborCapFloorScenarioMarketData capFloorMarketData) {
        IborIndex index = trade.getProduct().getCapFloorLeg().getIndex();
        return MultiCurrencyScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.pv01RatesMarketQuoteSum(trade, ratesMarketData.scenario(i).ratesProvider(), capFloorMarketData.scenario(i).volatilities(index)));
    }

    MultiCurrencyAmount pv01RatesMarketQuoteSum(ResolvedIborCapFloorTrade trade, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        PointSensitivities pointSensitivity = this.pointSensitivity(trade, ratesProvider, volatilities);
        CurrencyParameterSensitivities parameterSensitivity = ratesProvider.parameterSensitivity(pointSensitivity);
        return MARKET_QUOTE_SENS.sensitivity(parameterSensitivity, ratesProvider).total().multipliedBy(1.0E-4);
    }

    ScenarioArray<CurrencyParameterSensitivities> pv01RatesMarketQuoteBucketed(ResolvedIborCapFloorTrade trade, RatesScenarioMarketData ratesMarketData, IborCapFloorScenarioMarketData capFloorMarketData) {
        IborIndex index = trade.getProduct().getCapFloorLeg().getIndex();
        return ScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.pv01RatesMarketQuoteBucketed(trade, ratesMarketData.scenario(i).ratesProvider(), capFloorMarketData.scenario(i).volatilities(index)));
    }

    CurrencyParameterSensitivities pv01RatesMarketQuoteBucketed(ResolvedIborCapFloorTrade trade, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        PointSensitivities pointSensitivity = this.pointSensitivity(trade, ratesProvider, volatilities);
        CurrencyParameterSensitivities parameterSensitivity = ratesProvider.parameterSensitivity(pointSensitivity);
        return MARKET_QUOTE_SENS.sensitivity(parameterSensitivity, ratesProvider).multipliedBy(1.0E-4);
    }

    private PointSensitivities pointSensitivity(ResolvedIborCapFloorTrade trade, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        return this.tradePricer.presentValueSensitivityRates(trade, ratesProvider, volatilities);
    }

    MultiCurrencyScenarioArray currencyExposure(ResolvedIborCapFloorTrade trade, RatesScenarioMarketData ratesMarketData, IborCapFloorScenarioMarketData capFloorMarketData) {
        IborIndex index = trade.getProduct().getCapFloorLeg().getIndex();
        return MultiCurrencyScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.currencyExposure(trade, ratesMarketData.scenario(i).ratesProvider(), capFloorMarketData.scenario(i).volatilities(index)));
    }

    MultiCurrencyAmount currencyExposure(ResolvedIborCapFloorTrade trade, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        return this.tradePricer.currencyExposure(trade, ratesProvider, volatilities);
    }

    MultiCurrencyScenarioArray currentCash(ResolvedIborCapFloorTrade trade, RatesScenarioMarketData ratesMarketData, IborCapFloorScenarioMarketData capFloorMarketData) {
        IborIndex index = trade.getProduct().getCapFloorLeg().getIndex();
        return MultiCurrencyScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.currentCash(trade, ratesMarketData.scenario(i).ratesProvider(), capFloorMarketData.scenario(i).volatilities(index)));
    }

    MultiCurrencyAmount currentCash(ResolvedIborCapFloorTrade trade, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        return this.tradePricer.currentCash(trade, ratesProvider, volatilities);
    }
}

