/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.capfloor;

import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.measure.capfloor.IborCapFloorMarketData;
import com.opengamma.strata.measure.capfloor.IborCapFloorMarketDataLookup;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletVolatilities;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
final class DefaultIborCapFloorMarketData
implements IborCapFloorMarketData,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final IborCapFloorMarketDataLookup lookup;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final MarketData marketData;
    private static final TypedMetaBean<DefaultIborCapFloorMarketData> META_BEAN = LightMetaBean.of(DefaultIborCapFloorMarketData.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"lookup", "marketData"}, (Object[])new Object[0]);
    private static final long serialVersionUID = 1L;

    public static DefaultIborCapFloorMarketData of(IborCapFloorMarketDataLookup lookup, MarketData marketData) {
        return new DefaultIborCapFloorMarketData(lookup, marketData);
    }

    @ImmutableConstructor
    private DefaultIborCapFloorMarketData(IborCapFloorMarketDataLookup lookup, MarketData marketData) {
        this.lookup = (IborCapFloorMarketDataLookup)ArgChecker.notNull((Object)lookup, (String)"lookup");
        this.marketData = (MarketData)ArgChecker.notNull((Object)marketData, (String)"marketData");
    }

    @Override
    public IborCapFloorMarketData withMarketData(MarketData marketData) {
        return DefaultIborCapFloorMarketData.of(this.lookup, marketData);
    }

    @Override
    public IborCapletFloorletVolatilities volatilities(IborIndex index) {
        return this.lookup.volatilities(index, this.marketData);
    }

    public static TypedMetaBean<DefaultIborCapFloorMarketData> meta() {
        return META_BEAN;
    }

    public TypedMetaBean<DefaultIborCapFloorMarketData> metaBean() {
        return META_BEAN;
    }

    @Override
    public IborCapFloorMarketDataLookup getLookup() {
        return this.lookup;
    }

    @Override
    public MarketData getMarketData() {
        return this.marketData;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            DefaultIborCapFloorMarketData other = (DefaultIborCapFloorMarketData)obj;
            return JodaBeanUtils.equal((Object)this.lookup, (Object)other.lookup) && JodaBeanUtils.equal((Object)this.marketData, (Object)other.marketData);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.lookup);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.marketData);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("DefaultIborCapFloorMarketData{");
        buf.append("lookup").append('=').append(JodaBeanUtils.toString((Object)this.lookup)).append(',').append(' ');
        buf.append("marketData").append('=').append(JodaBeanUtils.toString((Object)this.marketData));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

