/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.bond;

import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.data.scenario.CurrencyScenarioArray;
import com.opengamma.strata.data.scenario.MultiCurrencyScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.measure.bond.FixedCouponBondMeasureCalculations;
import com.opengamma.strata.measure.bond.LegalEntityDiscountingMarketDataLookup;
import com.opengamma.strata.pricer.bond.DiscountingFixedCouponBondTradePricer;
import com.opengamma.strata.pricer.bond.LegalEntityDiscountingProvider;
import com.opengamma.strata.product.bond.ResolvedFixedCouponBondTrade;

public class FixedCouponBondTradeCalculations {
    public static final FixedCouponBondTradeCalculations DEFAULT = new FixedCouponBondTradeCalculations(DiscountingFixedCouponBondTradePricer.DEFAULT);
    private final FixedCouponBondMeasureCalculations calc;

    public FixedCouponBondTradeCalculations(DiscountingFixedCouponBondTradePricer tradePricer) {
        this.calc = new FixedCouponBondMeasureCalculations(tradePricer);
    }

    public CurrencyScenarioArray presentValue(ResolvedFixedCouponBondTrade trade, LegalEntityDiscountingMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.presentValue(trade, lookup.marketDataView(marketData));
    }

    public CurrencyAmount presentValue(ResolvedFixedCouponBondTrade trade, LegalEntityDiscountingProvider ratesProvider) {
        return this.calc.presentValue(trade, ratesProvider);
    }

    public MultiCurrencyScenarioArray pv01CalibratedSum(ResolvedFixedCouponBondTrade trade, LegalEntityDiscountingMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.pv01CalibratedSum(trade, lookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount pv01CalibratedSum(ResolvedFixedCouponBondTrade trade, LegalEntityDiscountingProvider ratesProvider) {
        return this.calc.pv01CalibratedSum(trade, ratesProvider);
    }

    public ScenarioArray<CurrencyParameterSensitivities> pv01CalibratedBucketed(ResolvedFixedCouponBondTrade trade, LegalEntityDiscountingMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.pv01CalibratedBucketed(trade, lookup.marketDataView(marketData));
    }

    public CurrencyParameterSensitivities pv01CalibratedBucketed(ResolvedFixedCouponBondTrade trade, LegalEntityDiscountingProvider ratesProvider) {
        return this.calc.pv01CalibratedBucketed(trade, ratesProvider);
    }

    public MultiCurrencyScenarioArray pv01MarketQuoteSum(ResolvedFixedCouponBondTrade trade, LegalEntityDiscountingMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.pv01MarketQuoteSum(trade, lookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount pv01MarketQuoteSum(ResolvedFixedCouponBondTrade trade, LegalEntityDiscountingProvider ratesProvider) {
        return this.calc.pv01MarketQuoteSum(trade, ratesProvider);
    }

    public ScenarioArray<CurrencyParameterSensitivities> pv01MarketQuoteBucketed(ResolvedFixedCouponBondTrade trade, LegalEntityDiscountingMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.pv01MarketQuoteBucketed(trade, lookup.marketDataView(marketData));
    }

    public CurrencyParameterSensitivities pv01MarketQuoteBucketed(ResolvedFixedCouponBondTrade trade, LegalEntityDiscountingProvider ratesProvider) {
        return this.calc.pv01MarketQuoteBucketed(trade, ratesProvider);
    }

    public MultiCurrencyScenarioArray currencyExposure(ResolvedFixedCouponBondTrade trade, LegalEntityDiscountingMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.currencyExposure(trade, lookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount currencyExposure(ResolvedFixedCouponBondTrade trade, LegalEntityDiscountingProvider ratesProvider) {
        return this.calc.currencyExposure(trade, ratesProvider);
    }

    public CurrencyScenarioArray currentCash(ResolvedFixedCouponBondTrade trade, LegalEntityDiscountingMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.currentCash(trade, lookup.marketDataView(marketData));
    }

    public CurrencyAmount currentCash(ResolvedFixedCouponBondTrade trade, LegalEntityDiscountingProvider ratesProvider) {
        return this.calc.currentCash(trade, ratesProvider);
    }
}

