/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.bond;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.Resolvable;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.calc.Measure;
import com.opengamma.strata.calc.runner.CalculationFunction;
import com.opengamma.strata.calc.runner.CalculationParameters;
import com.opengamma.strata.calc.runner.FunctionRequirements;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.result.FailureReason;
import com.opengamma.strata.collect.result.Result;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.measure.Measures;
import com.opengamma.strata.measure.bond.FixedCouponBondMeasureCalculations;
import com.opengamma.strata.measure.bond.LegalEntityDiscountingMarketDataLookup;
import com.opengamma.strata.measure.bond.LegalEntityDiscountingScenarioMarketData;
import com.opengamma.strata.product.SecuritizedProductPortfolioItem;
import com.opengamma.strata.product.bond.FixedCouponBond;
import com.opengamma.strata.product.bond.FixedCouponBondPosition;
import com.opengamma.strata.product.bond.FixedCouponBondTrade;
import com.opengamma.strata.product.bond.ResolvedFixedCouponBondTrade;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class FixedCouponBondTradeCalculationFunction<T extends SecuritizedProductPortfolioItem<FixedCouponBond> & Resolvable<ResolvedFixedCouponBondTrade>>
implements CalculationFunction<T> {
    public static final FixedCouponBondTradeCalculationFunction<FixedCouponBondTrade> TRADE = new FixedCouponBondTradeCalculationFunction<FixedCouponBondTrade>(FixedCouponBondTrade.class);
    public static final FixedCouponBondTradeCalculationFunction<FixedCouponBondPosition> POSITION = new FixedCouponBondTradeCalculationFunction<FixedCouponBondPosition>(FixedCouponBondPosition.class);
    private static final ImmutableMap<Measure, SingleMeasureCalculation> CALCULATORS = ImmutableMap.builder().put((Object)Measures.PRESENT_VALUE, FixedCouponBondMeasureCalculations.DEFAULT::presentValue).put((Object)Measures.PV01_CALIBRATED_SUM, FixedCouponBondMeasureCalculations.DEFAULT::pv01CalibratedSum).put((Object)Measures.PV01_CALIBRATED_BUCKETED, FixedCouponBondMeasureCalculations.DEFAULT::pv01CalibratedBucketed).put((Object)Measures.PV01_MARKET_QUOTE_SUM, FixedCouponBondMeasureCalculations.DEFAULT::pv01MarketQuoteSum).put((Object)Measures.PV01_MARKET_QUOTE_BUCKETED, FixedCouponBondMeasureCalculations.DEFAULT::pv01MarketQuoteBucketed).put((Object)Measures.CURRENCY_EXPOSURE, FixedCouponBondMeasureCalculations.DEFAULT::currencyExposure).put((Object)Measures.CURRENT_CASH, FixedCouponBondMeasureCalculations.DEFAULT::currentCash).put((Object)Measures.RESOLVED_TARGET, (rt, smd) -> rt).build();
    private static final ImmutableSet<Measure> MEASURES = CALCULATORS.keySet();
    private final Class<T> targetType;

    private FixedCouponBondTradeCalculationFunction(Class<T> targetType) {
        this.targetType = (Class)ArgChecker.notNull(targetType, (String)"targetType");
    }

    public Class<T> targetType() {
        return this.targetType;
    }

    public Set<Measure> supportedMeasures() {
        return MEASURES;
    }

    public Optional<String> identifier(T target) {
        return target.getInfo().getId().map(id -> id.toString());
    }

    public Currency naturalCurrency(T target, ReferenceData refData) {
        return target.getCurrency();
    }

    public FunctionRequirements requirements(T target, Set<Measure> measures, CalculationParameters parameters, ReferenceData refData) {
        FixedCouponBond product = (FixedCouponBond)target.getProduct();
        LegalEntityDiscountingMarketDataLookup bondLookup = (LegalEntityDiscountingMarketDataLookup)parameters.getParameter(LegalEntityDiscountingMarketDataLookup.class);
        return bondLookup.requirements(product.getSecurityId(), product.getLegalEntityId(), product.getCurrency());
    }

    public Map<Measure, Result<?>> calculate(T target, Set<Measure> measures, CalculationParameters parameters, ScenarioMarketData scenarioMarketData, ReferenceData refData) {
        ResolvedFixedCouponBondTrade resolved = (ResolvedFixedCouponBondTrade)((Resolvable)target).resolve(refData);
        LegalEntityDiscountingMarketDataLookup bondLookup = (LegalEntityDiscountingMarketDataLookup)parameters.getParameter(LegalEntityDiscountingMarketDataLookup.class);
        LegalEntityDiscountingScenarioMarketData marketData = bondLookup.marketDataView(scenarioMarketData);
        HashMap results = new HashMap();
        for (Measure measure : measures) {
            results.put(measure, this.calculate(measure, resolved, marketData));
        }
        return results;
    }

    private Result<?> calculate(Measure measure, ResolvedFixedCouponBondTrade resolved, LegalEntityDiscountingScenarioMarketData marketData) {
        SingleMeasureCalculation calculator = (SingleMeasureCalculation)CALCULATORS.get((Object)measure);
        if (calculator == null) {
            return Result.failure((FailureReason)FailureReason.UNSUPPORTED, (String)"Unsupported measure for FixedCouponBond: {}", (Object[])new Object[]{measure});
        }
        return Result.of(() -> calculator.calculate(resolved, marketData));
    }

    @FunctionalInterface
    static interface SingleMeasureCalculation {
        public Object calculate(ResolvedFixedCouponBondTrade var1, LegalEntityDiscountingScenarioMarketData var2);
    }
}

