/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.bond;

import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.data.scenario.CurrencyScenarioArray;
import com.opengamma.strata.data.scenario.MultiCurrencyScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.measure.bond.LegalEntityDiscountingScenarioMarketData;
import com.opengamma.strata.pricer.bond.DiscountingFixedCouponBondTradePricer;
import com.opengamma.strata.pricer.bond.LegalEntityDiscountingProvider;
import com.opengamma.strata.pricer.sensitivity.MarketQuoteSensitivityCalculator;
import com.opengamma.strata.product.bond.ResolvedFixedCouponBondTrade;

final class FixedCouponBondMeasureCalculations {
    public static final FixedCouponBondMeasureCalculations DEFAULT = new FixedCouponBondMeasureCalculations(DiscountingFixedCouponBondTradePricer.DEFAULT);
    private static final MarketQuoteSensitivityCalculator MARKET_QUOTE_SENS = MarketQuoteSensitivityCalculator.DEFAULT;
    private static final double ONE_BASIS_POINT = 1.0E-4;
    private final DiscountingFixedCouponBondTradePricer tradePricer;

    FixedCouponBondMeasureCalculations(DiscountingFixedCouponBondTradePricer tradePricer) {
        this.tradePricer = (DiscountingFixedCouponBondTradePricer)ArgChecker.notNull((Object)tradePricer, (String)"tradePricer");
    }

    CurrencyScenarioArray presentValue(ResolvedFixedCouponBondTrade trade, LegalEntityDiscountingScenarioMarketData marketData) {
        return CurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.presentValue(trade, marketData.scenario(i).discountingProvider()));
    }

    CurrencyAmount presentValue(ResolvedFixedCouponBondTrade trade, LegalEntityDiscountingProvider discountingProvider) {
        return this.tradePricer.presentValue(trade, discountingProvider);
    }

    MultiCurrencyScenarioArray pv01CalibratedSum(ResolvedFixedCouponBondTrade trade, LegalEntityDiscountingScenarioMarketData marketData) {
        return MultiCurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01CalibratedSum(trade, marketData.scenario(i).discountingProvider()));
    }

    MultiCurrencyAmount pv01CalibratedSum(ResolvedFixedCouponBondTrade trade, LegalEntityDiscountingProvider discountingProvider) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivity(trade, discountingProvider);
        return discountingProvider.parameterSensitivity(pointSensitivity).total().multipliedBy(1.0E-4);
    }

    ScenarioArray<CurrencyParameterSensitivities> pv01CalibratedBucketed(ResolvedFixedCouponBondTrade trade, LegalEntityDiscountingScenarioMarketData marketData) {
        return ScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01CalibratedBucketed(trade, marketData.scenario(i).discountingProvider()));
    }

    CurrencyParameterSensitivities pv01CalibratedBucketed(ResolvedFixedCouponBondTrade trade, LegalEntityDiscountingProvider discountingProvider) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivity(trade, discountingProvider);
        return discountingProvider.parameterSensitivity(pointSensitivity).multipliedBy(1.0E-4);
    }

    MultiCurrencyScenarioArray pv01MarketQuoteSum(ResolvedFixedCouponBondTrade trade, LegalEntityDiscountingScenarioMarketData marketData) {
        return MultiCurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01MarketQuoteSum(trade, marketData.scenario(i).discountingProvider()));
    }

    MultiCurrencyAmount pv01MarketQuoteSum(ResolvedFixedCouponBondTrade trade, LegalEntityDiscountingProvider ratesProvider) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivity(trade, ratesProvider);
        CurrencyParameterSensitivities parameterSensitivity = ratesProvider.parameterSensitivity(pointSensitivity);
        return MARKET_QUOTE_SENS.sensitivity(parameterSensitivity, ratesProvider).total().multipliedBy(1.0E-4);
    }

    ScenarioArray<CurrencyParameterSensitivities> pv01MarketQuoteBucketed(ResolvedFixedCouponBondTrade trade, LegalEntityDiscountingScenarioMarketData marketData) {
        return ScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01MarketQuoteBucketed(trade, marketData.scenario(i).discountingProvider()));
    }

    CurrencyParameterSensitivities pv01MarketQuoteBucketed(ResolvedFixedCouponBondTrade trade, LegalEntityDiscountingProvider ratesProvider) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivity(trade, ratesProvider);
        CurrencyParameterSensitivities parameterSensitivity = ratesProvider.parameterSensitivity(pointSensitivity);
        return MARKET_QUOTE_SENS.sensitivity(parameterSensitivity, ratesProvider).multipliedBy(1.0E-4);
    }

    MultiCurrencyScenarioArray currencyExposure(ResolvedFixedCouponBondTrade trade, LegalEntityDiscountingScenarioMarketData marketData) {
        return MultiCurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.currencyExposure(trade, marketData.scenario(i).discountingProvider()));
    }

    MultiCurrencyAmount currencyExposure(ResolvedFixedCouponBondTrade trade, LegalEntityDiscountingProvider discountingProvider) {
        return this.tradePricer.currencyExposure(trade, discountingProvider);
    }

    CurrencyScenarioArray currentCash(ResolvedFixedCouponBondTrade trade, LegalEntityDiscountingScenarioMarketData marketData) {
        return CurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.currentCash(trade, marketData.scenario(i).discountingProvider()));
    }

    CurrencyAmount currentCash(ResolvedFixedCouponBondTrade trade, LegalEntityDiscountingProvider discountingProvider) {
        return this.tradePricer.currentCash(trade, discountingProvider.getValuationDate());
    }
}

