/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.bond;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.data.MarketDataNotFoundException;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.market.curve.CurveId;
import com.opengamma.strata.market.curve.LegalEntityGroup;
import com.opengamma.strata.market.curve.RepoGroup;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.measure.bond.DefaultLegalEntityDiscountingMarketDataLookup;
import com.opengamma.strata.pricer.DiscountFactors;
import com.opengamma.strata.pricer.bond.ImmutableLegalEntityDiscountingProvider;
import com.opengamma.strata.pricer.bond.IssuerCurveDiscountFactors;
import com.opengamma.strata.pricer.bond.IssuerCurveZeroRateSensitivity;
import com.opengamma.strata.pricer.bond.LegalEntityDiscountingProvider;
import com.opengamma.strata.pricer.bond.RepoCurveDiscountFactors;
import com.opengamma.strata.pricer.bond.RepoCurveZeroRateSensitivity;
import com.opengamma.strata.product.LegalEntityId;
import com.opengamma.strata.product.SecurityId;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Optional;
import java.util.stream.Stream;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
final class DefaultLookupLegalEntityDiscountingProvider
implements LegalEntityDiscountingProvider,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final DefaultLegalEntityDiscountingMarketDataLookup lookup;
    @PropertyDefinition(validate="notNull")
    private final MarketData marketData;
    private static final TypedMetaBean<DefaultLookupLegalEntityDiscountingProvider> META_BEAN = LightMetaBean.of(DefaultLookupLegalEntityDiscountingProvider.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"lookup", "marketData"}, (Object[])new Object[0]);
    private static final long serialVersionUID = 1L;

    public static DefaultLookupLegalEntityDiscountingProvider of(DefaultLegalEntityDiscountingMarketDataLookup lookup, MarketData marketData) {
        return new DefaultLookupLegalEntityDiscountingProvider(lookup, marketData);
    }

    @ImmutableConstructor
    private DefaultLookupLegalEntityDiscountingProvider(DefaultLegalEntityDiscountingMarketDataLookup lookup, MarketData marketData) {
        this.lookup = (DefaultLegalEntityDiscountingMarketDataLookup)ArgChecker.notNull((Object)lookup, (String)"lookup");
        this.marketData = (MarketData)ArgChecker.notNull((Object)marketData, (String)"marketData");
    }

    public LocalDate getValuationDate() {
        return this.marketData.getValuationDate();
    }

    public RepoCurveDiscountFactors repoCurveDiscountFactors(SecurityId securityId, LegalEntityId issuerId, Currency currency) {
        RepoGroup repoGroup = (RepoGroup)this.lookup.getRepoCurveSecurityGroups().get((Object)securityId);
        if (repoGroup == null && (repoGroup = (RepoGroup)this.lookup.getRepoCurveGroups().get((Object)issuerId)) == null) {
            throw new MarketDataNotFoundException("Unable to find repo curve mapping for ID: " + securityId + ", " + issuerId);
        }
        return this.repoCurveDiscountFactors(repoGroup, currency);
    }

    public RepoCurveDiscountFactors repoCurveDiscountFactors(LegalEntityId issuerId, Currency currency) {
        RepoGroup repoGroup = (RepoGroup)this.lookup.getRepoCurveGroups().get((Object)issuerId);
        if (repoGroup == null) {
            throw new MarketDataNotFoundException("Unable to find repo curve mapping for ID: " + issuerId);
        }
        return this.repoCurveDiscountFactors(repoGroup, currency);
    }

    private RepoCurveDiscountFactors repoCurveDiscountFactors(RepoGroup repoGroup, Currency currency) {
        CurveId curveId = (CurveId)this.lookup.getRepoCurves().get((Object)Pair.of((Object)repoGroup, (Object)currency));
        if (curveId == null) {
            throw new MarketDataNotFoundException("Unable to find repo curve: " + repoGroup + ", " + currency);
        }
        Curve curve = (Curve)this.marketData.getValue((MarketDataId)curveId);
        DiscountFactors df = DiscountFactors.of((Currency)currency, (LocalDate)this.getValuationDate(), (Curve)curve);
        return RepoCurveDiscountFactors.of((DiscountFactors)df, (RepoGroup)repoGroup);
    }

    public IssuerCurveDiscountFactors issuerCurveDiscountFactors(LegalEntityId issuerId, Currency currency) {
        LegalEntityGroup legalEntityGroup = (LegalEntityGroup)this.lookup.getIssuerCurveGroups().get((Object)issuerId);
        if (legalEntityGroup == null) {
            throw new MarketDataNotFoundException("Unable to find issuer curve mapping for ID: " + issuerId);
        }
        return this.issuerCurveDiscountFactors(legalEntityGroup, currency);
    }

    private IssuerCurveDiscountFactors issuerCurveDiscountFactors(LegalEntityGroup legalEntityGroup, Currency currency) {
        CurveId curveId = (CurveId)this.lookup.getIssuerCurves().get((Object)Pair.of((Object)legalEntityGroup, (Object)currency));
        if (curveId == null) {
            throw new MarketDataNotFoundException("Unable to find issuer curve: " + legalEntityGroup + ", " + currency);
        }
        Curve curve = (Curve)this.marketData.getValue((MarketDataId)curveId);
        DiscountFactors df = DiscountFactors.of((Currency)currency, (LocalDate)this.getValuationDate(), (Curve)curve);
        return IssuerCurveDiscountFactors.of((DiscountFactors)df, (LegalEntityGroup)legalEntityGroup);
    }

    public CurrencyParameterSensitivities parameterSensitivity(PointSensitivities pointSensitivities) {
        CurrencyParameterSensitivities sens = CurrencyParameterSensitivities.empty();
        for (PointSensitivity point : pointSensitivities.getSensitivities()) {
            RepoCurveDiscountFactors factors;
            RepoCurveZeroRateSensitivity pt;
            if (point instanceof RepoCurveZeroRateSensitivity) {
                pt = (RepoCurveZeroRateSensitivity)point;
                factors = this.repoCurveDiscountFactors(pt.getRepoGroup(), pt.getCurveCurrency());
                sens = sens.combinedWith(factors.parameterSensitivity(pt));
                continue;
            }
            if (!(point instanceof IssuerCurveZeroRateSensitivity)) continue;
            pt = (IssuerCurveZeroRateSensitivity)point;
            factors = this.issuerCurveDiscountFactors(pt.getLegalEntityGroup(), pt.getCurveCurrency());
            sens = sens.combinedWith(factors.parameterSensitivity((IssuerCurveZeroRateSensitivity)pt));
        }
        return sens;
    }

    public <T> T data(MarketDataId<T> key) {
        return (T)this.marketData.getValue(key);
    }

    public <T> Optional<T> findData(MarketDataName<T> name) {
        return Stream.concat(this.lookup.getRepoCurves().values().stream(), this.lookup.getIssuerCurves().values().stream()).filter(id -> id.getMarketDataName().equals((Object)name)).findFirst().flatMap(id -> this.marketData.findValue((MarketDataId)id)).map(v -> name.getMarketDataType().cast(v));
    }

    public ImmutableLegalEntityDiscountingProvider toImmutableLegalEntityDiscountingProvider() {
        HashMap<Pair, DiscountFactors> repoCurves = new HashMap<Pair, DiscountFactors>();
        for (Pair pair : this.lookup.getRepoCurves().keySet()) {
            CurveId curveId = (CurveId)this.lookup.getRepoCurves().get((Object)pair);
            if (!this.marketData.containsValue((MarketDataId)curveId)) continue;
            Curve curve = (Curve)this.marketData.getValue((MarketDataId)curveId);
            repoCurves.put(pair, DiscountFactors.of((Currency)((Currency)pair.getSecond()), (LocalDate)this.getValuationDate(), (Curve)curve));
        }
        HashMap<Pair, DiscountFactors> issuerCurves = new HashMap<Pair, DiscountFactors>();
        for (Pair pair : this.lookup.getIssuerCurves().keySet()) {
            CurveId curveId = (CurveId)this.lookup.getIssuerCurves().get((Object)pair);
            if (!this.marketData.containsValue((MarketDataId)curveId)) continue;
            Curve curve = (Curve)this.marketData.getValue((MarketDataId)curveId);
            issuerCurves.put(pair, DiscountFactors.of((Currency)((Currency)pair.getSecond()), (LocalDate)this.getValuationDate(), (Curve)curve));
        }
        return ImmutableLegalEntityDiscountingProvider.builder().valuationDate(this.getValuationDate()).repoCurveSecurityGroups(this.lookup.getRepoCurveSecurityGroups()).repoCurveGroups(this.lookup.getRepoCurveGroups()).repoCurves(repoCurves).issuerCurveGroups(this.lookup.getIssuerCurveGroups()).issuerCurves(issuerCurves).build();
    }

    public static TypedMetaBean<DefaultLookupLegalEntityDiscountingProvider> meta() {
        return META_BEAN;
    }

    public TypedMetaBean<DefaultLookupLegalEntityDiscountingProvider> metaBean() {
        return META_BEAN;
    }

    public DefaultLegalEntityDiscountingMarketDataLookup getLookup() {
        return this.lookup;
    }

    public MarketData getMarketData() {
        return this.marketData;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            DefaultLookupLegalEntityDiscountingProvider other = (DefaultLookupLegalEntityDiscountingProvider)obj;
            return JodaBeanUtils.equal((Object)this.lookup, (Object)other.lookup) && JodaBeanUtils.equal((Object)this.marketData, (Object)other.marketData);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.lookup);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.marketData);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("DefaultLookupLegalEntityDiscountingProvider{");
        buf.append("lookup").append('=').append(JodaBeanUtils.toString((Object)this.lookup)).append(',').append(' ');
        buf.append("marketData").append('=').append(JodaBeanUtils.toString((Object)this.marketData));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

