/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.bond;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.calc.runner.FunctionRequirements;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.NamedMarketDataId;
import com.opengamma.strata.data.ObservableSource;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.market.curve.CurveId;
import com.opengamma.strata.market.curve.LegalEntityGroup;
import com.opengamma.strata.market.curve.RepoGroup;
import com.opengamma.strata.measure.bond.DefaultLookupLegalEntityDiscountingProvider;
import com.opengamma.strata.measure.bond.LegalEntityDiscountingMarketDataLookup;
import com.opengamma.strata.pricer.bond.LegalEntityDiscountingProvider;
import com.opengamma.strata.product.LegalEntityId;
import com.opengamma.strata.product.SecurityId;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
final class DefaultLegalEntityDiscountingMarketDataLookup
implements LegalEntityDiscountingMarketDataLookup,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<SecurityId, RepoGroup> repoCurveSecurityGroups;
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<LegalEntityId, RepoGroup> repoCurveGroups;
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<Pair<RepoGroup, Currency>, CurveId> repoCurves;
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<LegalEntityId, LegalEntityGroup> issuerCurveGroups;
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<Pair<LegalEntityGroup, Currency>, CurveId> issuerCurves;
    @PropertyDefinition(validate="notNull")
    private final ObservableSource observableSource;
    private static final TypedMetaBean<DefaultLegalEntityDiscountingMarketDataLookup> META_BEAN = LightMetaBean.of(DefaultLegalEntityDiscountingMarketDataLookup.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"repoCurveSecurityGroups", "repoCurveGroups", "repoCurves", "issuerCurveGroups", "issuerCurves", "observableSource"}, (Object[])new Object[]{ImmutableMap.of(), ImmutableMap.of(), ImmutableMap.of(), ImmutableMap.of(), ImmutableMap.of(), null});
    private static final long serialVersionUID = 1L;

    public static <T extends NamedMarketDataId<Curve>> DefaultLegalEntityDiscountingMarketDataLookup of(Map<SecurityId, RepoGroup> repoCurveSecurityGroups, Map<LegalEntityId, RepoGroup> repoCurveGroups, Map<Pair<RepoGroup, Currency>, CurveId> repoCurveIds, Map<LegalEntityId, LegalEntityGroup> issuerCurveGroups, Map<Pair<LegalEntityGroup, Currency>, CurveId> issuerCurveIds, ObservableSource obsSource) {
        return new DefaultLegalEntityDiscountingMarketDataLookup(repoCurveSecurityGroups, repoCurveGroups, repoCurveIds, issuerCurveGroups, issuerCurveIds, obsSource);
    }

    public static DefaultLegalEntityDiscountingMarketDataLookup of(Map<LegalEntityId, RepoGroup> repoCurveGroups, Map<Pair<RepoGroup, Currency>, CurveId> repoCurveIds, ObservableSource obsSource) {
        return new DefaultLegalEntityDiscountingMarketDataLookup((Map<SecurityId, RepoGroup>)ImmutableMap.of(), repoCurveGroups, repoCurveIds, (Map<LegalEntityId, LegalEntityGroup>)ImmutableMap.of(), (Map<Pair<LegalEntityGroup, Currency>, CurveId>)ImmutableMap.of(), obsSource);
    }

    @ImmutableValidator
    private void validate() {
        HashSet uniqueRepoGroups = new HashSet(this.repoCurveGroups.values());
        uniqueRepoGroups.addAll(this.repoCurveSecurityGroups.values());
        Set uniqueRepoCurves = (Set)this.repoCurves.keySet().stream().map(p -> (RepoGroup)p.getFirst()).collect(Guavate.toImmutableSet());
        if (!uniqueRepoCurves.containsAll(uniqueRepoGroups)) {
            throw new IllegalArgumentException("Repo curve groups defined without matching curve mappings: " + Sets.difference(uniqueRepoGroups, (Set)uniqueRepoCurves));
        }
        HashSet uniqueIssuerGroups = new HashSet(this.issuerCurveGroups.values());
        Set uniqueIssuerCurves = (Set)this.issuerCurves.keySet().stream().map(p -> (LegalEntityGroup)p.getFirst()).collect(Guavate.toImmutableSet());
        if (!uniqueIssuerCurves.containsAll(uniqueIssuerGroups)) {
            throw new IllegalArgumentException("Issuer curve groups defined without matching curve mappings: " + Sets.difference(uniqueIssuerGroups, (Set)uniqueIssuerCurves));
        }
    }

    @Override
    public FunctionRequirements requirements(SecurityId securityId, LegalEntityId issuerId, Currency currency) {
        RepoGroup repoKey = (RepoGroup)this.repoCurveSecurityGroups.get((Object)securityId);
        if (repoKey == null) {
            repoKey = (RepoGroup)this.repoCurveGroups.get((Object)issuerId);
        }
        if (repoKey == null) {
            throw new IllegalArgumentException(Messages.format((String)"Legal entity discounting lookup has no repo curve defined for '{}' and '{}'", (Object[])new Object[]{securityId, issuerId}));
        }
        CurveId repoCurveId = (CurveId)this.repoCurves.get((Object)Pair.of((Object)repoKey, (Object)currency));
        if (repoCurveId == null) {
            throw new IllegalArgumentException(Messages.format((String)"Legal entity discounting lookup has no repo curve defined for '{}' and '{}'", (Object[])new Object[]{securityId, issuerId}));
        }
        LegalEntityGroup issuerKey = (LegalEntityGroup)this.issuerCurveGroups.get((Object)issuerId);
        if (issuerKey == null) {
            throw new IllegalArgumentException(Messages.format((String)"Legal entity discounting lookup has no issuer curve defined for '{}'", (Object)issuerId));
        }
        CurveId issuerCurveId = (CurveId)this.issuerCurves.get((Object)Pair.of((Object)issuerKey, (Object)currency));
        if (issuerCurveId == null) {
            throw new IllegalArgumentException(Messages.format((String)"Legal entity discounting lookup has no issuer curve defined for '{}'", (Object)issuerId));
        }
        return FunctionRequirements.builder().valueRequirements((Set)ImmutableSet.of((Object)repoCurveId, (Object)issuerCurveId)).outputCurrencies(new Currency[]{currency}).observableSource(this.observableSource).build();
    }

    @Override
    public FunctionRequirements requirements(LegalEntityId issuerId, Currency currency) {
        RepoGroup repoKey = (RepoGroup)this.repoCurveGroups.get((Object)issuerId);
        if (repoKey == null) {
            throw new IllegalArgumentException(Messages.format((String)"Legal entity discounting lookup has no repo curve defined for '{}'", (Object)issuerId));
        }
        CurveId repoCurveId = (CurveId)this.repoCurves.get((Object)Pair.of((Object)repoKey, (Object)currency));
        if (repoCurveId == null) {
            throw new IllegalArgumentException(Messages.format((String)"Legal entity discounting lookup has no repo curve defined for '{}'", (Object)issuerId));
        }
        return FunctionRequirements.builder().valueRequirements((Set)ImmutableSet.of((Object)repoCurveId)).outputCurrencies(new Currency[]{currency}).observableSource(this.observableSource).build();
    }

    @Override
    public LegalEntityDiscountingProvider discountingProvider(MarketData marketData) {
        return DefaultLookupLegalEntityDiscountingProvider.of(this, marketData);
    }

    public static TypedMetaBean<DefaultLegalEntityDiscountingMarketDataLookup> meta() {
        return META_BEAN;
    }

    private DefaultLegalEntityDiscountingMarketDataLookup(Map<SecurityId, RepoGroup> repoCurveSecurityGroups, Map<LegalEntityId, RepoGroup> repoCurveGroups, Map<Pair<RepoGroup, Currency>, CurveId> repoCurves, Map<LegalEntityId, LegalEntityGroup> issuerCurveGroups, Map<Pair<LegalEntityGroup, Currency>, CurveId> issuerCurves, ObservableSource observableSource) {
        JodaBeanUtils.notNull(repoCurveSecurityGroups, (String)"repoCurveSecurityGroups");
        JodaBeanUtils.notNull(repoCurveGroups, (String)"repoCurveGroups");
        JodaBeanUtils.notNull(repoCurves, (String)"repoCurves");
        JodaBeanUtils.notNull(issuerCurveGroups, (String)"issuerCurveGroups");
        JodaBeanUtils.notNull(issuerCurves, (String)"issuerCurves");
        JodaBeanUtils.notNull((Object)observableSource, (String)"observableSource");
        this.repoCurveSecurityGroups = ImmutableMap.copyOf(repoCurveSecurityGroups);
        this.repoCurveGroups = ImmutableMap.copyOf(repoCurveGroups);
        this.repoCurves = ImmutableMap.copyOf(repoCurves);
        this.issuerCurveGroups = ImmutableMap.copyOf(issuerCurveGroups);
        this.issuerCurves = ImmutableMap.copyOf(issuerCurves);
        this.observableSource = observableSource;
        this.validate();
    }

    public TypedMetaBean<DefaultLegalEntityDiscountingMarketDataLookup> metaBean() {
        return META_BEAN;
    }

    public ImmutableMap<SecurityId, RepoGroup> getRepoCurveSecurityGroups() {
        return this.repoCurveSecurityGroups;
    }

    public ImmutableMap<LegalEntityId, RepoGroup> getRepoCurveGroups() {
        return this.repoCurveGroups;
    }

    public ImmutableMap<Pair<RepoGroup, Currency>, CurveId> getRepoCurves() {
        return this.repoCurves;
    }

    public ImmutableMap<LegalEntityId, LegalEntityGroup> getIssuerCurveGroups() {
        return this.issuerCurveGroups;
    }

    public ImmutableMap<Pair<LegalEntityGroup, Currency>, CurveId> getIssuerCurves() {
        return this.issuerCurves;
    }

    public ObservableSource getObservableSource() {
        return this.observableSource;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            DefaultLegalEntityDiscountingMarketDataLookup other = (DefaultLegalEntityDiscountingMarketDataLookup)obj;
            return JodaBeanUtils.equal(this.repoCurveSecurityGroups, other.repoCurveSecurityGroups) && JodaBeanUtils.equal(this.repoCurveGroups, other.repoCurveGroups) && JodaBeanUtils.equal(this.repoCurves, other.repoCurves) && JodaBeanUtils.equal(this.issuerCurveGroups, other.issuerCurveGroups) && JodaBeanUtils.equal(this.issuerCurves, other.issuerCurves) && JodaBeanUtils.equal((Object)this.observableSource, (Object)other.observableSource);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.repoCurveSecurityGroups);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.repoCurveGroups);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.repoCurves);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.issuerCurveGroups);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.issuerCurves);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.observableSource);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(224);
        buf.append("DefaultLegalEntityDiscountingMarketDataLookup{");
        buf.append("repoCurveSecurityGroups").append('=').append(JodaBeanUtils.toString(this.repoCurveSecurityGroups)).append(',').append(' ');
        buf.append("repoCurveGroups").append('=').append(JodaBeanUtils.toString(this.repoCurveGroups)).append(',').append(' ');
        buf.append("repoCurves").append('=').append(JodaBeanUtils.toString(this.repoCurves)).append(',').append(' ');
        buf.append("issuerCurveGroups").append('=').append(JodaBeanUtils.toString(this.issuerCurveGroups)).append(',').append(' ');
        buf.append("issuerCurves").append('=').append(JodaBeanUtils.toString(this.issuerCurves)).append(',').append(' ');
        buf.append("observableSource").append('=').append(JodaBeanUtils.toString((Object)this.observableSource));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

