/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.bond;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.calc.runner.FunctionRequirements;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.MarketDataNotFoundException;
import com.opengamma.strata.measure.bond.BondFutureOptionMarketDataLookup;
import com.opengamma.strata.pricer.bond.BondFutureVolatilities;
import com.opengamma.strata.pricer.bond.BondFutureVolatilitiesId;
import com.opengamma.strata.product.SecurityId;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
final class DefaultBondFutureOptionMarketDataLookup
implements BondFutureOptionMarketDataLookup,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<SecurityId, BondFutureVolatilitiesId> volatilityIds;
    private static final TypedMetaBean<DefaultBondFutureOptionMarketDataLookup> META_BEAN = LightMetaBean.of(DefaultBondFutureOptionMarketDataLookup.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"volatilityIds"}, (Object[])new Object[]{ImmutableMap.of()});
    private static final long serialVersionUID = 1L;

    public static DefaultBondFutureOptionMarketDataLookup of(SecurityId securityId, BondFutureVolatilitiesId volatilityId) {
        return new DefaultBondFutureOptionMarketDataLookup((Map<SecurityId, BondFutureVolatilitiesId>)ImmutableMap.of((Object)securityId, (Object)volatilityId));
    }

    public static DefaultBondFutureOptionMarketDataLookup of(Map<SecurityId, BondFutureVolatilitiesId> volatilityIds) {
        return new DefaultBondFutureOptionMarketDataLookup(volatilityIds);
    }

    @Override
    public ImmutableSet<SecurityId> getVolatilitySecurityIds() {
        return this.volatilityIds.keySet();
    }

    @Override
    public ImmutableSet<MarketDataId<?>> getVolatilityIds(SecurityId securityId) {
        BondFutureVolatilitiesId id = (BondFutureVolatilitiesId)this.volatilityIds.get((Object)securityId);
        if (id == null) {
            throw new IllegalArgumentException(this.msgSecurityNotFound(securityId));
        }
        return ImmutableSet.of((Object)id);
    }

    @Override
    public FunctionRequirements requirements(Set<SecurityId> securityIds) {
        HashSet<Object> volIds = new HashSet<Object>();
        for (SecurityId securityId : securityIds) {
            if (!this.volatilityIds.keySet().contains((Object)securityId)) {
                throw new IllegalArgumentException(this.msgSecurityNotFound(securityId));
            }
            volIds.add(this.volatilityIds.get((Object)securityId));
        }
        return FunctionRequirements.builder().valueRequirements(volIds).build();
    }

    @Override
    public BondFutureVolatilities volatilities(SecurityId securityId, MarketData marketData) {
        BondFutureVolatilitiesId volatilityId = (BondFutureVolatilitiesId)this.volatilityIds.get((Object)securityId);
        if (volatilityId == null) {
            throw new MarketDataNotFoundException(this.msgSecurityNotFound(securityId));
        }
        return (BondFutureVolatilities)marketData.getValue((MarketDataId)volatilityId);
    }

    private String msgSecurityNotFound(SecurityId securityId) {
        return Messages.format((String)"BondFutureOption lookup has no volatilities defined for security ID '{}'", (Object)securityId);
    }

    public static TypedMetaBean<DefaultBondFutureOptionMarketDataLookup> meta() {
        return META_BEAN;
    }

    private DefaultBondFutureOptionMarketDataLookup(Map<SecurityId, BondFutureVolatilitiesId> volatilityIds) {
        JodaBeanUtils.notNull(volatilityIds, (String)"volatilityIds");
        this.volatilityIds = ImmutableMap.copyOf(volatilityIds);
    }

    public TypedMetaBean<DefaultBondFutureOptionMarketDataLookup> metaBean() {
        return META_BEAN;
    }

    public ImmutableMap<SecurityId, BondFutureVolatilitiesId> getVolatilityIds() {
        return this.volatilityIds;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            DefaultBondFutureOptionMarketDataLookup other = (DefaultBondFutureOptionMarketDataLookup)obj;
            return JodaBeanUtils.equal(this.volatilityIds, other.volatilityIds);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.volatilityIds);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("DefaultBondFutureOptionMarketDataLookup{");
        buf.append("volatilityIds").append('=').append(JodaBeanUtils.toString(this.volatilityIds));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

