/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.bond;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.Resolvable;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.calc.Measure;
import com.opengamma.strata.calc.runner.CalculationFunction;
import com.opengamma.strata.calc.runner.CalculationParameters;
import com.opengamma.strata.calc.runner.FunctionRequirements;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.result.FailureReason;
import com.opengamma.strata.collect.result.Result;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.measure.Measures;
import com.opengamma.strata.measure.bond.CapitalIndexedBondMeasureCalculations;
import com.opengamma.strata.measure.bond.LegalEntityDiscountingMarketDataLookup;
import com.opengamma.strata.measure.bond.LegalEntityDiscountingScenarioMarketData;
import com.opengamma.strata.measure.rate.RatesMarketDataLookup;
import com.opengamma.strata.measure.rate.RatesScenarioMarketData;
import com.opengamma.strata.product.LegalEntityId;
import com.opengamma.strata.product.SecuritizedProductPortfolioItem;
import com.opengamma.strata.product.SecurityId;
import com.opengamma.strata.product.bond.CapitalIndexedBond;
import com.opengamma.strata.product.bond.CapitalIndexedBondPosition;
import com.opengamma.strata.product.bond.CapitalIndexedBondTrade;
import com.opengamma.strata.product.bond.ResolvedCapitalIndexedBondTrade;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class CapitalIndexedBondTradeCalculationFunction<T extends SecuritizedProductPortfolioItem<CapitalIndexedBond> & Resolvable<ResolvedCapitalIndexedBondTrade>>
implements CalculationFunction<T> {
    public static final CapitalIndexedBondTradeCalculationFunction<CapitalIndexedBondTrade> TRADE = new CapitalIndexedBondTradeCalculationFunction<CapitalIndexedBondTrade>(CapitalIndexedBondTrade.class);
    public static final CapitalIndexedBondTradeCalculationFunction<CapitalIndexedBondPosition> POSITION = new CapitalIndexedBondTradeCalculationFunction<CapitalIndexedBondPosition>(CapitalIndexedBondPosition.class);
    private static final ImmutableMap<Measure, SingleMeasureCalculation> CALCULATORS = ImmutableMap.builder().put((Object)Measures.PRESENT_VALUE, CapitalIndexedBondMeasureCalculations.DEFAULT::presentValue).put((Object)Measures.PV01_CALIBRATED_SUM, CapitalIndexedBondMeasureCalculations.DEFAULT::pv01CalibratedSum).put((Object)Measures.PV01_CALIBRATED_BUCKETED, CapitalIndexedBondMeasureCalculations.DEFAULT::pv01CalibratedBucketed).put((Object)Measures.CURRENCY_EXPOSURE, CapitalIndexedBondMeasureCalculations.DEFAULT::currencyExposure).put((Object)Measures.CURRENT_CASH, CapitalIndexedBondMeasureCalculations.DEFAULT::currentCash).put((Object)Measures.RESOLVED_TARGET, (rt, smd1, smd2) -> rt).build();
    private static final ImmutableSet<Measure> MEASURES = CALCULATORS.keySet();
    private final Class<T> targetType;

    private CapitalIndexedBondTradeCalculationFunction(Class<T> targetType) {
        this.targetType = (Class)ArgChecker.notNull(targetType, (String)"targetType");
    }

    public Class<T> targetType() {
        return this.targetType;
    }

    public Set<Measure> supportedMeasures() {
        return MEASURES;
    }

    public Optional<String> identifier(T target) {
        return target.getInfo().getId().map(id -> id.toString());
    }

    public Currency naturalCurrency(T target, ReferenceData refData) {
        return target.getCurrency();
    }

    public FunctionRequirements requirements(T target, Set<Measure> measures, CalculationParameters parameters, ReferenceData refData) {
        CapitalIndexedBond product = (CapitalIndexedBond)target.getProduct();
        Currency currency = product.getCurrency();
        SecurityId securityId = product.getSecurityId();
        LegalEntityId legalEntityId = product.getLegalEntityId();
        RatesMarketDataLookup ratesLookup = (RatesMarketDataLookup)parameters.getParameter(RatesMarketDataLookup.class);
        FunctionRequirements ratesReqs = ratesLookup.requirements((Set<Currency>)ImmutableSet.of(), (Set<? extends Index>)ImmutableSet.of((Object)product.getRateCalculation().getIndex()));
        LegalEntityDiscountingMarketDataLookup ledLookup = (LegalEntityDiscountingMarketDataLookup)parameters.getParameter(LegalEntityDiscountingMarketDataLookup.class);
        FunctionRequirements ledReqs = ledLookup.requirements(securityId, legalEntityId, currency);
        return ratesReqs.combinedWith(ledReqs);
    }

    public Map<Measure, Result<?>> calculate(T target, Set<Measure> measures, CalculationParameters parameters, ScenarioMarketData scenarioMarketData, ReferenceData refData) {
        ResolvedCapitalIndexedBondTrade resolved = (ResolvedCapitalIndexedBondTrade)((Resolvable)target).resolve(refData);
        RatesMarketDataLookup ratesLookup = (RatesMarketDataLookup)parameters.getParameter(RatesMarketDataLookup.class);
        RatesScenarioMarketData ratesMarketData = ratesLookup.marketDataView(scenarioMarketData);
        LegalEntityDiscountingMarketDataLookup ledLookup = (LegalEntityDiscountingMarketDataLookup)parameters.getParameter(LegalEntityDiscountingMarketDataLookup.class);
        LegalEntityDiscountingScenarioMarketData legalEntityMarketData = ledLookup.marketDataView(scenarioMarketData);
        HashMap results = new HashMap();
        for (Measure measure : measures) {
            results.put(measure, this.calculate(measure, resolved, ratesMarketData, legalEntityMarketData));
        }
        return results;
    }

    private Result<?> calculate(Measure measure, ResolvedCapitalIndexedBondTrade resolved, RatesScenarioMarketData ratesMarketData, LegalEntityDiscountingScenarioMarketData legalEntityMarketData) {
        SingleMeasureCalculation calculator = (SingleMeasureCalculation)CALCULATORS.get((Object)measure);
        if (calculator == null) {
            return Result.failure((FailureReason)FailureReason.UNSUPPORTED, (String)"Unsupported measure for CapitalIndexedBond: {}", (Object[])new Object[]{measure});
        }
        return Result.of(() -> calculator.calculate(resolved, ratesMarketData, legalEntityMarketData));
    }

    @FunctionalInterface
    static interface SingleMeasureCalculation {
        public Object calculate(ResolvedCapitalIndexedBondTrade var1, RatesScenarioMarketData var2, LegalEntityDiscountingScenarioMarketData var3);
    }
}

