/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.bond;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.Resolvable;
import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.calc.Measure;
import com.opengamma.strata.calc.runner.CalculationFunction;
import com.opengamma.strata.calc.runner.CalculationParameters;
import com.opengamma.strata.calc.runner.FunctionRequirements;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.result.FailureReason;
import com.opengamma.strata.collect.result.Result;
import com.opengamma.strata.data.FieldName;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.market.observable.QuoteId;
import com.opengamma.strata.measure.Measures;
import com.opengamma.strata.measure.bond.BondFutureMeasureCalculations;
import com.opengamma.strata.measure.bond.LegalEntityDiscountingMarketDataLookup;
import com.opengamma.strata.measure.bond.LegalEntityDiscountingScenarioMarketData;
import com.opengamma.strata.product.SecuritizedProductPortfolioItem;
import com.opengamma.strata.product.bond.BondFuture;
import com.opengamma.strata.product.bond.BondFuturePosition;
import com.opengamma.strata.product.bond.BondFutureTrade;
import com.opengamma.strata.product.bond.FixedCouponBond;
import com.opengamma.strata.product.bond.ResolvedBondFutureTrade;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class BondFutureTradeCalculationFunction<T extends SecuritizedProductPortfolioItem<BondFuture> & Resolvable<ResolvedBondFutureTrade>>
implements CalculationFunction<T> {
    public static final BondFutureTradeCalculationFunction<BondFutureTrade> TRADE = new BondFutureTradeCalculationFunction<BondFutureTrade>(BondFutureTrade.class);
    public static final BondFutureTradeCalculationFunction<BondFuturePosition> POSITION = new BondFutureTradeCalculationFunction<BondFuturePosition>(BondFuturePosition.class);
    private static final ImmutableMap<Measure, SingleMeasureCalculation> CALCULATORS = ImmutableMap.builder().put((Object)Measures.PRESENT_VALUE, BondFutureMeasureCalculations.DEFAULT::presentValue).put((Object)Measures.PV01_CALIBRATED_SUM, BondFutureMeasureCalculations.DEFAULT::pv01CalibratedSum).put((Object)Measures.PV01_CALIBRATED_BUCKETED, BondFutureMeasureCalculations.DEFAULT::pv01CalibratedBucketed).put((Object)Measures.PV01_MARKET_QUOTE_SUM, BondFutureMeasureCalculations.DEFAULT::pv01MarketQuoteSum).put((Object)Measures.PV01_MARKET_QUOTE_BUCKETED, BondFutureMeasureCalculations.DEFAULT::pv01MarketQuoteBucketed).put((Object)Measures.UNIT_PRICE, BondFutureMeasureCalculations.DEFAULT::unitPrice).put((Object)Measures.PAR_SPREAD, BondFutureMeasureCalculations.DEFAULT::parSpread).put((Object)Measures.CURRENCY_EXPOSURE, BondFutureMeasureCalculations.DEFAULT::currencyExposure).put((Object)Measures.RESOLVED_TARGET, (rt, smd) -> rt).build();
    private static final ImmutableSet<Measure> MEASURES = CALCULATORS.keySet();
    private final Class<T> targetType;

    private BondFutureTradeCalculationFunction(Class<T> targetType) {
        this.targetType = (Class)ArgChecker.notNull(targetType, (String)"targetType");
    }

    public Class<T> targetType() {
        return this.targetType;
    }

    public Set<Measure> supportedMeasures() {
        return MEASURES;
    }

    public Optional<String> identifier(T target) {
        return target.getInfo().getId().map(id -> id.toString());
    }

    public Currency naturalCurrency(T target, ReferenceData refData) {
        return target.getCurrency();
    }

    public FunctionRequirements requirements(T target, Set<Measure> measures, CalculationParameters parameters, ReferenceData refData) {
        BondFuture product = (BondFuture)target.getProduct();
        QuoteId quoteId = QuoteId.of((StandardId)product.getSecurityId().getStandardId(), (FieldName)FieldName.SETTLEMENT_PRICE);
        Currency currency = product.getCurrency();
        FunctionRequirements freqs = FunctionRequirements.builder().valueRequirements(new MarketDataId[]{quoteId}).outputCurrencies(new Currency[]{currency}).build();
        LegalEntityDiscountingMarketDataLookup ledLookup = (LegalEntityDiscountingMarketDataLookup)parameters.getParameter(LegalEntityDiscountingMarketDataLookup.class);
        for (FixedCouponBond bond : product.getDeliveryBasket()) {
            freqs = freqs.combinedWith(ledLookup.requirements(bond.getSecurityId(), bond.getLegalEntityId(), bond.getCurrency()));
        }
        return freqs;
    }

    public Map<Measure, Result<?>> calculate(T target, Set<Measure> measures, CalculationParameters parameters, ScenarioMarketData scenarioMarketData, ReferenceData refData) {
        ResolvedBondFutureTrade resolved = (ResolvedBondFutureTrade)((Resolvable)target).resolve(refData);
        LegalEntityDiscountingMarketDataLookup ledLookup = (LegalEntityDiscountingMarketDataLookup)parameters.getParameter(LegalEntityDiscountingMarketDataLookup.class);
        LegalEntityDiscountingScenarioMarketData marketData = ledLookup.marketDataView(scenarioMarketData);
        HashMap results = new HashMap();
        for (Measure measure : measures) {
            results.put(measure, this.calculate(measure, resolved, marketData));
        }
        return results;
    }

    private Result<?> calculate(Measure measure, ResolvedBondFutureTrade resolved, LegalEntityDiscountingScenarioMarketData marketData) {
        SingleMeasureCalculation calculator = (SingleMeasureCalculation)CALCULATORS.get((Object)measure);
        if (calculator == null) {
            return Result.failure((FailureReason)FailureReason.UNSUPPORTED, (String)"Unsupported measure for BondFuture: {}", (Object[])new Object[]{measure});
        }
        return Result.of(() -> calculator.calculate(resolved, marketData));
    }

    @FunctionalInterface
    static interface SingleMeasureCalculation {
        public Object calculate(ResolvedBondFutureTrade var1, LegalEntityDiscountingScenarioMarketData var2);
    }
}

