/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.bond;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.Resolvable;
import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.calc.Measure;
import com.opengamma.strata.calc.runner.CalculationFunction;
import com.opengamma.strata.calc.runner.CalculationParameters;
import com.opengamma.strata.calc.runner.FunctionRequirements;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.result.FailureReason;
import com.opengamma.strata.collect.result.Result;
import com.opengamma.strata.data.FieldName;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.market.observable.QuoteId;
import com.opengamma.strata.measure.Measures;
import com.opengamma.strata.measure.bond.BondFutureOptionMarketDataLookup;
import com.opengamma.strata.measure.bond.BondFutureOptionMeasureCalculations;
import com.opengamma.strata.measure.bond.BondFutureOptionScenarioMarketData;
import com.opengamma.strata.measure.bond.LegalEntityDiscountingMarketDataLookup;
import com.opengamma.strata.measure.bond.LegalEntityDiscountingScenarioMarketData;
import com.opengamma.strata.product.SecuritizedProductPortfolioItem;
import com.opengamma.strata.product.bond.BondFuture;
import com.opengamma.strata.product.bond.BondFutureOption;
import com.opengamma.strata.product.bond.BondFutureOptionPosition;
import com.opengamma.strata.product.bond.BondFutureOptionTrade;
import com.opengamma.strata.product.bond.FixedCouponBond;
import com.opengamma.strata.product.bond.ResolvedBondFutureOptionTrade;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class BondFutureOptionTradeCalculationFunction<T extends SecuritizedProductPortfolioItem<BondFutureOption> & Resolvable<ResolvedBondFutureOptionTrade>>
implements CalculationFunction<T> {
    public static final BondFutureOptionTradeCalculationFunction<BondFutureOptionTrade> TRADE = new BondFutureOptionTradeCalculationFunction<BondFutureOptionTrade>(BondFutureOptionTrade.class);
    public static final BondFutureOptionTradeCalculationFunction<BondFutureOptionPosition> POSITION = new BondFutureOptionTradeCalculationFunction<BondFutureOptionPosition>(BondFutureOptionPosition.class);
    private static final ImmutableMap<Measure, SingleMeasureCalculation> CALCULATORS = ImmutableMap.builder().put((Object)Measures.PRESENT_VALUE, BondFutureOptionMeasureCalculations.DEFAULT::presentValue).put((Object)Measures.PV01_CALIBRATED_SUM, BondFutureOptionMeasureCalculations.DEFAULT::pv01CalibratedSum).put((Object)Measures.PV01_CALIBRATED_BUCKETED, BondFutureOptionMeasureCalculations.DEFAULT::pv01CalibratedBucketed).put((Object)Measures.UNIT_PRICE, BondFutureOptionMeasureCalculations.DEFAULT::unitPrice).put((Object)Measures.CURRENCY_EXPOSURE, BondFutureOptionMeasureCalculations.DEFAULT::currencyExposure).put((Object)Measures.RESOLVED_TARGET, (rt, smd, m) -> rt).build();
    private static final ImmutableSet<Measure> MEASURES = CALCULATORS.keySet();
    private final Class<T> targetType;

    private BondFutureOptionTradeCalculationFunction(Class<T> targetType) {
        this.targetType = (Class)ArgChecker.notNull(targetType, (String)"targetType");
    }

    public Class<T> targetType() {
        return this.targetType;
    }

    public Set<Measure> supportedMeasures() {
        return MEASURES;
    }

    public Optional<String> identifier(T target) {
        return target.getInfo().getId().map(id -> id.toString());
    }

    public Currency naturalCurrency(T target, ReferenceData refData) {
        return target.getCurrency();
    }

    public FunctionRequirements requirements(T target, Set<Measure> measures, CalculationParameters parameters, ReferenceData refData) {
        BondFutureOption option = (BondFutureOption)target.getProduct();
        BondFuture future = option.getUnderlyingFuture();
        QuoteId optionQuoteId = QuoteId.of((StandardId)option.getSecurityId().getStandardId(), (FieldName)FieldName.SETTLEMENT_PRICE);
        FunctionRequirements freqs = FunctionRequirements.builder().valueRequirements(new MarketDataId[]{optionQuoteId}).outputCurrencies(new Currency[]{future.getCurrency(), option.getCurrency()}).build();
        LegalEntityDiscountingMarketDataLookup ledLookup = (LegalEntityDiscountingMarketDataLookup)parameters.getParameter(LegalEntityDiscountingMarketDataLookup.class);
        for (FixedCouponBond bond : future.getDeliveryBasket()) {
            freqs = freqs.combinedWith(ledLookup.requirements(bond.getSecurityId(), bond.getLegalEntityId(), bond.getCurrency()));
        }
        BondFutureOptionMarketDataLookup optionLookup = (BondFutureOptionMarketDataLookup)parameters.getParameter(BondFutureOptionMarketDataLookup.class);
        FunctionRequirements optionReqs = optionLookup.requirements(future.getSecurityId());
        return freqs.combinedWith(optionReqs);
    }

    public Map<Measure, Result<?>> calculate(T target, Set<Measure> measures, CalculationParameters parameters, ScenarioMarketData scenarioMarketData, ReferenceData refData) {
        ResolvedBondFutureOptionTrade resolved = (ResolvedBondFutureOptionTrade)((Resolvable)target).resolve(refData);
        LegalEntityDiscountingMarketDataLookup ledLookup = (LegalEntityDiscountingMarketDataLookup)parameters.getParameter(LegalEntityDiscountingMarketDataLookup.class);
        LegalEntityDiscountingScenarioMarketData ledMarketData = ledLookup.marketDataView(scenarioMarketData);
        BondFutureOptionMarketDataLookup optionLookup = (BondFutureOptionMarketDataLookup)parameters.getParameter(BondFutureOptionMarketDataLookup.class);
        BondFutureOptionScenarioMarketData optionMarketData = optionLookup.marketDataView(scenarioMarketData);
        HashMap results = new HashMap();
        for (Measure measure : measures) {
            results.put(measure, this.calculate(measure, resolved, ledMarketData, optionMarketData));
        }
        return results;
    }

    private Result<?> calculate(Measure measure, ResolvedBondFutureOptionTrade resolved, LegalEntityDiscountingScenarioMarketData ratesMarketData, BondFutureOptionScenarioMarketData optionMarketData) {
        SingleMeasureCalculation calculator = (SingleMeasureCalculation)CALCULATORS.get((Object)measure);
        if (calculator == null) {
            return Result.failure((FailureReason)FailureReason.UNSUPPORTED, (String)"Unsupported measure for BondFutureOption: {}", (Object[])new Object[]{measure});
        }
        return Result.of(() -> calculator.calculate(resolved, ratesMarketData, optionMarketData));
    }

    @FunctionalInterface
    static interface SingleMeasureCalculation {
        public Object calculate(ResolvedBondFutureOptionTrade var1, LegalEntityDiscountingScenarioMarketData var2, BondFutureOptionScenarioMarketData var3);
    }
}

