/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.bond;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.calc.runner.CalculationParameter;
import com.opengamma.strata.calc.runner.FunctionRequirements;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.measure.bond.BondFutureOptionMarketData;
import com.opengamma.strata.measure.bond.BondFutureOptionScenarioMarketData;
import com.opengamma.strata.measure.bond.DefaultBondFutureOptionMarketData;
import com.opengamma.strata.measure.bond.DefaultBondFutureOptionMarketDataLookup;
import com.opengamma.strata.measure.bond.DefaultBondFutureOptionScenarioMarketData;
import com.opengamma.strata.pricer.bond.BondFutureVolatilities;
import com.opengamma.strata.pricer.bond.BondFutureVolatilitiesId;
import com.opengamma.strata.product.SecurityId;
import java.util.Map;
import java.util.Set;

public interface BondFutureOptionMarketDataLookup
extends CalculationParameter {
    public static BondFutureOptionMarketDataLookup of(SecurityId securityId, BondFutureVolatilitiesId volatilityId) {
        return DefaultBondFutureOptionMarketDataLookup.of((Map<SecurityId, BondFutureVolatilitiesId>)ImmutableMap.of((Object)securityId, (Object)volatilityId));
    }

    public static BondFutureOptionMarketDataLookup of(Map<SecurityId, BondFutureVolatilitiesId> volatilityIds) {
        return DefaultBondFutureOptionMarketDataLookup.of(volatilityIds);
    }

    default public Class<? extends CalculationParameter> queryType() {
        return BondFutureOptionMarketDataLookup.class;
    }

    public ImmutableSet<SecurityId> getVolatilitySecurityIds();

    public ImmutableSet<MarketDataId<?>> getVolatilityIds(SecurityId var1);

    default public FunctionRequirements requirements(SecurityId ... securityIds) {
        return this.requirements((Set<SecurityId>)ImmutableSet.copyOf((Object[])securityIds));
    }

    public FunctionRequirements requirements(Set<SecurityId> var1);

    default public BondFutureOptionScenarioMarketData marketDataView(ScenarioMarketData marketData) {
        return DefaultBondFutureOptionScenarioMarketData.of(this, marketData);
    }

    default public BondFutureOptionMarketData marketDataView(MarketData marketData) {
        return DefaultBondFutureOptionMarketData.of(this, marketData);
    }

    public BondFutureVolatilities volatilities(SecurityId var1, MarketData var2);
}

