/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.bond;

import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.data.FieldName;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.scenario.CurrencyScenarioArray;
import com.opengamma.strata.data.scenario.DoubleScenarioArray;
import com.opengamma.strata.data.scenario.MultiCurrencyScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.market.observable.QuoteId;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.measure.bond.LegalEntityDiscountingScenarioMarketData;
import com.opengamma.strata.pricer.bond.DiscountingBondFutureTradePricer;
import com.opengamma.strata.pricer.bond.LegalEntityDiscountingProvider;
import com.opengamma.strata.pricer.sensitivity.MarketQuoteSensitivityCalculator;
import com.opengamma.strata.product.bond.ResolvedBondFutureTrade;

final class BondFutureMeasureCalculations {
    public static final BondFutureMeasureCalculations DEFAULT = new BondFutureMeasureCalculations(DiscountingBondFutureTradePricer.DEFAULT);
    private static final MarketQuoteSensitivityCalculator MARKET_QUOTE_SENS = MarketQuoteSensitivityCalculator.DEFAULT;
    private static final double ONE_BASIS_POINT = 1.0E-4;
    private final DiscountingBondFutureTradePricer tradePricer;

    BondFutureMeasureCalculations(DiscountingBondFutureTradePricer tradePricer) {
        this.tradePricer = (DiscountingBondFutureTradePricer)ArgChecker.notNull((Object)tradePricer, (String)"tradePricer");
    }

    CurrencyScenarioArray presentValue(ResolvedBondFutureTrade trade, LegalEntityDiscountingScenarioMarketData marketData) {
        return CurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.presentValue(trade, marketData.scenario(i).discountingProvider()));
    }

    CurrencyAmount presentValue(ResolvedBondFutureTrade trade, LegalEntityDiscountingProvider discountingProvider) {
        double settlementPrice = this.settlementPrice(trade, discountingProvider);
        return this.tradePricer.presentValue(trade, discountingProvider, settlementPrice);
    }

    MultiCurrencyScenarioArray pv01CalibratedSum(ResolvedBondFutureTrade trade, LegalEntityDiscountingScenarioMarketData marketData) {
        return MultiCurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01CalibratedSum(trade, marketData.scenario(i).discountingProvider()));
    }

    MultiCurrencyAmount pv01CalibratedSum(ResolvedBondFutureTrade trade, LegalEntityDiscountingProvider discountingProvider) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivity(trade, discountingProvider);
        return discountingProvider.parameterSensitivity(pointSensitivity).total().multipliedBy(1.0E-4);
    }

    ScenarioArray<CurrencyParameterSensitivities> pv01CalibratedBucketed(ResolvedBondFutureTrade trade, LegalEntityDiscountingScenarioMarketData marketData) {
        return ScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01CalibratedBucketed(trade, marketData.scenario(i).discountingProvider()));
    }

    CurrencyParameterSensitivities pv01CalibratedBucketed(ResolvedBondFutureTrade trade, LegalEntityDiscountingProvider discountingProvider) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivity(trade, discountingProvider);
        return discountingProvider.parameterSensitivity(pointSensitivity).multipliedBy(1.0E-4);
    }

    MultiCurrencyScenarioArray pv01MarketQuoteSum(ResolvedBondFutureTrade trade, LegalEntityDiscountingScenarioMarketData marketData) {
        return MultiCurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01MarketQuoteSum(trade, marketData.scenario(i).discountingProvider()));
    }

    MultiCurrencyAmount pv01MarketQuoteSum(ResolvedBondFutureTrade trade, LegalEntityDiscountingProvider ratesProvider) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivity(trade, ratesProvider);
        CurrencyParameterSensitivities parameterSensitivity = ratesProvider.parameterSensitivity(pointSensitivity);
        return MARKET_QUOTE_SENS.sensitivity(parameterSensitivity, ratesProvider).total().multipliedBy(1.0E-4);
    }

    ScenarioArray<CurrencyParameterSensitivities> pv01MarketQuoteBucketed(ResolvedBondFutureTrade trade, LegalEntityDiscountingScenarioMarketData marketData) {
        return ScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01MarketQuoteBucketed(trade, marketData.scenario(i).discountingProvider()));
    }

    CurrencyParameterSensitivities pv01MarketQuoteBucketed(ResolvedBondFutureTrade trade, LegalEntityDiscountingProvider ratesProvider) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivity(trade, ratesProvider);
        CurrencyParameterSensitivities parameterSensitivity = ratesProvider.parameterSensitivity(pointSensitivity);
        return MARKET_QUOTE_SENS.sensitivity(parameterSensitivity, ratesProvider).multipliedBy(1.0E-4);
    }

    DoubleScenarioArray parSpread(ResolvedBondFutureTrade trade, LegalEntityDiscountingScenarioMarketData marketData) {
        return DoubleScenarioArray.of((int)marketData.getScenarioCount(), i -> this.parSpread(trade, marketData.scenario(i).discountingProvider()));
    }

    double parSpread(ResolvedBondFutureTrade trade, LegalEntityDiscountingProvider discountingProvider) {
        double settlementPrice = this.settlementPrice(trade, discountingProvider);
        return this.tradePricer.parSpread(trade, discountingProvider, settlementPrice);
    }

    DoubleScenarioArray unitPrice(ResolvedBondFutureTrade trade, LegalEntityDiscountingScenarioMarketData marketData) {
        return DoubleScenarioArray.of((int)marketData.getScenarioCount(), i -> this.unitPrice(trade, marketData.scenario(i).discountingProvider()));
    }

    double unitPrice(ResolvedBondFutureTrade trade, LegalEntityDiscountingProvider discountingProvider) {
        return this.tradePricer.price(trade, discountingProvider);
    }

    MultiCurrencyScenarioArray currencyExposure(ResolvedBondFutureTrade trade, LegalEntityDiscountingScenarioMarketData marketData) {
        return MultiCurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.currencyExposure(trade, marketData.scenario(i).discountingProvider()));
    }

    MultiCurrencyAmount currencyExposure(ResolvedBondFutureTrade trade, LegalEntityDiscountingProvider discountingProvider) {
        double settlementPrice = this.settlementPrice(trade, discountingProvider);
        return this.tradePricer.currencyExposure(trade, discountingProvider, settlementPrice);
    }

    private double settlementPrice(ResolvedBondFutureTrade trade, LegalEntityDiscountingProvider discountingProvider) {
        StandardId standardId = trade.getProduct().getSecurityId().getStandardId();
        QuoteId id = QuoteId.of((StandardId)standardId, (FieldName)FieldName.SETTLEMENT_PRICE);
        return (Double)discountingProvider.data((MarketDataId)id) / 100.0;
    }
}

