/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.bond;

import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.data.scenario.CurrencyScenarioArray;
import com.opengamma.strata.data.scenario.MultiCurrencyScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.measure.bond.LegalEntityDiscountingScenarioMarketData;
import com.opengamma.strata.pricer.bond.DiscountingBillTradePricer;
import com.opengamma.strata.pricer.bond.LegalEntityDiscountingProvider;
import com.opengamma.strata.pricer.sensitivity.MarketQuoteSensitivityCalculator;
import com.opengamma.strata.product.bond.ResolvedBillTrade;

public class BillMeasureCalculations {
    public static final BillMeasureCalculations DEFAULT = new BillMeasureCalculations(DiscountingBillTradePricer.DEFAULT);
    private static final MarketQuoteSensitivityCalculator MARKET_QUOTE_SENS = MarketQuoteSensitivityCalculator.DEFAULT;
    private static final double ONE_BASIS_POINT = 1.0E-4;
    private final DiscountingBillTradePricer tradePricer;

    BillMeasureCalculations(DiscountingBillTradePricer tradePricer) {
        this.tradePricer = (DiscountingBillTradePricer)ArgChecker.notNull((Object)tradePricer, (String)"tradePricer");
    }

    CurrencyScenarioArray presentValue(ResolvedBillTrade trade, LegalEntityDiscountingScenarioMarketData marketData) {
        return CurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.presentValue(trade, marketData.scenario(i).discountingProvider()));
    }

    CurrencyAmount presentValue(ResolvedBillTrade trade, LegalEntityDiscountingProvider discountingProvider) {
        return this.tradePricer.presentValue(trade, discountingProvider);
    }

    MultiCurrencyScenarioArray pv01CalibratedSum(ResolvedBillTrade trade, LegalEntityDiscountingScenarioMarketData marketData) {
        return MultiCurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01CalibratedSum(trade, marketData.scenario(i).discountingProvider()));
    }

    MultiCurrencyAmount pv01CalibratedSum(ResolvedBillTrade trade, LegalEntityDiscountingProvider discountingProvider) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivity(trade, discountingProvider);
        return discountingProvider.parameterSensitivity(pointSensitivity).total().multipliedBy(1.0E-4);
    }

    ScenarioArray<CurrencyParameterSensitivities> pv01CalibratedBucketed(ResolvedBillTrade trade, LegalEntityDiscountingScenarioMarketData marketData) {
        return ScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01CalibratedBucketed(trade, marketData.scenario(i).discountingProvider()));
    }

    CurrencyParameterSensitivities pv01CalibratedBucketed(ResolvedBillTrade trade, LegalEntityDiscountingProvider discountingProvider) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivity(trade, discountingProvider);
        return discountingProvider.parameterSensitivity(pointSensitivity).multipliedBy(1.0E-4);
    }

    MultiCurrencyScenarioArray pv01MarketQuoteSum(ResolvedBillTrade trade, LegalEntityDiscountingScenarioMarketData marketData) {
        return MultiCurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01MarketQuoteSum(trade, marketData.scenario(i).discountingProvider()));
    }

    MultiCurrencyAmount pv01MarketQuoteSum(ResolvedBillTrade trade, LegalEntityDiscountingProvider ratesProvider) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivity(trade, ratesProvider);
        CurrencyParameterSensitivities parameterSensitivity = ratesProvider.parameterSensitivity(pointSensitivity);
        return MARKET_QUOTE_SENS.sensitivity(parameterSensitivity, ratesProvider).total().multipliedBy(1.0E-4);
    }

    ScenarioArray<CurrencyParameterSensitivities> pv01MarketQuoteBucketed(ResolvedBillTrade trade, LegalEntityDiscountingScenarioMarketData marketData) {
        return ScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01MarketQuoteBucketed(trade, marketData.scenario(i).discountingProvider()));
    }

    CurrencyParameterSensitivities pv01MarketQuoteBucketed(ResolvedBillTrade trade, LegalEntityDiscountingProvider ratesProvider) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivity(trade, ratesProvider);
        CurrencyParameterSensitivities parameterSensitivity = ratesProvider.parameterSensitivity(pointSensitivity);
        return MARKET_QUOTE_SENS.sensitivity(parameterSensitivity, ratesProvider).multipliedBy(1.0E-4);
    }

    MultiCurrencyScenarioArray currencyExposure(ResolvedBillTrade trade, LegalEntityDiscountingScenarioMarketData marketData) {
        return MultiCurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.currencyExposure(trade, marketData.scenario(i).discountingProvider()));
    }

    MultiCurrencyAmount currencyExposure(ResolvedBillTrade trade, LegalEntityDiscountingProvider discountingProvider) {
        return this.tradePricer.currencyExposure(trade, discountingProvider);
    }

    CurrencyScenarioArray currentCash(ResolvedBillTrade trade, LegalEntityDiscountingScenarioMarketData marketData) {
        return CurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.currentCash(trade, marketData.scenario(i).discountingProvider()));
    }

    CurrencyAmount currentCash(ResolvedBillTrade trade, LegalEntityDiscountingProvider discountingProvider) {
        return this.tradePricer.currentCash(trade, discountingProvider.getValuationDate());
    }
}

