/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.data.scenario.MarketDataBox;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class ValuationZoneTimeDefinition
implements ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final LocalTime defaultLocalTime;
    @PropertyDefinition(validate="notNull")
    private final ZoneId zoneId;
    @PropertyDefinition(validate="notNull")
    private final ImmutableList<LocalTime> localTimes;
    private static final long serialVersionUID = 1L;

    public static ValuationZoneTimeDefinition of(LocalTime defaultLocalTime, ZoneId zoneId, LocalTime ... localTimes) {
        return new ValuationZoneTimeDefinition(defaultLocalTime, zoneId, (List<LocalTime>)ImmutableList.copyOf((Object[])localTimes));
    }

    public MarketDataBox<ZonedDateTime> toZonedDateTime(MarketDataBox<LocalDate> dates) {
        if (dates.isScenarioValue()) {
            int nScenarios = dates.getScenarioCount();
            int nTimes = this.localTimes.size();
            List zonedDateTimes = IntStream.range(0, nScenarios).mapToObj(scenarioIndex -> this.zonedDateTime((LocalDate)dates.getValue(scenarioIndex), nTimes, scenarioIndex)).collect(Collectors.toList());
            return MarketDataBox.ofScenarioValues(zonedDateTimes);
        }
        ZonedDateTime zonedDateTime = ((LocalDate)dates.getSingleValue()).atTime(this.defaultLocalTime).atZone(this.zoneId);
        return MarketDataBox.ofSingleValue((Object)zonedDateTime);
    }

    private ZonedDateTime zonedDateTime(LocalDate date, int nTimes, int scenarioIndex) {
        return date.atTime(scenarioIndex < nTimes ? (LocalTime)this.localTimes.get(scenarioIndex) : this.defaultLocalTime).atZone(this.zoneId);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private ValuationZoneTimeDefinition(LocalTime defaultLocalTime, ZoneId zoneId, List<LocalTime> localTimes) {
        JodaBeanUtils.notNull((Object)defaultLocalTime, (String)"defaultLocalTime");
        JodaBeanUtils.notNull((Object)zoneId, (String)"zoneId");
        JodaBeanUtils.notNull(localTimes, (String)"localTimes");
        this.defaultLocalTime = defaultLocalTime;
        this.zoneId = zoneId;
        this.localTimes = ImmutableList.copyOf(localTimes);
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public LocalTime getDefaultLocalTime() {
        return this.defaultLocalTime;
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public ImmutableList<LocalTime> getLocalTimes() {
        return this.localTimes;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ValuationZoneTimeDefinition other = (ValuationZoneTimeDefinition)obj;
            return JodaBeanUtils.equal((Object)this.defaultLocalTime, (Object)other.defaultLocalTime) && JodaBeanUtils.equal((Object)this.zoneId, (Object)other.zoneId) && JodaBeanUtils.equal(this.localTimes, other.localTimes);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.defaultLocalTime);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.zoneId);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.localTimes);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("ValuationZoneTimeDefinition{");
        buf.append("defaultLocalTime").append('=').append(JodaBeanUtils.toString((Object)this.defaultLocalTime)).append(',').append(' ');
        buf.append("zoneId").append('=').append(JodaBeanUtils.toString((Object)this.zoneId)).append(',').append(' ');
        buf.append("localTimes").append('=').append(JodaBeanUtils.toString(this.localTimes));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<ValuationZoneTimeDefinition> {
        private LocalTime defaultLocalTime;
        private ZoneId zoneId;
        private List<LocalTime> localTimes = ImmutableList.of();

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 605993879: {
                    return this.defaultLocalTime;
                }
                case -696323609: {
                    return this.zoneId;
                }
                case 1293230747: {
                    return this.localTimes;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 605993879: {
                    this.defaultLocalTime = (LocalTime)newValue;
                    break;
                }
                case -696323609: {
                    this.zoneId = (ZoneId)newValue;
                    break;
                }
                case 1293230747: {
                    this.localTimes = (List)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public ValuationZoneTimeDefinition build() {
            return new ValuationZoneTimeDefinition(this.defaultLocalTime, this.zoneId, this.localTimes);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("ValuationZoneTimeDefinition.Builder{");
            buf.append("defaultLocalTime").append('=').append(JodaBeanUtils.toString((Object)this.defaultLocalTime)).append(',').append(' ');
            buf.append("zoneId").append('=').append(JodaBeanUtils.toString((Object)this.zoneId)).append(',').append(' ');
            buf.append("localTimes").append('=').append(JodaBeanUtils.toString(this.localTimes));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<LocalTime> defaultLocalTime = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"defaultLocalTime", ValuationZoneTimeDefinition.class, LocalTime.class);
        private final MetaProperty<ZoneId> zoneId = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"zoneId", ValuationZoneTimeDefinition.class, ZoneId.class);
        private final MetaProperty<ImmutableList<LocalTime>> localTimes = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"localTimes", ValuationZoneTimeDefinition.class, ImmutableList.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"defaultLocalTime", "zoneId", "localTimes"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 605993879: {
                    return this.defaultLocalTime;
                }
                case -696323609: {
                    return this.zoneId;
                }
                case 1293230747: {
                    return this.localTimes;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends ValuationZoneTimeDefinition> builder() {
            return new Builder();
        }

        public Class<? extends ValuationZoneTimeDefinition> beanType() {
            return ValuationZoneTimeDefinition.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<LocalTime> defaultLocalTime() {
            return this.defaultLocalTime;
        }

        public MetaProperty<ZoneId> zoneId() {
            return this.zoneId;
        }

        public MetaProperty<ImmutableList<LocalTime>> localTimes() {
            return this.localTimes;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 605993879: {
                    return ((ValuationZoneTimeDefinition)bean).getDefaultLocalTime();
                }
                case -696323609: {
                    return ((ValuationZoneTimeDefinition)bean).getZoneId();
                }
                case 1293230747: {
                    return ((ValuationZoneTimeDefinition)bean).getLocalTimes();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

