/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.calc.marketdata.MarketDataFactory;
import com.opengamma.strata.calc.marketdata.MarketDataFunction;
import com.opengamma.strata.calc.marketdata.ObservableDataProvider;
import com.opengamma.strata.calc.marketdata.TimeSeriesProvider;
import com.opengamma.strata.calc.runner.CalculationFunction;
import com.opengamma.strata.calc.runner.CalculationFunctions;
import com.opengamma.strata.measure.bond.BillTradeCalculationFunction;
import com.opengamma.strata.measure.bond.BondFutureOptionTradeCalculationFunction;
import com.opengamma.strata.measure.bond.BondFutureTradeCalculationFunction;
import com.opengamma.strata.measure.bond.CapitalIndexedBondTradeCalculationFunction;
import com.opengamma.strata.measure.bond.FixedCouponBondTradeCalculationFunction;
import com.opengamma.strata.measure.capfloor.IborCapFloorTradeCalculationFunction;
import com.opengamma.strata.measure.cms.CmsTradeCalculationFunction;
import com.opengamma.strata.measure.credit.CdsIndexTradeCalculationFunction;
import com.opengamma.strata.measure.credit.CdsTradeCalculationFunction;
import com.opengamma.strata.measure.curve.CurveMarketDataFunction;
import com.opengamma.strata.measure.deposit.TermDepositTradeCalculationFunction;
import com.opengamma.strata.measure.dsf.DsfTradeCalculationFunction;
import com.opengamma.strata.measure.fra.FraTradeCalculationFunction;
import com.opengamma.strata.measure.fx.FxNdfTradeCalculationFunction;
import com.opengamma.strata.measure.fx.FxRateMarketDataFunction;
import com.opengamma.strata.measure.fx.FxSingleTradeCalculationFunction;
import com.opengamma.strata.measure.fx.FxSwapTradeCalculationFunction;
import com.opengamma.strata.measure.fxopt.FxOptionVolatilitiesMarketDataFunction;
import com.opengamma.strata.measure.fxopt.FxSingleBarrierOptionTradeCalculationFunction;
import com.opengamma.strata.measure.fxopt.FxVanillaOptionTradeCalculationFunction;
import com.opengamma.strata.measure.index.IborFutureOptionTradeCalculationFunction;
import com.opengamma.strata.measure.index.IborFutureTradeCalculationFunction;
import com.opengamma.strata.measure.index.OvernightFutureTradeCalculationFunction;
import com.opengamma.strata.measure.payment.BulletPaymentTradeCalculationFunction;
import com.opengamma.strata.measure.rate.RatesCurveGroupMarketDataFunction;
import com.opengamma.strata.measure.rate.RatesCurveInputsMarketDataFunction;
import com.opengamma.strata.measure.security.GenericSecurityPositionCalculationFunction;
import com.opengamma.strata.measure.security.GenericSecurityTradeCalculationFunction;
import com.opengamma.strata.measure.security.SecurityPositionCalculationFunction;
import com.opengamma.strata.measure.security.SecurityTradeCalculationFunction;
import com.opengamma.strata.measure.swap.SwapTradeCalculationFunction;
import com.opengamma.strata.measure.swaption.SwaptionTradeCalculationFunction;
import java.util.List;

public final class StandardComponents {
    private static final CalculationFunctions STANDARD = CalculationFunctions.of((CalculationFunction[])new CalculationFunction[]{new BulletPaymentTradeCalculationFunction(), new CdsTradeCalculationFunction(), new CdsIndexTradeCalculationFunction(), new FraTradeCalculationFunction(), new FxNdfTradeCalculationFunction(), new FxSingleBarrierOptionTradeCalculationFunction(), new FxSingleTradeCalculationFunction(), new FxSwapTradeCalculationFunction(), new FxVanillaOptionTradeCalculationFunction(), new IborCapFloorTradeCalculationFunction(), new SecurityPositionCalculationFunction(), new SecurityTradeCalculationFunction(), new SwapTradeCalculationFunction(), new SwaptionTradeCalculationFunction(), new CmsTradeCalculationFunction(), new TermDepositTradeCalculationFunction(), new GenericSecurityPositionCalculationFunction(), new GenericSecurityTradeCalculationFunction(), BondFutureTradeCalculationFunction.TRADE, BondFutureTradeCalculationFunction.POSITION, BondFutureOptionTradeCalculationFunction.TRADE, BondFutureOptionTradeCalculationFunction.POSITION, CapitalIndexedBondTradeCalculationFunction.TRADE, CapitalIndexedBondTradeCalculationFunction.POSITION, DsfTradeCalculationFunction.TRADE, DsfTradeCalculationFunction.POSITION, FixedCouponBondTradeCalculationFunction.TRADE, FixedCouponBondTradeCalculationFunction.POSITION, BillTradeCalculationFunction.TRADE, BillTradeCalculationFunction.POSITION, IborFutureTradeCalculationFunction.TRADE, IborFutureTradeCalculationFunction.POSITION, OvernightFutureTradeCalculationFunction.TRADE, OvernightFutureTradeCalculationFunction.POSITION, IborFutureOptionTradeCalculationFunction.TRADE, IborFutureOptionTradeCalculationFunction.POSITION});

    private StandardComponents() {
    }

    public static MarketDataFactory marketDataFactory() {
        return StandardComponents.marketDataFactory(ObservableDataProvider.none());
    }

    public static MarketDataFactory marketDataFactory(ObservableDataProvider observableDataProvider) {
        return MarketDataFactory.of((ObservableDataProvider)observableDataProvider, (TimeSeriesProvider)TimeSeriesProvider.none(), StandardComponents.marketDataFunctions());
    }

    public static List<MarketDataFunction<?, ?>> marketDataFunctions() {
        return ImmutableList.of((Object)new CurveMarketDataFunction(), (Object)new RatesCurveGroupMarketDataFunction(), (Object)new RatesCurveInputsMarketDataFunction(), (Object)new FxRateMarketDataFunction(), (Object)new FxOptionVolatilitiesMarketDataFunction());
    }

    public static CalculationFunctions calculationFunctions() {
        return STANDARD;
    }
}

