/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc.runner;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.calc.Measure;
import com.opengamma.strata.calc.runner.CalculationFunction;
import com.opengamma.strata.calc.runner.CalculationParameters;
import com.opengamma.strata.calc.runner.FunctionRequirements;
import com.opengamma.strata.calc.runner.UnresolvableTarget;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.result.Result;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

final class UnresolvableTargetCalculationFunction
implements CalculationFunction<UnresolvableTarget> {
    static final CalculationFunction<UnresolvableTarget> INSTANCE = new UnresolvableTargetCalculationFunction();

    private UnresolvableTargetCalculationFunction() {
    }

    @Override
    public Class<UnresolvableTarget> targetType() {
        return UnresolvableTarget.class;
    }

    @Override
    public Set<Measure> supportedMeasures() {
        return ImmutableSet.copyOf((Collection)Measure.extendedEnum().lookupAllNormalized().values());
    }

    @Override
    public Currency naturalCurrency(UnresolvableTarget target, ReferenceData refData) {
        throw new IllegalStateException("Function has no currency-convertible measures");
    }

    @Override
    public FunctionRequirements requirements(UnresolvableTarget target, Set<Measure> measures, CalculationParameters parameters, ReferenceData refData) {
        return FunctionRequirements.empty();
    }

    @Override
    public Map<Measure, Result<?>> calculate(UnresolvableTarget target, Set<Measure> measures, CalculationParameters parameters, ScenarioMarketData marketData, ReferenceData refData) {
        throw new IllegalStateException(Messages.format((String)"Target '{}' cannot be resolved: {}", (Object[])new Object[]{target.getTarget().getClass(), target.getMessage()}));
    }
}

