/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc.runner;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.CalculationTarget;
import com.opengamma.strata.calc.Column;
import com.opengamma.strata.calc.Results;
import com.opengamma.strata.calc.runner.AggregatingCalculationListener;
import com.opengamma.strata.calc.runner.CalculationResult;
import com.opengamma.strata.collect.Guavate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public final class ResultsListener
extends AggregatingCalculationListener<Results> {
    private static final Comparator<CalculationResult> COMPARATOR = Comparator.comparingInt(CalculationResult::getRowIndex).thenComparingInt(CalculationResult::getColumnIndex);
    private final List<CalculationResult> results = new ArrayList<CalculationResult>();
    private List<Column> columns;

    @Override
    public void calculationsStarted(List<CalculationTarget> targets, List<Column> columns) {
        this.columns = ImmutableList.copyOf(columns);
    }

    @Override
    public void resultReceived(CalculationTarget target, CalculationResult result) {
        this.results.add(result);
    }

    @Override
    protected Results createAggregateResult() {
        this.results.sort(COMPARATOR);
        return ResultsListener.buildResults(this.results, this.columns);
    }

    private static Results buildResults(List<CalculationResult> calculationResults, List<Column> columns) {
        List results = (List)calculationResults.stream().map(CalculationResult::getResult).collect(Guavate.toImmutableList());
        List headers = (List)columns.stream().map(Column::toHeader).collect(Guavate.toImmutableList());
        return Results.of(headers, results);
    }
}

