/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc.runner;

import com.opengamma.strata.basics.CalculationTarget;
import com.opengamma.strata.calc.Column;
import com.opengamma.strata.calc.runner.CalculationListener;
import com.opengamma.strata.calc.runner.CalculationResult;
import com.opengamma.strata.calc.runner.CalculationResults;
import com.opengamma.strata.collect.ArgChecker;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ListenerWrapper
implements Consumer<CalculationResults> {
    private static final Logger log = LoggerFactory.getLogger(ListenerWrapper.class);
    private final CalculationListener listener;
    private final Queue<CalculationResults> queue = new LinkedList<CalculationResults>();
    private final Lock lock = new ReentrantLock();
    private final Lock listenerLock = new ReentrantLock();
    private final int tasksExpected;
    private boolean executing;
    private int tasksReceived;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ListenerWrapper(CalculationListener listener, int tasksExpected, List<CalculationTarget> targets, List<Column> columns) {
        this.listener = (CalculationListener)ArgChecker.notNull((Object)listener, (String)"listener");
        this.tasksExpected = ArgChecker.notNegative((int)tasksExpected, (String)"tasksExpected");
        this.listenerLock.lock();
        try {
            listener.calculationsStarted(targets, columns);
            if (tasksExpected == 0) {
                listener.calculationsComplete();
            }
        }
        finally {
            this.listenerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(CalculationResults result) {
        CalculationResults nextResult;
        this.lock.lock();
        try {
            if (this.executing) {
                this.queue.add(result);
                return;
            }
            this.executing = true;
            nextResult = result;
        }
        finally {
            this.lock.unlock();
        }
        while (true) {
            this.listenerLock.lock();
            try {
                for (CalculationResult cell : nextResult.getCells()) {
                    this.listener.resultReceived(nextResult.getTarget(), cell);
                }
            }
            catch (RuntimeException e) {
                log.warn("Exception invoking listener.resultReceived", (Throwable)e);
            }
            finally {
                this.listenerLock.unlock();
            }
            this.lock.lock();
            try {
                if (++this.tasksReceived == this.tasksExpected) {
                    this.listenerLock.lock();
                    try {
                        this.listener.calculationsComplete();
                    }
                    catch (RuntimeException e) {
                        log.warn("Exception invoking listener.calculationsComplete", (Throwable)e);
                    }
                    finally {
                        this.listenerLock.unlock();
                    }
                    return;
                }
                if (this.queue.isEmpty()) {
                    this.executing = false;
                    return;
                }
                nextResult = this.queue.remove();
                continue;
            }
            finally {
                this.lock.unlock();
                continue;
            }
            break;
        }
    }
}

