/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc.runner;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.ObservableId;
import com.opengamma.strata.data.ObservableSource;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class FunctionRequirements
implements ImmutableBean {
    private static final FunctionRequirements EMPTY = FunctionRequirements.builder().build();
    @PropertyDefinition(validate="notNull")
    private final ImmutableSet<? extends MarketDataId<?>> valueRequirements;
    @PropertyDefinition(validate="notNull")
    private final ImmutableSet<ObservableId> timeSeriesRequirements;
    @PropertyDefinition(validate="notNull")
    private final ImmutableSet<Currency> outputCurrencies;
    @PropertyDefinition(validate="notNull")
    private final ObservableSource observableSource;

    public static FunctionRequirements empty() {
        return EMPTY;
    }

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.observableSource = ObservableSource.NONE;
    }

    public FunctionRequirements combinedWith(FunctionRequirements other) {
        return FunctionRequirements.builder().valueRequirements((Set<? extends MarketDataId<?>>)Sets.union(this.valueRequirements, other.valueRequirements)).timeSeriesRequirements((Set<ObservableId>)Sets.union(this.timeSeriesRequirements, other.timeSeriesRequirements)).outputCurrencies((Set<Currency>)Sets.union(this.outputCurrencies, other.outputCurrencies)).observableSource(!this.observableSource.equals((Object)ObservableSource.NONE) ? this.observableSource : other.observableSource).build();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private FunctionRequirements(Set<? extends MarketDataId<?>> valueRequirements, Set<ObservableId> timeSeriesRequirements, Set<Currency> outputCurrencies, ObservableSource observableSource) {
        JodaBeanUtils.notNull(valueRequirements, (String)"valueRequirements");
        JodaBeanUtils.notNull(timeSeriesRequirements, (String)"timeSeriesRequirements");
        JodaBeanUtils.notNull(outputCurrencies, (String)"outputCurrencies");
        JodaBeanUtils.notNull((Object)observableSource, (String)"observableSource");
        this.valueRequirements = ImmutableSet.copyOf(valueRequirements);
        this.timeSeriesRequirements = ImmutableSet.copyOf(timeSeriesRequirements);
        this.outputCurrencies = ImmutableSet.copyOf(outputCurrencies);
        this.observableSource = observableSource;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public ImmutableSet<? extends MarketDataId<?>> getValueRequirements() {
        return this.valueRequirements;
    }

    public ImmutableSet<ObservableId> getTimeSeriesRequirements() {
        return this.timeSeriesRequirements;
    }

    public ImmutableSet<Currency> getOutputCurrencies() {
        return this.outputCurrencies;
    }

    public ObservableSource getObservableSource() {
        return this.observableSource;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            FunctionRequirements other = (FunctionRequirements)obj;
            return JodaBeanUtils.equal(this.valueRequirements, other.valueRequirements) && JodaBeanUtils.equal(this.timeSeriesRequirements, other.timeSeriesRequirements) && JodaBeanUtils.equal(this.outputCurrencies, other.outputCurrencies) && JodaBeanUtils.equal((Object)this.observableSource, (Object)other.observableSource);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.valueRequirements);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.timeSeriesRequirements);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.outputCurrencies);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.observableSource);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(160);
        buf.append("FunctionRequirements{");
        buf.append("valueRequirements").append('=').append(JodaBeanUtils.toString(this.valueRequirements)).append(',').append(' ');
        buf.append("timeSeriesRequirements").append('=').append(JodaBeanUtils.toString(this.timeSeriesRequirements)).append(',').append(' ');
        buf.append("outputCurrencies").append('=').append(JodaBeanUtils.toString(this.outputCurrencies)).append(',').append(' ');
        buf.append("observableSource").append('=').append(JodaBeanUtils.toString((Object)this.observableSource));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<FunctionRequirements> {
        private Set<? extends MarketDataId<?>> valueRequirements = ImmutableSet.of();
        private Set<ObservableId> timeSeriesRequirements = ImmutableSet.of();
        private Set<Currency> outputCurrencies = ImmutableSet.of();
        private ObservableSource observableSource;

        private Builder() {
            FunctionRequirements.applyDefaults(this);
        }

        private Builder(FunctionRequirements beanToCopy) {
            this.valueRequirements = beanToCopy.getValueRequirements();
            this.timeSeriesRequirements = beanToCopy.getTimeSeriesRequirements();
            this.outputCurrencies = beanToCopy.getOutputCurrencies();
            this.observableSource = beanToCopy.getObservableSource();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1938886495: {
                    return this.valueRequirements;
                }
                case -1437279660: {
                    return this.timeSeriesRequirements;
                }
                case -1022597040: {
                    return this.outputCurrencies;
                }
                case 1793526590: {
                    return this.observableSource;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -1938886495: {
                    this.valueRequirements = (Set)newValue;
                    break;
                }
                case -1437279660: {
                    this.timeSeriesRequirements = (Set)newValue;
                    break;
                }
                case -1022597040: {
                    this.outputCurrencies = (Set)newValue;
                    break;
                }
                case 1793526590: {
                    this.observableSource = (ObservableSource)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public FunctionRequirements build() {
            return new FunctionRequirements(this.valueRequirements, this.timeSeriesRequirements, this.outputCurrencies, this.observableSource);
        }

        public Builder valueRequirements(Set<? extends MarketDataId<?>> valueRequirements) {
            JodaBeanUtils.notNull(valueRequirements, (String)"valueRequirements");
            this.valueRequirements = valueRequirements;
            return this;
        }

        @SafeVarargs
        public final Builder valueRequirements(MarketDataId<?> ... valueRequirements) {
            return this.valueRequirements((Set<? extends MarketDataId<?>>)ImmutableSet.copyOf((Object[])valueRequirements));
        }

        public Builder timeSeriesRequirements(Set<ObservableId> timeSeriesRequirements) {
            JodaBeanUtils.notNull(timeSeriesRequirements, (String)"timeSeriesRequirements");
            this.timeSeriesRequirements = timeSeriesRequirements;
            return this;
        }

        public Builder timeSeriesRequirements(ObservableId ... timeSeriesRequirements) {
            return this.timeSeriesRequirements((Set<ObservableId>)ImmutableSet.copyOf((Object[])timeSeriesRequirements));
        }

        public Builder outputCurrencies(Set<Currency> outputCurrencies) {
            JodaBeanUtils.notNull(outputCurrencies, (String)"outputCurrencies");
            this.outputCurrencies = outputCurrencies;
            return this;
        }

        public Builder outputCurrencies(Currency ... outputCurrencies) {
            return this.outputCurrencies((Set<Currency>)ImmutableSet.copyOf((Object[])outputCurrencies));
        }

        public Builder observableSource(ObservableSource observableSource) {
            JodaBeanUtils.notNull((Object)observableSource, (String)"observableSource");
            this.observableSource = observableSource;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("FunctionRequirements.Builder{");
            buf.append("valueRequirements").append('=').append(JodaBeanUtils.toString(this.valueRequirements)).append(',').append(' ');
            buf.append("timeSeriesRequirements").append('=').append(JodaBeanUtils.toString(this.timeSeriesRequirements)).append(',').append(' ');
            buf.append("outputCurrencies").append('=').append(JodaBeanUtils.toString(this.outputCurrencies)).append(',').append(' ');
            buf.append("observableSource").append('=').append(JodaBeanUtils.toString((Object)this.observableSource));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<ImmutableSet<? extends MarketDataId<?>>> valueRequirements = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"valueRequirements", FunctionRequirements.class, ImmutableSet.class);
        private final MetaProperty<ImmutableSet<ObservableId>> timeSeriesRequirements = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"timeSeriesRequirements", FunctionRequirements.class, ImmutableSet.class);
        private final MetaProperty<ImmutableSet<Currency>> outputCurrencies = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"outputCurrencies", FunctionRequirements.class, ImmutableSet.class);
        private final MetaProperty<ObservableSource> observableSource = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"observableSource", FunctionRequirements.class, ObservableSource.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"valueRequirements", "timeSeriesRequirements", "outputCurrencies", "observableSource"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1938886495: {
                    return this.valueRequirements;
                }
                case -1437279660: {
                    return this.timeSeriesRequirements;
                }
                case -1022597040: {
                    return this.outputCurrencies;
                }
                case 1793526590: {
                    return this.observableSource;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends FunctionRequirements> beanType() {
            return FunctionRequirements.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<ImmutableSet<? extends MarketDataId<?>>> valueRequirements() {
            return this.valueRequirements;
        }

        public MetaProperty<ImmutableSet<ObservableId>> timeSeriesRequirements() {
            return this.timeSeriesRequirements;
        }

        public MetaProperty<ImmutableSet<Currency>> outputCurrencies() {
            return this.outputCurrencies;
        }

        public MetaProperty<ObservableSource> observableSource() {
            return this.observableSource;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -1938886495: {
                    return ((FunctionRequirements)bean).getValueRequirements();
                }
                case -1437279660: {
                    return ((FunctionRequirements)bean).getTimeSeriesRequirements();
                }
                case -1022597040: {
                    return ((FunctionRequirements)bean).getOutputCurrencies();
                }
                case 1793526590: {
                    return ((FunctionRequirements)bean).getObservableSource();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

