/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc.runner;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.calc.runner.FxRateLookup;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.MarketDataFxRateProvider;
import com.opengamma.strata.data.ObservableSource;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Optional;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light", constructorScope="package")
final class DefaultFxRateLookup
implements FxRateLookup,
ImmutableBean,
Serializable {
    static final DefaultFxRateLookup DEFAULT = new DefaultFxRateLookup(null, ObservableSource.NONE);
    @PropertyDefinition(get="optional")
    private final Currency currency;
    @PropertyDefinition(validate="notNull")
    private final ObservableSource observableSource;
    private static final TypedMetaBean<DefaultFxRateLookup> META_BEAN = LightMetaBean.of(DefaultFxRateLookup.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"currency", "observableSource"}, (Object[])new Object[0]);
    private static final long serialVersionUID = 1L;

    DefaultFxRateLookup(ObservableSource observableSource) {
        this(null, observableSource);
    }

    @Override
    public FxRateProvider fxRateProvider(MarketData marketData) {
        if (this.currency == null) {
            return MarketDataFxRateProvider.of((MarketData)marketData, (ObservableSource)this.observableSource);
        }
        return MarketDataFxRateProvider.of((MarketData)marketData, (ObservableSource)this.observableSource, (Currency)this.currency);
    }

    public static TypedMetaBean<DefaultFxRateLookup> meta() {
        return META_BEAN;
    }

    DefaultFxRateLookup(Currency currency, ObservableSource observableSource) {
        JodaBeanUtils.notNull((Object)observableSource, (String)"observableSource");
        this.currency = currency;
        this.observableSource = observableSource;
    }

    public TypedMetaBean<DefaultFxRateLookup> metaBean() {
        return META_BEAN;
    }

    public Optional<Currency> getCurrency() {
        return Optional.ofNullable(this.currency);
    }

    public ObservableSource getObservableSource() {
        return this.observableSource;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            DefaultFxRateLookup other = (DefaultFxRateLookup)obj;
            return JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((Object)this.observableSource, (Object)other.observableSource);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.observableSource);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("DefaultFxRateLookup{");
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("observableSource").append('=').append(JodaBeanUtils.toString((Object)this.observableSource));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

