/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc.runner;

import com.opengamma.strata.basics.CalculationTarget;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.calc.Column;
import com.opengamma.strata.calc.Results;
import com.opengamma.strata.calc.runner.CalculationListener;
import com.opengamma.strata.calc.runner.CalculationResult;
import com.opengamma.strata.calc.runner.CalculationResults;
import com.opengamma.strata.calc.runner.CalculationTask;
import com.opengamma.strata.calc.runner.CalculationTaskRunner;
import com.opengamma.strata.calc.runner.CalculationTasks;
import com.opengamma.strata.calc.runner.ListenerWrapper;
import com.opengamma.strata.calc.runner.ResultsListener;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.result.Result;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import java.util.function.Supplier;

final class DefaultCalculationTaskRunner
implements CalculationTaskRunner {
    private final ExecutorService executor;

    static DefaultCalculationTaskRunner ofMultiThreaded() {
        return new DefaultCalculationTaskRunner(DefaultCalculationTaskRunner.createExecutor(Runtime.getRuntime().availableProcessors()));
    }

    static DefaultCalculationTaskRunner of(ExecutorService executor) {
        return new DefaultCalculationTaskRunner(executor);
    }

    private static ExecutorService createExecutor(int threads) {
        int effectiveThreads = threads <= 0 ? Runtime.getRuntime().availableProcessors() : threads;
        ThreadFactory defaultFactory = Executors.defaultThreadFactory();
        ThreadFactory threadFactory = r -> {
            Thread t = defaultFactory.newThread(r);
            t.setName("CalculationTaskRunner-" + t.getName());
            t.setDaemon(true);
            return t;
        };
        return Executors.newFixedThreadPool(effectiveThreads, threadFactory);
    }

    private DefaultCalculationTaskRunner(ExecutorService executor) {
        this.executor = (ExecutorService)ArgChecker.notNull((Object)executor, (String)"executor");
    }

    @Override
    public Results calculate(CalculationTasks tasks, MarketData marketData, ReferenceData refData) {
        ScenarioMarketData md = ScenarioMarketData.of((int)1, (MarketData)marketData);
        Results results = this.calculateMultiScenario(tasks, md, refData);
        List mappedResults = (List)results.getCells().stream().map(r -> DefaultCalculationTaskRunner.unwrapScenarioResult(r)).collect(Guavate.toImmutableList());
        return Results.of(results.getColumns(), mappedResults);
    }

    private static Result<?> unwrapScenarioResult(Result<?> result) {
        if (result.isFailure()) {
            return result;
        }
        Object value = result.getValue();
        if (!(value instanceof ScenarioArray)) {
            return result;
        }
        ScenarioArray scenarioResult = (ScenarioArray)value;
        if (scenarioResult.getScenarioCount() != 1) {
            throw new IllegalArgumentException(Messages.format((String)"Expected one result but found {} in {}", (Object[])new Object[]{scenarioResult.getScenarioCount(), scenarioResult}));
        }
        return Result.success((Object)scenarioResult.get(0));
    }

    @Override
    public void calculateAsync(CalculationTasks tasks, MarketData marketData, ReferenceData refData, CalculationListener listener) {
        ScenarioMarketData md = ScenarioMarketData.of((int)1, (MarketData)marketData);
        UnwrappingListener unwrappingListener = new UnwrappingListener(listener);
        this.calculateMultiScenarioAsync(tasks, md, refData, unwrappingListener);
    }

    @Override
    public Results calculateMultiScenario(CalculationTasks tasks, ScenarioMarketData marketData, ReferenceData refData) {
        ResultsListener listener = new ResultsListener();
        this.calculateMultiScenarioAsync(tasks, marketData, refData, listener);
        return (Results)listener.result();
    }

    @Override
    public void calculateMultiScenarioAsync(CalculationTasks tasks, ScenarioMarketData marketData, ReferenceData refData, CalculationListener listener) {
        List<CalculationTask> taskList = tasks.getTasks();
        ListenerWrapper consumer = new ListenerWrapper(listener, taskList.size(), tasks.getTargets(), tasks.getColumns());
        taskList.forEach(task -> this.runTask((CalculationTask)task, marketData, refData, consumer));
    }

    private void runTask(CalculationTask task, ScenarioMarketData marketData, ReferenceData refData, Consumer<CalculationResults> consumer) {
        Supplier<CalculationResults> taskExecutor = () -> task.execute(marketData, refData);
        CompletableFuture.supplyAsync(taskExecutor, this.executor).thenAccept((Consumer)consumer);
    }

    @Override
    public void close() {
        this.executor.shutdown();
    }

    private static final class UnwrappingListener
    implements CalculationListener {
        private final CalculationListener delegate;

        private UnwrappingListener(CalculationListener delegate) {
            this.delegate = delegate;
        }

        @Override
        public void calculationsStarted(List<CalculationTarget> targets, List<Column> columns) {
            this.delegate.calculationsStarted(targets, columns);
        }

        @Override
        public void resultReceived(CalculationTarget target, CalculationResult calculationResult) {
            Result<?> result = calculationResult.getResult();
            Result unwrappedResult = DefaultCalculationTaskRunner.unwrapScenarioResult(result);
            CalculationResult unwrappedCalculationResult = calculationResult.withResult(unwrappedResult);
            this.delegate.resultReceived(target, unwrappedCalculationResult);
        }

        @Override
        public void calculationsComplete() {
            this.delegate.calculationsComplete();
        }
    }
}

