/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc.runner;

import com.opengamma.strata.basics.CalculationTarget;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.calc.Measure;
import com.opengamma.strata.calc.ReportingCurrency;
import com.opengamma.strata.calc.runner.CalculationResult;
import com.opengamma.strata.calc.runner.CalculationTask;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.result.FailureReason;
import com.opengamma.strata.collect.result.Result;
import com.opengamma.strata.data.scenario.ScenarioFxConvertible;
import com.opengamma.strata.data.scenario.ScenarioFxRateProvider;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
public final class CalculationTaskCell
implements ImmutableBean {
    @PropertyDefinition(validate="ArgChecker.notNegative")
    private final int rowIndex;
    @PropertyDefinition(validate="ArgChecker.notNegative")
    private final int columnIndex;
    @PropertyDefinition(validate="notNull")
    private final Measure measure;
    @PropertyDefinition(validate="notNull")
    private final ReportingCurrency reportingCurrency;
    private static final TypedMetaBean<CalculationTaskCell> META_BEAN = LightMetaBean.of(CalculationTaskCell.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"rowIndex", "columnIndex", "measure", "reportingCurrency"}, (Object[])new Object[0]);

    public static CalculationTaskCell of(int rowIndex, int columnIndex, Measure measure, ReportingCurrency reportingCurrency) {
        return new CalculationTaskCell(rowIndex, columnIndex, measure, reportingCurrency);
    }

    Currency reportingCurrency(CalculationTask task, ReferenceData refData) {
        if (this.reportingCurrency.isSpecific()) {
            return this.reportingCurrency.getCurrency();
        }
        return task.naturalCurrency(refData);
    }

    CalculationResult createResult(CalculationTask task, CalculationTarget target, Map<Measure, Result<?>> results, ScenarioFxRateProvider fxProvider, ReferenceData refData) {
        Result calculated = results.get(this.measure);
        if (calculated == null) {
            calculated = Result.failure((FailureReason)FailureReason.CALCULATION_FAILED, (String)"Measure '{}' was not calculated by the function for target type '{}'", (Object[])new Object[]{this.measure, target.getClass().getName()});
        }
        Result<?> result = this.convertCurrencyIfNecessary(task, calculated, fxProvider, refData);
        return CalculationResult.of(this.rowIndex, this.columnIndex, result);
    }

    private Result<?> convertCurrencyIfNecessary(CalculationTask task, Result<?> result, ScenarioFxRateProvider fxProvider, ReferenceData refData) {
        if (this.measure.isCurrencyConvertible() && !this.reportingCurrency.isNone() && result.isSuccess() && result.getValue() instanceof ScenarioFxConvertible) {
            ScenarioFxConvertible convertible = (ScenarioFxConvertible)result.getValue();
            return this.convertCurrency(task, convertible, fxProvider, refData);
        }
        return result;
    }

    private Result<?> convertCurrency(CalculationTask task, ScenarioFxConvertible<?> value, ScenarioFxRateProvider fxProvider, ReferenceData refData) {
        Currency resolvedReportingCurrency = this.reportingCurrency(task, refData);
        try {
            return Result.success((Object)value.convertedTo(resolvedReportingCurrency, fxProvider));
        }
        catch (RuntimeException ex) {
            return Result.failure((FailureReason)FailureReason.CURRENCY_CONVERSION, (Exception)ex, (String)"Failed to convert value '{}' to currency '{}'", (Object[])new Object[]{value, resolvedReportingCurrency});
        }
    }

    public String toString() {
        return Messages.format((String)"CalculationTaskCell[({}, {}), measure={}, currency={}]", (Object[])new Object[]{this.rowIndex, this.columnIndex, this.measure, this.reportingCurrency});
    }

    public static TypedMetaBean<CalculationTaskCell> meta() {
        return META_BEAN;
    }

    private CalculationTaskCell(int rowIndex, int columnIndex, Measure measure, ReportingCurrency reportingCurrency) {
        ArgChecker.notNegative((int)rowIndex, (String)"rowIndex");
        ArgChecker.notNegative((int)columnIndex, (String)"columnIndex");
        JodaBeanUtils.notNull((Object)measure, (String)"measure");
        JodaBeanUtils.notNull((Object)reportingCurrency, (String)"reportingCurrency");
        this.rowIndex = rowIndex;
        this.columnIndex = columnIndex;
        this.measure = measure;
        this.reportingCurrency = reportingCurrency;
    }

    public TypedMetaBean<CalculationTaskCell> metaBean() {
        return META_BEAN;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public Measure getMeasure() {
        return this.measure;
    }

    public ReportingCurrency getReportingCurrency() {
        return this.reportingCurrency;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CalculationTaskCell other = (CalculationTaskCell)obj;
            return this.rowIndex == other.rowIndex && this.columnIndex == other.columnIndex && JodaBeanUtils.equal((Object)this.measure, (Object)other.measure) && JodaBeanUtils.equal((Object)this.reportingCurrency, (Object)other.reportingCurrency);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((int)this.rowIndex);
        hash = hash * 31 + JodaBeanUtils.hashCode((int)this.columnIndex);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.measure);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.reportingCurrency);
        return hash;
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

