/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc.runner;

import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.result.Result;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
public final class CalculationResult
implements ImmutableBean,
Serializable {
    @PropertyDefinition
    private final int rowIndex;
    @PropertyDefinition
    private final int columnIndex;
    @PropertyDefinition(validate="notNull")
    private final Result<?> result;
    private static final TypedMetaBean<CalculationResult> META_BEAN = LightMetaBean.of(CalculationResult.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"rowIndex", "columnIndex", "result"}, (Object[])new Object[0]);
    private static final long serialVersionUID = 1L;

    public static CalculationResult of(int rowIndex, int columnIndex, Result<?> result) {
        return new CalculationResult(rowIndex, columnIndex, result);
    }

    public <T> Result<T> getResult(Class<T> type) {
        if (this.result.isFailure() || type.isInstance(this.result.getValue())) {
            return this.result;
        }
        throw new ClassCastException(Messages.format((String)"Result queried with type '{}' but was '{}'", (Object[])new Object[]{type.getName(), this.result.getValue().getClass().getName()}));
    }

    public CalculationResult withResult(Result<?> underlyingResult) {
        return new CalculationResult(this.rowIndex, this.columnIndex, underlyingResult);
    }

    public static TypedMetaBean<CalculationResult> meta() {
        return META_BEAN;
    }

    private CalculationResult(int rowIndex, int columnIndex, Result<?> result) {
        JodaBeanUtils.notNull(result, (String)"result");
        this.rowIndex = rowIndex;
        this.columnIndex = columnIndex;
        this.result = result;
    }

    public TypedMetaBean<CalculationResult> metaBean() {
        return META_BEAN;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public Result<?> getResult() {
        return this.result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CalculationResult other = (CalculationResult)obj;
            return this.rowIndex == other.rowIndex && this.columnIndex == other.columnIndex && JodaBeanUtils.equal(this.result, other.result);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((int)this.rowIndex);
        hash = hash * 31 + JodaBeanUtils.hashCode((int)this.columnIndex);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.result);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("CalculationResult{");
        buf.append("rowIndex").append('=').append(JodaBeanUtils.toString((Object)this.rowIndex)).append(',').append(' ');
        buf.append("columnIndex").append('=').append(JodaBeanUtils.toString((Object)this.columnIndex)).append(',').append(' ');
        buf.append("result").append('=').append(JodaBeanUtils.toString(this.result));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

