/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc.runner;

import com.opengamma.strata.basics.CalculationTarget;
import com.opengamma.strata.calc.runner.CalculationListener;
import com.opengamma.strata.calc.runner.CalculationResult;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public abstract class AggregatingCalculationListener<T>
implements CalculationListener {
    private final CompletableFuture<T> future = new CompletableFuture();

    @Override
    public final void calculationsComplete() {
        this.future.complete(this.createAggregateResult());
    }

    public T result() {
        try {
            return this.future.get();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(ex);
        }
        catch (ExecutionException ex) {
            throw new RuntimeException("Exception getting result", ex);
        }
    }

    public CompletableFuture<T> getFuture() {
        return this.future;
    }

    @Override
    public abstract void resultReceived(CalculationTarget var1, CalculationResult var2);

    protected abstract T createAggregateResult();
}

