/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc.runner;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.CalculationTarget;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.calc.Measure;
import com.opengamma.strata.calc.runner.CalculationParameters;
import com.opengamma.strata.calc.runner.DerivedCalculationFunction;
import com.opengamma.strata.calc.runner.FunctionRequirements;
import java.util.Set;

public abstract class AbstractDerivedCalculationFunction<T extends CalculationTarget, R>
implements DerivedCalculationFunction<T, R> {
    private final Class<T> targetType;
    private final Measure measure;
    private final Set<Measure> requiredMeasures;

    protected AbstractDerivedCalculationFunction(Class<T> targetType, Measure measure, Measure ... requiredMeasures) {
        this(targetType, measure, (Set<Measure>)ImmutableSet.copyOf((Object[])requiredMeasures));
    }

    protected AbstractDerivedCalculationFunction(Class<T> targetType, Measure measure, Set<Measure> requiredMeasures) {
        this.measure = measure;
        this.requiredMeasures = ImmutableSet.copyOf(requiredMeasures);
        this.targetType = targetType;
    }

    @Override
    public Class<T> targetType() {
        return this.targetType;
    }

    @Override
    public Measure measure() {
        return this.measure;
    }

    @Override
    public Set<Measure> requiredMeasures() {
        return this.requiredMeasures;
    }

    @Override
    public FunctionRequirements requirements(T target, CalculationParameters parameters, ReferenceData refData) {
        return FunctionRequirements.empty();
    }
}

