/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc.marketdata;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.calc.marketdata.MarketDataFilter;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.scenario.MarketDataBox;
import com.opengamma.strata.data.scenario.ScenarioPerturbation;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class PerturbationMapping<T>
implements ImmutableBean {
    @PropertyDefinition(validate="notNull")
    private final Class<T> marketDataType;
    @PropertyDefinition(validate="notNull")
    private final MarketDataFilter<? extends T, ?> filter;
    @PropertyDefinition(validate="notNull")
    private final ScenarioPerturbation<T> perturbation;

    public static <T> PerturbationMapping<T> of(MarketDataFilter<? extends T, ?> filter, ScenarioPerturbation<T> perturbation) {
        return new PerturbationMapping<T>(perturbation.getMarketDataType(), filter, perturbation);
    }

    public boolean matches(MarketDataId<?> marketDataId, MarketDataBox<?> marketData, ReferenceData refData) {
        MarketDataFilter<?, ?> rawFilter = this.filter;
        return this.marketDataType.isAssignableFrom(marketData.getMarketDataType()) && this.filter.getMarketDataIdType().isInstance(marketDataId) && rawFilter.matches(marketDataId, marketData, refData);
    }

    public MarketDataBox<T> applyPerturbation(MarketDataBox<T> marketData, ReferenceData refData) {
        if (!this.marketDataType.isAssignableFrom(marketData.getMarketDataType())) {
            throw new IllegalArgumentException(Messages.format((String)"Market data {} is not an instance of the required type {}", (Object[])new Object[]{marketData, this.marketDataType.getName()}));
        }
        return this.perturbation.applyTo(marketData, refData);
    }

    public int getScenarioCount() {
        return this.perturbation.getScenarioCount();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static <R> Meta<R> metaPerturbationMapping(Class<R> cls) {
        return Meta.INSTANCE;
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    private PerturbationMapping(Class<T> marketDataType, MarketDataFilter<? extends T, ?> filter, ScenarioPerturbation<T> perturbation) {
        JodaBeanUtils.notNull(marketDataType, (String)"marketDataType");
        JodaBeanUtils.notNull(filter, (String)"filter");
        JodaBeanUtils.notNull(perturbation, (String)"perturbation");
        this.marketDataType = marketDataType;
        this.filter = filter;
        this.perturbation = perturbation;
    }

    public Meta<T> metaBean() {
        return Meta.INSTANCE;
    }

    public Class<T> getMarketDataType() {
        return this.marketDataType;
    }

    public MarketDataFilter<? extends T, ?> getFilter() {
        return this.filter;
    }

    public ScenarioPerturbation<T> getPerturbation() {
        return this.perturbation;
    }

    public Builder<T> toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            PerturbationMapping other = (PerturbationMapping)obj;
            return JodaBeanUtils.equal(this.marketDataType, other.marketDataType) && JodaBeanUtils.equal(this.filter, other.filter) && JodaBeanUtils.equal(this.perturbation, other.perturbation);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.marketDataType);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.filter);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.perturbation);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("PerturbationMapping{");
        buf.append("marketDataType").append('=').append(JodaBeanUtils.toString(this.marketDataType)).append(',').append(' ');
        buf.append("filter").append('=').append(JodaBeanUtils.toString(this.filter)).append(',').append(' ');
        buf.append("perturbation").append('=').append(JodaBeanUtils.toString(this.perturbation));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder<T>
    extends DirectFieldsBeanBuilder<PerturbationMapping<T>> {
        private Class<T> marketDataType;
        private MarketDataFilter<? extends T, ?> filter;
        private ScenarioPerturbation<T> perturbation;

        private Builder() {
        }

        private Builder(PerturbationMapping<T> beanToCopy) {
            this.marketDataType = beanToCopy.getMarketDataType();
            this.filter = beanToCopy.getFilter();
            this.perturbation = beanToCopy.getPerturbation();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 843057760: {
                    return this.marketDataType;
                }
                case -1274492040: {
                    return this.filter;
                }
                case -924739417: {
                    return this.perturbation;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder<T> set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 843057760: {
                    this.marketDataType = (Class)newValue;
                    break;
                }
                case -1274492040: {
                    this.filter = (MarketDataFilter)newValue;
                    break;
                }
                case -924739417: {
                    this.perturbation = (ScenarioPerturbation)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder<T> set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public PerturbationMapping<T> build() {
            return new PerturbationMapping(this.marketDataType, this.filter, this.perturbation);
        }

        public Builder<T> marketDataType(Class<T> marketDataType) {
            JodaBeanUtils.notNull(marketDataType, (String)"marketDataType");
            this.marketDataType = marketDataType;
            return this;
        }

        public Builder<T> filter(MarketDataFilter<? extends T, ?> filter) {
            JodaBeanUtils.notNull(filter, (String)"filter");
            this.filter = filter;
            return this;
        }

        public Builder<T> perturbation(ScenarioPerturbation<T> perturbation) {
            JodaBeanUtils.notNull(perturbation, (String)"perturbation");
            this.perturbation = perturbation;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("PerturbationMapping.Builder{");
            buf.append("marketDataType").append('=').append(JodaBeanUtils.toString(this.marketDataType)).append(',').append(' ');
            buf.append("filter").append('=').append(JodaBeanUtils.toString(this.filter)).append(',').append(' ');
            buf.append("perturbation").append('=').append(JodaBeanUtils.toString(this.perturbation));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta<T>
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Class<T>> marketDataType = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"marketDataType", PerturbationMapping.class, Class.class);
        private final MetaProperty<MarketDataFilter<? extends T, ?>> filter = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"filter", PerturbationMapping.class, MarketDataFilter.class);
        private final MetaProperty<ScenarioPerturbation<T>> perturbation = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"perturbation", PerturbationMapping.class, ScenarioPerturbation.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"marketDataType", "filter", "perturbation"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 843057760: {
                    return this.marketDataType;
                }
                case -1274492040: {
                    return this.filter;
                }
                case -924739417: {
                    return this.perturbation;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder<T> builder() {
            return new Builder();
        }

        public Class<? extends PerturbationMapping<T>> beanType() {
            return PerturbationMapping.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Class<T>> marketDataType() {
            return this.marketDataType;
        }

        public MetaProperty<MarketDataFilter<? extends T, ?>> filter() {
            return this.filter;
        }

        public MetaProperty<ScenarioPerturbation<T>> perturbation() {
            return this.perturbation;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 843057760: {
                    return ((PerturbationMapping)bean).getMarketDataType();
                }
                case -1274492040: {
                    return ((PerturbationMapping)bean).getFilter();
                }
                case -924739417: {
                    return ((PerturbationMapping)bean).getPerturbation();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

