/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc.marketdata;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.CalculationTarget;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.calc.CalculationRules;
import com.opengamma.strata.calc.Column;
import com.opengamma.strata.calc.marketdata.MarketDataRequirementsBuilder;
import com.opengamma.strata.calc.runner.CalculationTasks;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.ObservableId;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private", constructorScope="package")
public final class MarketDataRequirements
implements ImmutableBean {
    private static final MarketDataRequirements EMPTY = MarketDataRequirements.builder().build();
    @PropertyDefinition(validate="notNull", builderType="Set<? extends ObservableId>")
    private final ImmutableSet<ObservableId> observables;
    @PropertyDefinition(validate="notNull", builderType="Set<? extends MarketDataId<?>>")
    private final ImmutableSet<MarketDataId<?>> nonObservables;
    @PropertyDefinition(validate="notNull", builderType="Set<? extends ObservableId>")
    private final ImmutableSet<ObservableId> timeSeries;
    @PropertyDefinition(validate="notNull")
    private final ImmutableSet<Currency> outputCurrencies;

    public static MarketDataRequirements of(CalculationRules calculationRules, List<? extends CalculationTarget> targets, List<Column> columns, ReferenceData refData) {
        return CalculationTasks.of(calculationRules, targets, columns, refData).requirements(refData);
    }

    public static MarketDataRequirements of(MarketDataId<?> id) {
        return MarketDataRequirements.builder().addValues(id).build();
    }

    public static MarketDataRequirements empty() {
        return EMPTY;
    }

    public static MarketDataRequirementsBuilder builder() {
        return new MarketDataRequirementsBuilder();
    }

    public static MarketDataRequirements combine(List<MarketDataRequirements> requirements) {
        ImmutableSet.Builder observablesBuilder = ImmutableSet.builder();
        ImmutableSet.Builder nonObservablesBuilder = ImmutableSet.builder();
        ImmutableSet.Builder timeSeriesBuilder = ImmutableSet.builder();
        ImmutableSet.Builder outputCurrenciesBuilder = ImmutableSet.builder();
        for (MarketDataRequirements req : requirements) {
            observablesBuilder.addAll(req.observables);
            nonObservablesBuilder.addAll(req.nonObservables);
            timeSeriesBuilder.addAll(req.timeSeries);
            outputCurrenciesBuilder.addAll(req.outputCurrencies);
        }
        return new MarketDataRequirements((Set<? extends ObservableId>)observablesBuilder.build(), (Set<? extends MarketDataId<?>>)nonObservablesBuilder.build(), (Set<? extends ObservableId>)timeSeriesBuilder.build(), (Set<Currency>)outputCurrenciesBuilder.build());
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    MarketDataRequirements(Set<? extends ObservableId> observables, Set<? extends MarketDataId<?>> nonObservables, Set<? extends ObservableId> timeSeries, Set<Currency> outputCurrencies) {
        JodaBeanUtils.notNull(observables, (String)"observables");
        JodaBeanUtils.notNull(nonObservables, (String)"nonObservables");
        JodaBeanUtils.notNull(timeSeries, (String)"timeSeries");
        JodaBeanUtils.notNull(outputCurrencies, (String)"outputCurrencies");
        this.observables = ImmutableSet.copyOf(observables);
        this.nonObservables = ImmutableSet.copyOf(nonObservables);
        this.timeSeries = ImmutableSet.copyOf(timeSeries);
        this.outputCurrencies = ImmutableSet.copyOf(outputCurrencies);
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public ImmutableSet<ObservableId> getObservables() {
        return this.observables;
    }

    public ImmutableSet<MarketDataId<?>> getNonObservables() {
        return this.nonObservables;
    }

    public ImmutableSet<ObservableId> getTimeSeries() {
        return this.timeSeries;
    }

    public ImmutableSet<Currency> getOutputCurrencies() {
        return this.outputCurrencies;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            MarketDataRequirements other = (MarketDataRequirements)obj;
            return JodaBeanUtils.equal(this.observables, other.observables) && JodaBeanUtils.equal(this.nonObservables, other.nonObservables) && JodaBeanUtils.equal(this.timeSeries, other.timeSeries) && JodaBeanUtils.equal(this.outputCurrencies, other.outputCurrencies);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.observables);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.nonObservables);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.timeSeries);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.outputCurrencies);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(160);
        buf.append("MarketDataRequirements{");
        buf.append("observables").append('=').append(JodaBeanUtils.toString(this.observables)).append(',').append(' ');
        buf.append("nonObservables").append('=').append(JodaBeanUtils.toString(this.nonObservables)).append(',').append(' ');
        buf.append("timeSeries").append('=').append(JodaBeanUtils.toString(this.timeSeries)).append(',').append(' ');
        buf.append("outputCurrencies").append('=').append(JodaBeanUtils.toString(this.outputCurrencies));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<MarketDataRequirements> {
        private Set<? extends ObservableId> observables = ImmutableSet.of();
        private Set<? extends MarketDataId<?>> nonObservables = ImmutableSet.of();
        private Set<? extends ObservableId> timeSeries = ImmutableSet.of();
        private Set<Currency> outputCurrencies = ImmutableSet.of();

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 121811856: {
                    return this.observables;
                }
                case 824041091: {
                    return this.nonObservables;
                }
                case 779431844: {
                    return this.timeSeries;
                }
                case -1022597040: {
                    return this.outputCurrencies;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 121811856: {
                    this.observables = (Set)newValue;
                    break;
                }
                case 824041091: {
                    this.nonObservables = (Set)newValue;
                    break;
                }
                case 779431844: {
                    this.timeSeries = (Set)newValue;
                    break;
                }
                case -1022597040: {
                    this.outputCurrencies = (Set)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public MarketDataRequirements build() {
            return new MarketDataRequirements(this.observables, this.nonObservables, this.timeSeries, this.outputCurrencies);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("MarketDataRequirements.Builder{");
            buf.append("observables").append('=').append(JodaBeanUtils.toString(this.observables)).append(',').append(' ');
            buf.append("nonObservables").append('=').append(JodaBeanUtils.toString(this.nonObservables)).append(',').append(' ');
            buf.append("timeSeries").append('=').append(JodaBeanUtils.toString(this.timeSeries)).append(',').append(' ');
            buf.append("outputCurrencies").append('=').append(JodaBeanUtils.toString(this.outputCurrencies));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<ImmutableSet<ObservableId>> observables = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"observables", MarketDataRequirements.class, ImmutableSet.class);
        private final MetaProperty<ImmutableSet<MarketDataId<?>>> nonObservables = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"nonObservables", MarketDataRequirements.class, ImmutableSet.class);
        private final MetaProperty<ImmutableSet<ObservableId>> timeSeries = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"timeSeries", MarketDataRequirements.class, ImmutableSet.class);
        private final MetaProperty<ImmutableSet<Currency>> outputCurrencies = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"outputCurrencies", MarketDataRequirements.class, ImmutableSet.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"observables", "nonObservables", "timeSeries", "outputCurrencies"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 121811856: {
                    return this.observables;
                }
                case 824041091: {
                    return this.nonObservables;
                }
                case 779431844: {
                    return this.timeSeries;
                }
                case -1022597040: {
                    return this.outputCurrencies;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends MarketDataRequirements> builder() {
            return new Builder();
        }

        public Class<? extends MarketDataRequirements> beanType() {
            return MarketDataRequirements.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<ImmutableSet<ObservableId>> observables() {
            return this.observables;
        }

        public MetaProperty<ImmutableSet<MarketDataId<?>>> nonObservables() {
            return this.nonObservables;
        }

        public MetaProperty<ImmutableSet<ObservableId>> timeSeries() {
            return this.timeSeries;
        }

        public MetaProperty<ImmutableSet<Currency>> outputCurrencies() {
            return this.outputCurrencies;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 121811856: {
                    return ((MarketDataRequirements)bean).getObservables();
                }
                case 824041091: {
                    return ((MarketDataRequirements)bean).getNonObservables();
                }
                case 779431844: {
                    return ((MarketDataRequirements)bean).getTimeSeries();
                }
                case -1022597040: {
                    return ((MarketDataRequirements)bean).getOutputCurrencies();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

