/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc.marketdata;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.calc.marketdata.DependencyTreeBuilder;
import com.opengamma.strata.calc.marketdata.MarketDataConfig;
import com.opengamma.strata.calc.marketdata.MarketDataFunction;
import com.opengamma.strata.calc.marketdata.MarketDataRequirements;
import com.opengamma.strata.calc.marketdata.MarketDataRequirementsBuilder;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.ObservableId;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

final class MarketDataNode {
    private final MarketDataId<?> id;
    private final DataType dataType;
    private final List<MarketDataNode> dependencies;

    static MarketDataNode buildDependencyTree(MarketDataRequirements requirements, ScenarioMarketData suppliedData, MarketDataConfig marketDataConfig, Map<Class<? extends MarketDataId<?>>, MarketDataFunction<?, ?>> functions) {
        DependencyTreeBuilder treeBuilder = DependencyTreeBuilder.of(suppliedData, requirements, marketDataConfig, functions);
        return MarketDataNode.root(treeBuilder.dependencyNodes());
    }

    static MarketDataNode root(List<MarketDataNode> children) {
        ArgChecker.notNull(children, (String)"children");
        return new MarketDataNode(null, null, children);
    }

    static MarketDataNode child(MarketDataId<?> id, DataType dataType, List<MarketDataNode> children) {
        ArgChecker.notNull(id, (String)"id");
        ArgChecker.notNull((Object)((Object)dataType), (String)"dataType");
        ArgChecker.notNull(children, (String)"children");
        return new MarketDataNode(id, dataType, children);
    }

    static MarketDataNode leaf(MarketDataId<?> id, DataType dataType) {
        ArgChecker.notNull(id, (String)"id");
        ArgChecker.notNull((Object)((Object)dataType), (String)"dataType");
        return new MarketDataNode(id, dataType, (List<MarketDataNode>)ImmutableList.of());
    }

    private MarketDataNode(MarketDataId<?> id, DataType dataType, List<MarketDataNode> dependencies) {
        this.dataType = dataType;
        this.id = id;
        this.dependencies = ImmutableList.copyOf(dependencies);
    }

    Pair<MarketDataNode, MarketDataRequirements> withLeavesRemoved() {
        ImmutableList.Builder childNodesBuilder = ImmutableList.builder();
        MarketDataRequirementsBuilder requirementsBuilder = MarketDataRequirements.builder();
        block4: for (MarketDataNode child : this.dependencies) {
            if (child.isLeaf()) {
                switch (child.dataType) {
                    case SINGLE_VALUE: {
                        requirementsBuilder.addValues(child.id);
                        continue block4;
                    }
                    case TIME_SERIES: {
                        requirementsBuilder.addTimeSeries((ObservableId)child.id);
                        continue block4;
                    }
                }
                throw new IllegalStateException("Unexpected enum value");
            }
            Pair<MarketDataNode, MarketDataRequirements> childResult = child.withLeavesRemoved();
            childNodesBuilder.add(childResult.getFirst());
            requirementsBuilder.addRequirements((MarketDataRequirements)childResult.getSecond());
        }
        MarketDataNode node = new MarketDataNode(this.id, this.dataType, (List<MarketDataNode>)childNodesBuilder.build());
        MarketDataRequirements requirements = requirementsBuilder.build();
        return Pair.of((Object)node, (Object)requirements);
    }

    boolean isLeaf() {
        return this.dependencies.isEmpty();
    }

    public MarketDataId<?> getId() {
        return this.id;
    }

    private StringBuilder prettyPrint(StringBuilder builder, String indent, String childIndent) {
        String nodeDescription = this.id == null ? "Root" : this.id + " " + (Object)((Object)this.dataType);
        builder.append('\n').append(indent).append(nodeDescription);
        Iterator<MarketDataNode> it = this.dependencies.iterator();
        while (it.hasNext()) {
            String newChildIndent;
            String newIndent;
            boolean isFinalChild;
            MarketDataNode child = it.next();
            boolean bl = isFinalChild = !it.hasNext();
            if (!isFinalChild) {
                newIndent = childIndent + " |--";
                newChildIndent = childIndent + " |  ";
            } else {
                newIndent = childIndent + " `--";
                newChildIndent = childIndent + "    ";
            }
            child.prettyPrint(builder, newIndent, newChildIndent);
        }
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarketDataNode that = (MarketDataNode)o;
        return Objects.equals(this.id, that.id) && Objects.equals((Object)this.dataType, (Object)that.dataType) && Objects.equals(this.dependencies, that.dependencies);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.dataType, this.dependencies});
    }

    public String toString() {
        return this.prettyPrint(new StringBuilder(), "", "").toString();
    }

    static enum DataType {
        SINGLE_VALUE,
        TIME_SERIES;

    }
}

