/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc.marketdata;

import com.opengamma.strata.calc.marketdata.MarketDataConfig;
import com.opengamma.strata.calc.marketdata.SingleTypeMarketDataConfig;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.TypedString;
import java.util.HashMap;
import java.util.Map;

public final class MarketDataConfigBuilder {
    private final Map<Class<?>, SingleTypeMarketDataConfig> values = new HashMap();
    private final Map<Class<?>, Object> defaultValues = new HashMap();

    MarketDataConfigBuilder() {
    }

    public MarketDataConfigBuilder add(String name, Object value) {
        ArgChecker.notEmpty((String)name, (String)"name");
        ArgChecker.notNull((Object)value, (String)"value");
        Class<?> configType = value.getClass();
        SingleTypeMarketDataConfig configs = this.configsForType(configType);
        this.values.put(configType, configs.withConfig(name, value));
        return this;
    }

    public MarketDataConfigBuilder add(TypedString<?> name, Object value) {
        ArgChecker.notNull(name, (String)"name");
        ArgChecker.notNull((Object)value, (String)"value");
        Class<?> configType = value.getClass();
        SingleTypeMarketDataConfig configs = this.configsForType(configType);
        this.values.put(configType, configs.withConfig(name.getName(), value));
        return this;
    }

    public <T> MarketDataConfigBuilder addDefault(T value) {
        ArgChecker.notNull(value, (String)"value");
        this.defaultValues.put(value.getClass(), value);
        return this;
    }

    public MarketDataConfig build() {
        return new MarketDataConfig(this.values, this.defaultValues);
    }

    private SingleTypeMarketDataConfig configsForType(Class<?> configType) {
        SingleTypeMarketDataConfig configs = this.values.get(configType);
        if (configs != null) {
            return configs;
        }
        SingleTypeMarketDataConfig newConfigs = SingleTypeMarketDataConfig.builder().configType(configType).build();
        this.values.put(configType, newConfigs);
        return newConfigs;
    }
}

