/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.calc.ReportingCurrencyType;
import com.opengamma.strata.collect.Messages;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class ReportingCurrency
implements ImmutableBean,
Serializable {
    public static final ReportingCurrency NATURAL = new ReportingCurrency(ReportingCurrencyType.NATURAL, null);
    public static final ReportingCurrency NONE = new ReportingCurrency(ReportingCurrencyType.NONE, null);
    @PropertyDefinition(validate="notNull")
    private final ReportingCurrencyType type;
    @PropertyDefinition(get="field")
    private final Currency currency;
    private static final long serialVersionUID = 1L;

    public static ReportingCurrency of(Currency currency) {
        return new ReportingCurrency(ReportingCurrencyType.SPECIFIC, currency);
    }

    public boolean isSpecific() {
        return this.type == ReportingCurrencyType.SPECIFIC;
    }

    public boolean isNatural() {
        return this.type == ReportingCurrencyType.NATURAL;
    }

    public boolean isNone() {
        return this.type == ReportingCurrencyType.NONE;
    }

    public Currency getCurrency() {
        if (!this.isSpecific()) {
            throw new IllegalStateException(Messages.format((String)"No currency available for type '{}'", (Object)((Object)this.type)));
        }
        return this.currency;
    }

    public String toString() {
        return (Object)((Object)this.type) + (this.currency != null ? ":" + this.currency.toString() : "");
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private ReportingCurrency(ReportingCurrencyType type, Currency currency) {
        JodaBeanUtils.notNull((Object)((Object)type), (String)"type");
        this.type = type;
        this.currency = currency;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public ReportingCurrencyType getType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ReportingCurrency other = (ReportingCurrency)obj;
            return JodaBeanUtils.equal((Object)((Object)this.type), (Object)((Object)other.type)) && JodaBeanUtils.equal((Object)this.currency, (Object)other.currency);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.type));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        return hash;
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<ReportingCurrency> {
        private ReportingCurrencyType type;
        private Currency currency;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3575610: {
                    return this.type;
                }
                case 575402001: {
                    return this.currency;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3575610: {
                    this.type = (ReportingCurrencyType)((Object)newValue);
                    break;
                }
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public ReportingCurrency build() {
            return new ReportingCurrency(this.type, this.currency);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("ReportingCurrency.Builder{");
            buf.append("type").append('=').append(JodaBeanUtils.toString((Object)((Object)this.type))).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<ReportingCurrencyType> type = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"type", ReportingCurrency.class, ReportingCurrencyType.class);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", ReportingCurrency.class, Currency.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"type", "currency"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3575610: {
                    return this.type;
                }
                case 575402001: {
                    return this.currency;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends ReportingCurrency> builder() {
            return new Builder();
        }

        public Class<? extends ReportingCurrency> beanType() {
            return ReportingCurrency.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<ReportingCurrencyType> type() {
            return this.type;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3575610: {
                    return ((ReportingCurrency)bean).getType();
                }
                case 575402001: {
                    return ((ReportingCurrency)bean).currency;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

