/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc;

import com.opengamma.strata.calc.Measure;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class ImmutableMeasure
implements Measure,
ImmutableBean,
Serializable {
    private static final Pattern NAME_PATTERN = Pattern.compile("[A-Za-z0-9-]+");
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final String name;
    @PropertyDefinition(overrideGet=true)
    private final boolean currencyConvertible;
    private static final long serialVersionUID = 1L;

    @ImmutableValidator
    private void validate() {
        if (!NAME_PATTERN.matcher(this.name).matches()) {
            throw new IllegalArgumentException("Measure name must only contain the characters A-Z, a-z, 0-9 and -");
        }
    }

    public static ImmutableMeasure of(String name) {
        return new ImmutableMeasure(name, true);
    }

    public static ImmutableMeasure of(String name, boolean isCurrencyConvertible) {
        return new ImmutableMeasure(name, isCurrencyConvertible);
    }

    public String toString() {
        return this.getName();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private ImmutableMeasure(String name, boolean currencyConvertible) {
        JodaBeanUtils.notNull((Object)name, (String)"name");
        this.name = name;
        this.currencyConvertible = currencyConvertible;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isCurrencyConvertible() {
        return this.currencyConvertible;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ImmutableMeasure other = (ImmutableMeasure)obj;
            return JodaBeanUtils.equal((Object)this.name, (Object)other.name) && this.currencyConvertible == other.currencyConvertible;
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.name);
        hash = hash * 31 + JodaBeanUtils.hashCode((boolean)this.currencyConvertible);
        return hash;
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<ImmutableMeasure> {
        private String name;
        private boolean currencyConvertible;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 1098971060: {
                    return this.currencyConvertible;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    this.name = (String)newValue;
                    break;
                }
                case 1098971060: {
                    this.currencyConvertible = (Boolean)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public ImmutableMeasure build() {
            return new ImmutableMeasure(this.name, this.currencyConvertible);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("ImmutableMeasure.Builder{");
            buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
            buf.append("currencyConvertible").append('=').append(JodaBeanUtils.toString((Object)this.currencyConvertible));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<String> name = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"name", ImmutableMeasure.class, String.class);
        private final MetaProperty<Boolean> currencyConvertible = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currencyConvertible", ImmutableMeasure.class, Boolean.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"name", "currencyConvertible"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 1098971060: {
                    return this.currencyConvertible;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends ImmutableMeasure> builder() {
            return new Builder();
        }

        public Class<? extends ImmutableMeasure> beanType() {
            return ImmutableMeasure.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<String> name() {
            return this.name;
        }

        public MetaProperty<Boolean> currencyConvertible() {
            return this.currencyConvertible;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return ((ImmutableMeasure)bean).getName();
                }
                case 1098971060: {
                    return ((ImmutableMeasure)bean).isCurrencyConvertible();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

