/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc;

import com.opengamma.strata.basics.CalculationTarget;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.calc.CalculationRules;
import com.opengamma.strata.calc.CalculationRunner;
import com.opengamma.strata.calc.Column;
import com.opengamma.strata.calc.Results;
import com.opengamma.strata.calc.runner.CalculationListener;
import com.opengamma.strata.calc.runner.CalculationTaskRunner;
import com.opengamma.strata.calc.runner.CalculationTasks;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import java.util.List;
import java.util.concurrent.ExecutorService;

class DefaultCalculationRunner
implements CalculationRunner {
    private final CalculationTaskRunner taskRunner;

    static DefaultCalculationRunner ofMultiThreaded() {
        return new DefaultCalculationRunner(CalculationTaskRunner.ofMultiThreaded());
    }

    static DefaultCalculationRunner of(ExecutorService executor) {
        return new DefaultCalculationRunner(CalculationTaskRunner.of(executor));
    }

    DefaultCalculationRunner(CalculationTaskRunner taskRunner) {
        this.taskRunner = (CalculationTaskRunner)ArgChecker.notNull((Object)taskRunner, (String)"taskRunner");
    }

    @Override
    public Results calculate(CalculationRules calculationRules, List<? extends CalculationTarget> targets, List<Column> columns, MarketData marketData, ReferenceData refData) {
        CalculationTasks tasks = CalculationTasks.of(calculationRules, targets, columns, refData);
        return this.taskRunner.calculate(tasks, marketData, refData);
    }

    @Override
    public void calculateAsync(CalculationRules calculationRules, List<? extends CalculationTarget> targets, List<Column> columns, MarketData marketData, ReferenceData refData, CalculationListener listener) {
        CalculationTasks tasks = CalculationTasks.of(calculationRules, targets, columns, refData);
        this.taskRunner.calculateAsync(tasks, marketData, refData, listener);
    }

    @Override
    public Results calculateMultiScenario(CalculationRules calculationRules, List<? extends CalculationTarget> targets, List<Column> columns, ScenarioMarketData marketData, ReferenceData refData) {
        CalculationTasks tasks = CalculationTasks.of(calculationRules, targets, columns, refData);
        return this.taskRunner.calculateMultiScenario(tasks, marketData, refData);
    }

    @Override
    public void calculateMultiScenarioAsync(CalculationRules calculationRules, List<? extends CalculationTarget> targets, List<Column> columns, ScenarioMarketData marketData, ReferenceData refData, CalculationListener listener) {
        CalculationTasks tasks = CalculationTasks.of(calculationRules, targets, columns, refData);
        this.taskRunner.calculateMultiScenarioAsync(tasks, marketData, refData, listener);
    }

    @Override
    public CalculationTaskRunner getTaskRunner() {
        return this.taskRunner;
    }

    @Override
    public void close() {
        this.taskRunner.close();
    }
}

