/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.themoviedbapi.wrapper;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.omertron.themoviedbapi.model.Artwork;
import com.omertron.themoviedbapi.model.ArtworkType;
import com.omertron.themoviedbapi.wrapper.AbstractWrapperAll;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class WrapperImages
extends AbstractWrapperAll
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="backdrops")
    private List<Artwork> backdrops = Collections.EMPTY_LIST;
    @JsonProperty(value="posters")
    private List<Artwork> posters = Collections.EMPTY_LIST;
    @JsonProperty(value="profiles")
    private List<Artwork> profiles = Collections.EMPTY_LIST;

    public List<Artwork> getBackdrops() {
        return this.backdrops;
    }

    public List<Artwork> getPosters() {
        return this.posters;
    }

    public List<Artwork> getProfiles() {
        return this.profiles;
    }

    public void setBackdrops(List<Artwork> backdrops) {
        this.backdrops = backdrops;
    }

    public void setPosters(List<Artwork> posters) {
        this.posters = posters;
    }

    public void setProfiles(List<Artwork> profiles) {
        this.profiles = profiles;
    }

    public List<Artwork> getAll(ArtworkType ... artworkList) {
        ArrayList<Artwork> artwork = new ArrayList<Artwork>();
        ArrayList<ArtworkType> types = artworkList.length > 0 ? new ArrayList<ArtworkType>(Arrays.asList(artworkList)) : new ArrayList<ArtworkType>(Arrays.asList(ArtworkType.values()));
        if (types.contains((Object)ArtworkType.POSTER)) {
            this.updateArtworkType(this.posters, ArtworkType.POSTER);
            artwork.addAll(this.posters);
        }
        if (types.contains((Object)ArtworkType.BACKDROP)) {
            this.updateArtworkType(this.backdrops, ArtworkType.BACKDROP);
            artwork.addAll(this.backdrops);
        }
        if (types.contains((Object)ArtworkType.PROFILE)) {
            this.updateArtworkType(this.profiles, ArtworkType.PROFILE);
            artwork.addAll(this.profiles);
        }
        return artwork;
    }

    private void updateArtworkType(List<Artwork> artworkList, ArtworkType type) {
        for (Artwork artwork : artworkList) {
            artwork.setArtworkType(type);
        }
    }
}

