/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.themoviedbapi.tools;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiUrl {
    private static final Logger LOG = LoggerFactory.getLogger(ApiUrl.class);
    private static final String TMDB_API_BASE = "http://api.themoviedb.org/3/";
    private static final String DELIMITER_FIRST = "?";
    private static final String DELIMITER_SUBSEQUENT = "&";
    private static final String DEFAULT_STRING = "";
    private final String apiKey;
    private final String method;
    private final String submethod;
    private final Map<String, String> arguments = new HashMap<String, String>();
    public static final String PARAM_ADULT = "include_adult=";
    public static final String PARAM_API_KEY = "api_key=";
    public static final String PARAM_COUNTRY = "country=";
    public static final String PARAM_FAVORITE = "favorite=";
    public static final String PARAM_ID = "id=";
    public static final String PARAM_LANGUAGE = "language=";
    public static final String PARAM_INCLUDE_ALL_MOVIES = "include_all_movies=";
    public static final String PARAM_MOVIE_WATCHLIST = "movie_watchlist=";
    public static final String PARAM_PAGE = "page=";
    public static final String PARAM_QUERY = "query=";
    public static final String PARAM_SESSION = "session_id=";
    public static final String PARAM_TOKEN = "request_token=";
    public static final String PARAM_VALUE = "value=";
    public static final String PARAM_YEAR = "year=";
    public static final String PARAM_START_DATE = "start_date=";
    public static final String PARAM_END_DATE = "end_date=";
    private static final String APPEND_TO_RESPONSE = "append_to_response=";

    public ApiUrl(String apiKey, String method) {
        this.apiKey = apiKey;
        this.method = method;
        this.submethod = DEFAULT_STRING;
    }

    public ApiUrl(String apiKey, String method, String submethod) {
        this.apiKey = apiKey;
        this.method = method;
        this.submethod = submethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL buildUrl() {
        StringBuilder urlString = new StringBuilder(TMDB_API_BASE);
        urlString.append(this.method);
        if (this.arguments.containsKey(PARAM_QUERY)) {
            if (StringUtils.endsWith((CharSequence)urlString, (CharSequence)"/") && this.submethod.startsWith("/")) {
                urlString.deleteCharAt(urlString.length() - 1);
            }
            urlString.append(this.submethod);
            urlString.append(DELIMITER_FIRST).append(PARAM_API_KEY);
            urlString.append(this.apiKey);
            urlString.append(DELIMITER_SUBSEQUENT);
            urlString.append(PARAM_QUERY);
            String query = this.arguments.get(PARAM_QUERY);
            try {
                urlString.append(URLEncoder.encode(query, "UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                LOG.trace("Unable to encode query: '{}' trying raw.", (Object)query);
                urlString.append(query);
            }
            this.arguments.remove(PARAM_QUERY);
        } else {
            if (this.arguments.containsKey(PARAM_ID)) {
                urlString.append(this.arguments.get(PARAM_ID));
                this.arguments.remove(PARAM_ID);
            }
            if (StringUtils.endsWith((CharSequence)urlString, (CharSequence)"/") && this.submethod.startsWith("/")) {
                urlString.deleteCharAt(urlString.length() - 1);
            }
            urlString.append(this.submethod);
            urlString.append(DELIMITER_FIRST).append(PARAM_API_KEY);
            urlString.append(this.apiKey);
        }
        for (Map.Entry<String, String> argEntry : this.arguments.entrySet()) {
            urlString.append(DELIMITER_SUBSEQUENT).append(argEntry.getKey());
            urlString.append(argEntry.getValue());
        }
        try {
            LOG.trace("URL: {}", (Object)urlString.toString());
            URL i$ = new URL(urlString.toString());
            return i$;
        }
        catch (MalformedURLException ex) {
            LOG.warn("Failed to create URL {} - {}", (Object)urlString.toString(), (Object)ex.toString());
            URL uRL = null;
            return uRL;
        }
        finally {
            this.arguments.clear();
        }
    }

    public void addArgument(String key, String value) {
        this.arguments.put(key, value);
    }

    public void addArgument(String key, int value) {
        this.arguments.put(key, Integer.toString(value));
    }

    public void addArgument(String key, boolean value) {
        this.arguments.put(key, Boolean.toString(value));
    }

    public void addArgument(String key, float value) {
        this.arguments.put(key, Float.toString(value));
    }

    public void clearArguments() {
        this.arguments.clear();
    }

    public void setArguments(Map<String, String> args) {
        this.arguments.putAll(args);
    }

    public void appendToResponse(String[] appendToResponse) {
        if (appendToResponse.length > 0) {
            StringBuilder sb = new StringBuilder();
            boolean first = Boolean.TRUE;
            for (String append : appendToResponse) {
                if (first) {
                    first = Boolean.FALSE;
                } else {
                    sb.append(",");
                }
                sb.append(append);
            }
            this.addArgument(APPEND_TO_RESPONSE, sb.toString());
        }
    }
}

