/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.themoviedbapi.model.comparator;

import com.omertron.themoviedbapi.model.PersonCredit;
import java.io.Serializable;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class PersonCreditDateComparator
implements Comparator<PersonCredit>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Pattern YEAR_PATTERN = Pattern.compile("(?:.*?)(\\d{4})(?:.*?)");
    private final boolean ascending;

    public PersonCreditDateComparator() {
        this.ascending = Boolean.FALSE;
    }

    public PersonCreditDateComparator(boolean ascending) {
        this.ascending = ascending;
    }

    @Override
    public int compare(PersonCredit pc1, PersonCredit pc2) {
        return this.compare(pc1, pc2, this.ascending);
    }

    public int compare(PersonCredit pc1, PersonCredit pc2, boolean ascending) {
        boolean valid1 = StringUtils.isNotBlank((CharSequence)pc1.getReleaseDate());
        boolean valid2 = StringUtils.isNotBlank((CharSequence)pc2.getReleaseDate());
        if (!valid1 && !valid2) {
            return 0;
        }
        if (!valid1) {
            return ascending ? -1 : 1;
        }
        if (!valid2) {
            return ascending ? 1 : -1;
        }
        int year1 = PersonCreditDateComparator.extractYear(pc1.getReleaseDate());
        int year2 = PersonCreditDateComparator.extractYear(pc2.getReleaseDate());
        return ascending ? year1 - year2 : year2 - year1;
    }

    private static int extractYear(String date) {
        int year = 0;
        Matcher m = YEAR_PATTERN.matcher(date);
        if (m.find()) {
            year = Integer.valueOf(m.group(1));
        }
        return year;
    }
}

