/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.themoviedbapi.model;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Discover {
    private final Map<String, String> params = new HashMap<String, String>();
    private static final String PARAM_PRIMARY_RELEASE_YEAR = "primary_release_year=";
    private static final String PARAM_VOTE_COUNT_GTE = "vote_count.gte=";
    private static final String PARAM_VOTE_AVERAGE_GTE = "vote_average.gte=";
    private static final String PARAM_WITH_GENRES = "with_genres=";
    private static final String PARAM_RELEASE_DATE_GTE = "release_date.gte=";
    private static final String PARAM_RELEASE_DATE_LTE = "release_date.lte=";
    private static final String PARAM_CERTIFICATION_COUNTRY = "certification_country=";
    private static final String PARAM_CERTIFICATION_LTE = "certification.lte=";
    private static final String PARAM_WITH_COMPANIES = "with_companies=";
    private static final String PARAM_SORT_BY = "sort_by=";
    private static final int YEAR_MIN = 1900;
    private static final int YEAR_MAX = 2100;

    public Map<String, String> getParams() {
        return this.params;
    }

    public Discover page(int page) {
        if (page > 0) {
            this.params.put("page=", String.valueOf(page));
        }
        return this;
    }

    public Discover language(String language) {
        if (StringUtils.isNotBlank((CharSequence)language)) {
            this.params.put("language=", language);
        }
        return this;
    }

    public Discover sortBy(String sortBy) {
        if (StringUtils.isNotBlank((CharSequence)sortBy)) {
            this.params.put(PARAM_SORT_BY, sortBy);
        }
        return this;
    }

    public Discover includeAdult(boolean includeAdult) {
        this.params.put("include_adult=", String.valueOf(includeAdult));
        return this;
    }

    public Discover year(int year) {
        if (this.checkYear(year)) {
            this.params.put("year=", String.valueOf(year));
        }
        return this;
    }

    public Discover primaryReleaseYear(int primaryReleaseYear) {
        if (this.checkYear(primaryReleaseYear)) {
            this.params.put(PARAM_PRIMARY_RELEASE_YEAR, String.valueOf(primaryReleaseYear));
        }
        return this;
    }

    public Discover voteCountGte(int voteCountGte) {
        if (voteCountGte > 0) {
            this.params.put(PARAM_VOTE_COUNT_GTE, String.valueOf(voteCountGte));
        }
        return this;
    }

    public Discover voteAverageGte(float voteAverageGte) {
        if (voteAverageGte > 0.0f) {
            this.params.put(PARAM_VOTE_AVERAGE_GTE, String.valueOf(voteAverageGte));
        }
        return this;
    }

    public Discover withGenres(String withGenres) {
        if (StringUtils.isNotBlank((CharSequence)withGenres)) {
            this.params.put(PARAM_WITH_GENRES, withGenres);
        }
        return this;
    }

    public Discover releaseDateGte(String releaseDateGte) {
        if (StringUtils.isNotBlank((CharSequence)releaseDateGte)) {
            this.params.put(PARAM_RELEASE_DATE_GTE, releaseDateGte);
        }
        return this;
    }

    public Discover releaseDateLte(String releaseDateLte) {
        if (StringUtils.isNotBlank((CharSequence)releaseDateLte)) {
            this.params.put(PARAM_RELEASE_DATE_LTE, releaseDateLte);
        }
        return this;
    }

    public Discover certificationCountry(String certificationCountry) {
        if (StringUtils.isNotBlank((CharSequence)certificationCountry)) {
            this.params.put(PARAM_CERTIFICATION_COUNTRY, certificationCountry);
        }
        return this;
    }

    public Discover certificationLte(String certificationLte) {
        if (StringUtils.isNotBlank((CharSequence)certificationLte)) {
            this.params.put(PARAM_CERTIFICATION_LTE, certificationLte);
        }
        return this;
    }

    public Discover withCompanies(String withCompanies) {
        if (StringUtils.isNotBlank((CharSequence)withCompanies)) {
            this.params.put(PARAM_WITH_COMPANIES, withCompanies);
        }
        return this;
    }

    private boolean checkYear(int year) {
        return year >= 1900 && year <= 2100;
    }
}

