/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.themoviedbapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.omertron.themoviedbapi.MovieDbException;
import com.omertron.themoviedbapi.model.Account;
import com.omertron.themoviedbapi.model.AlternativeTitle;
import com.omertron.themoviedbapi.model.Artwork;
import com.omertron.themoviedbapi.model.ArtworkType;
import com.omertron.themoviedbapi.model.ChangeKeyItem;
import com.omertron.themoviedbapi.model.ChangedItem;
import com.omertron.themoviedbapi.model.ChangedMovie;
import com.omertron.themoviedbapi.model.Collection;
import com.omertron.themoviedbapi.model.CollectionInfo;
import com.omertron.themoviedbapi.model.Company;
import com.omertron.themoviedbapi.model.Discover;
import com.omertron.themoviedbapi.model.Genre;
import com.omertron.themoviedbapi.model.JobDepartment;
import com.omertron.themoviedbapi.model.Keyword;
import com.omertron.themoviedbapi.model.KeywordMovie;
import com.omertron.themoviedbapi.model.ListItemStatus;
import com.omertron.themoviedbapi.model.MovieDb;
import com.omertron.themoviedbapi.model.MovieDbList;
import com.omertron.themoviedbapi.model.MovieDbListStatus;
import com.omertron.themoviedbapi.model.MovieList;
import com.omertron.themoviedbapi.model.Person;
import com.omertron.themoviedbapi.model.PersonCredit;
import com.omertron.themoviedbapi.model.PersonType;
import com.omertron.themoviedbapi.model.ReleaseInfo;
import com.omertron.themoviedbapi.model.Reviews;
import com.omertron.themoviedbapi.model.StatusCode;
import com.omertron.themoviedbapi.model.TmdbConfiguration;
import com.omertron.themoviedbapi.model.TokenAuthorisation;
import com.omertron.themoviedbapi.model.TokenSession;
import com.omertron.themoviedbapi.model.Trailer;
import com.omertron.themoviedbapi.model.Translation;
import com.omertron.themoviedbapi.results.TmdbResultsList;
import com.omertron.themoviedbapi.results.TmdbResultsMap;
import com.omertron.themoviedbapi.tools.ApiUrl;
import com.omertron.themoviedbapi.tools.WebBrowser;
import com.omertron.themoviedbapi.wrapper.WrapperAlternativeTitles;
import com.omertron.themoviedbapi.wrapper.WrapperChanges;
import com.omertron.themoviedbapi.wrapper.WrapperCollection;
import com.omertron.themoviedbapi.wrapper.WrapperCompany;
import com.omertron.themoviedbapi.wrapper.WrapperCompanyMovies;
import com.omertron.themoviedbapi.wrapper.WrapperConfig;
import com.omertron.themoviedbapi.wrapper.WrapperGenres;
import com.omertron.themoviedbapi.wrapper.WrapperImages;
import com.omertron.themoviedbapi.wrapper.WrapperJobList;
import com.omertron.themoviedbapi.wrapper.WrapperKeywordMovies;
import com.omertron.themoviedbapi.wrapper.WrapperKeywords;
import com.omertron.themoviedbapi.wrapper.WrapperMovie;
import com.omertron.themoviedbapi.wrapper.WrapperMovieCasts;
import com.omertron.themoviedbapi.wrapper.WrapperMovieChanges;
import com.omertron.themoviedbapi.wrapper.WrapperMovieDbList;
import com.omertron.themoviedbapi.wrapper.WrapperMovieKeywords;
import com.omertron.themoviedbapi.wrapper.WrapperMovieList;
import com.omertron.themoviedbapi.wrapper.WrapperPerson;
import com.omertron.themoviedbapi.wrapper.WrapperPersonCredits;
import com.omertron.themoviedbapi.wrapper.WrapperPersonList;
import com.omertron.themoviedbapi.wrapper.WrapperReleaseInfo;
import com.omertron.themoviedbapi.wrapper.WrapperReviews;
import com.omertron.themoviedbapi.wrapper.WrapperTrailers;
import com.omertron.themoviedbapi.wrapper.WrapperTranslations;
import java.io.IOException;
import java.lang.constant.Constable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yamj.api.common.http.CommonHttpClient;

public class TheMovieDbApi {
    private static final Logger LOG = LoggerFactory.getLogger(TheMovieDbApi.class);
    private String apiKey;
    private CommonHttpClient httpClient;
    private TmdbConfiguration tmdbConfig;
    private static final String BASE_MOVIE = "movie/";
    private static final String BASE_PERSON = "person/";
    private static final String BASE_COMPANY = "company/";
    private static final String BASE_GENRE = "genre/";
    private static final String BASE_AUTH = "authentication/";
    private static final String BASE_COLLECTION = "collection/";
    private static final String BASE_ACCOUNT = "account/";
    private static final String BASE_SEARCH = "search/";
    private static final String BASE_LIST = "list/";
    private static final String BASE_KEYWORD = "keyword/";
    private static final String BASE_JOB = "job/";
    private static final String BASE_DISCOVER = "discover/";
    private static ObjectMapper mapper = new ObjectMapper();

    public TheMovieDbApi(String apiKey) throws MovieDbException {
        this(apiKey, null);
    }

    public TheMovieDbApi(String apiKey, CommonHttpClient httpClient) throws MovieDbException {
        this.apiKey = apiKey;
        this.httpClient = httpClient;
        ApiUrl apiUrl = new ApiUrl(apiKey, "configuration");
        URL configUrl = apiUrl.buildUrl();
        String webpage = this.requestWebPage(configUrl);
        try {
            WrapperConfig wc = (WrapperConfig)mapper.readValue(webpage, WrapperConfig.class);
            this.tmdbConfig = wc.getTmdbConfiguration();
        }
        catch (IOException ex) {
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, "Failed to read configuration", ex);
        }
    }

    public String getApiKey() {
        return this.apiKey;
    }

    private String requestWebPage(URL url) throws MovieDbException {
        return this.requestWebPage(url, null, Boolean.FALSE);
    }

    private String requestWebPage(URL url, String jsonBody) throws MovieDbException {
        return this.requestWebPage(url, jsonBody, Boolean.FALSE);
    }

    private String requestWebPage(URL url, String jsonBody, boolean isDeleteRequest) throws MovieDbException {
        String webpage;
        if (this.httpClient == null) {
            webpage = WebBrowser.request(url, jsonBody, isDeleteRequest);
        } else {
            try {
                HttpGet httpGet = new HttpGet(url.toURI());
                httpGet.addHeader("accept", "application/json");
                if (StringUtils.isNotBlank((CharSequence)jsonBody)) {
                    throw new MovieDbException(MovieDbException.MovieDbExceptionType.UNKNOWN_CAUSE, "Unable to proces JSON request");
                }
                if (isDeleteRequest) {
                    throw new MovieDbException(MovieDbException.MovieDbExceptionType.UNKNOWN_CAUSE, "Unable to proces delete request");
                }
                webpage = this.httpClient.requestContent(httpGet);
            }
            catch (URISyntaxException ex) {
                throw new MovieDbException(MovieDbException.MovieDbExceptionType.CONNECTION_ERROR, null, ex);
            }
            catch (IOException ex) {
                throw new MovieDbException(MovieDbException.MovieDbExceptionType.CONNECTION_ERROR, null, ex);
            }
            catch (RuntimeException ex) {
                throw new MovieDbException(MovieDbException.MovieDbExceptionType.HTTP_503_ERROR, "Service Unavailable", ex);
            }
        }
        return webpage;
    }

    public void setProxy(String host, int port, String username, String password) {
        if (this.httpClient != null) {
            return;
        }
        WebBrowser.setProxyHost(host);
        WebBrowser.setProxyPort(port);
        WebBrowser.setProxyUsername(username);
        WebBrowser.setProxyPassword(password);
    }

    public void setTimeout(int connect, int read) {
        if (this.httpClient != null) {
            return;
        }
        WebBrowser.setWebTimeoutConnect(connect);
        WebBrowser.setWebTimeoutRead(read);
    }

    public static boolean compareMovies(MovieDb moviedb, String title, String year) {
        return TheMovieDbApi.compareMovies(moviedb, title, year, 0);
    }

    public static boolean compareMovies(MovieDb moviedb, String title, String year, int maxDistance) {
        String movieYear;
        if (moviedb == null || StringUtils.isBlank((CharSequence)title)) {
            return Boolean.FALSE;
        }
        if (TheMovieDbApi.isValidYear(year) && TheMovieDbApi.isValidYear(moviedb.getReleaseDate()) && (movieYear = moviedb.getReleaseDate().substring(0, 4)).equals(year)) {
            if (TheMovieDbApi.compareDistance(moviedb.getOriginalTitle(), title, maxDistance)) {
                return Boolean.TRUE;
            }
            if (TheMovieDbApi.compareDistance(moviedb.getTitle(), title, maxDistance)) {
                return Boolean.TRUE;
            }
        }
        if (TheMovieDbApi.compareDistance(moviedb.getOriginalTitle(), title, maxDistance)) {
            return Boolean.TRUE;
        }
        if (TheMovieDbApi.compareDistance(moviedb.getTitle(), title, maxDistance)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private static boolean compareDistance(String title1, String title2, int distance) {
        return StringUtils.getLevenshteinDistance((CharSequence)title1, (CharSequence)title2) <= distance;
    }

    private static boolean isValidYear(String year) {
        return StringUtils.isNotBlank((CharSequence)year) && !year.equals("UNKNOWN");
    }

    public TmdbConfiguration getConfiguration() {
        return this.tmdbConfig;
    }

    public URL createImageUrl(String imagePath, String requiredSize) throws MovieDbException {
        if (!this.tmdbConfig.isValidSize(requiredSize)) {
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.INVALID_IMAGE, requiredSize);
        }
        StringBuilder sb = new StringBuilder(this.tmdbConfig.getBaseUrl());
        sb.append(requiredSize);
        sb.append(imagePath);
        try {
            return new URL(sb.toString());
        }
        catch (MalformedURLException ex) {
            LOG.warn("Failed to create image URL: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.INVALID_URL, sb.toString(), ex);
        }
    }

    public TokenAuthorisation getAuthorisationToken() throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_AUTH, "token/new");
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            return (TokenAuthorisation)mapper.readValue(webpage, TokenAuthorisation.class);
        }
        catch (IOException ex) {
            LOG.warn("Failed to get Authorisation Token: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.AUTHORISATION_FAILURE, webpage, ex);
        }
    }

    public TokenSession getSessionToken(TokenAuthorisation token) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_AUTH, "session/new");
        if (!token.getSuccess().booleanValue()) {
            LOG.warn("Session token was not successful!");
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.AUTHORISATION_FAILURE, "Authorisation token was not successful!");
        }
        apiUrl.addArgument("request_token=", token.getRequestToken());
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            return (TokenSession)mapper.readValue(webpage, TokenSession.class);
        }
        catch (IOException ex) {
            LOG.warn("Failed to get Session Token: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public TokenSession getGuestSessionToken() throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_AUTH, "guest_session/new");
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            return (TokenSession)mapper.readValue(webpage, TokenSession.class);
        }
        catch (IOException ex) {
            LOG.warn("Failed to get Guest Session Token: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public Account getAccount(String sessionId) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_ACCOUNT.replace("/", ""));
        apiUrl.addArgument("session_id=", sessionId);
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            return (Account)mapper.readValue(webpage, Account.class);
        }
        catch (IOException ex) {
            LOG.warn("Failed to get Account: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public List<MovieDb> getFavoriteMovies(String sessionId, int accountId) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_ACCOUNT, accountId + "/favorite_movies");
        apiUrl.addArgument("session_id=", sessionId);
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            return ((WrapperMovie)mapper.readValue(webpage, WrapperMovie.class)).getMovies();
        }
        catch (IOException ex) {
            LOG.warn("Failed to get favorite movies: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public StatusCode changeFavoriteStatus(String sessionId, int accountId, Integer movieId, boolean isFavorite) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_ACCOUNT, accountId + "/favorite");
        apiUrl.addArgument("session_id=", sessionId);
        HashMap<String, Constable> body = new HashMap<String, Constable>();
        body.put("movie_id", movieId);
        body.put("favorite", Boolean.valueOf(isFavorite));
        String jsonBody = TheMovieDbApi.convertToJson(body);
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url, jsonBody);
        try {
            return (StatusCode)mapper.readValue(webpage, StatusCode.class);
        }
        catch (IOException ex) {
            LOG.warn("Failed to get favorite status: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public StatusCode addToWatchList(String sessionId, int accountId, Integer movieId) throws MovieDbException {
        return this.modifyWatchList(sessionId, accountId, movieId, true);
    }

    public StatusCode removeFromWatchList(String sessionId, int accountId, Integer movieId) throws MovieDbException {
        return this.modifyWatchList(sessionId, accountId, movieId, false);
    }

    private StatusCode modifyWatchList(String sessionId, int accountId, Integer movieId, boolean add) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_ACCOUNT, accountId + "/movie_watchlist");
        apiUrl.addArgument("session_id=", sessionId);
        HashMap<String, Constable> body = new HashMap<String, Constable>();
        body.put("movie_id", movieId);
        body.put("movie_watchlist", Boolean.valueOf(add));
        String jsonBody = TheMovieDbApi.convertToJson(body);
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url, jsonBody);
        try {
            return (StatusCode)mapper.readValue(webpage, StatusCode.class);
        }
        catch (IOException ex) {
            LOG.warn("Failed to modify watch list: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public MovieDb getMovieInfo(int movieId, String language, String ... appendToResponse) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_MOVIE);
        apiUrl.addArgument("id=", movieId);
        if (StringUtils.isNotBlank((CharSequence)language)) {
            apiUrl.addArgument("language=", language);
        }
        apiUrl.appendToResponse(appendToResponse);
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            MovieDb movie = (MovieDb)mapper.readValue(webpage, MovieDb.class);
            if (movie == null || movie.getId() == 0) {
                LOG.warn("No movie found for ID '{}'", (Object)movieId);
                throw new MovieDbException(MovieDbException.MovieDbExceptionType.MOVIE_ID_NOT_FOUND, "No movie found for ID: " + movieId);
            }
            return movie;
        }
        catch (IOException ex) {
            LOG.warn("Failed to get movie info: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public MovieDb getMovieInfoImdb(String imdbId, String language, String ... appendToResponse) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_MOVIE);
        apiUrl.addArgument("id=", imdbId);
        if (StringUtils.isNotBlank((CharSequence)language)) {
            apiUrl.addArgument("language=", language);
        }
        apiUrl.appendToResponse(appendToResponse);
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            MovieDb movie = (MovieDb)mapper.readValue(webpage, MovieDb.class);
            if (movie == null || movie.getId() == 0) {
                LOG.warn("No movie found for IMDB ID: '{}'", (Object)imdbId);
                throw new MovieDbException(MovieDbException.MovieDbExceptionType.MOVIE_ID_NOT_FOUND, "No movie found for IMDB ID: " + imdbId);
            }
            return movie;
        }
        catch (IOException ex) {
            LOG.warn("Failed to get movie info: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, "Failed to get movie info", ex);
        }
    }

    public TmdbResultsList<AlternativeTitle> getMovieAlternativeTitles(int movieId, String country, String ... appendToResponse) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_MOVIE, "/alternative_titles");
        apiUrl.addArgument("id=", movieId);
        if (StringUtils.isNotBlank((CharSequence)country)) {
            apiUrl.addArgument("country=", country);
        }
        apiUrl.appendToResponse(appendToResponse);
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            WrapperAlternativeTitles wrapper = (WrapperAlternativeTitles)mapper.readValue(webpage, WrapperAlternativeTitles.class);
            TmdbResultsList<AlternativeTitle> results = new TmdbResultsList<AlternativeTitle>(wrapper.getTitles());
            results.copyWrapper(wrapper);
            return results;
        }
        catch (IOException ex) {
            LOG.warn("Failed to get movie alternative titles: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public TmdbResultsList<Person> getMovieCasts(int movieId, String ... appendToResponse) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_MOVIE, "/casts");
        apiUrl.addArgument("id=", movieId);
        apiUrl.appendToResponse(appendToResponse);
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            WrapperMovieCasts wrapper = (WrapperMovieCasts)mapper.readValue(webpage, WrapperMovieCasts.class);
            TmdbResultsList<Person> results = new TmdbResultsList<Person>(wrapper.getAll());
            results.copyWrapper(wrapper);
            return results;
        }
        catch (IOException ex) {
            LOG.warn("Failed to get movie casts: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public TmdbResultsList<Artwork> getMovieImages(int movieId, String language, String ... appendToResponse) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_MOVIE, "/images");
        apiUrl.addArgument("id=", movieId);
        if (StringUtils.isNotBlank((CharSequence)language)) {
            apiUrl.addArgument("language=", language);
        }
        apiUrl.appendToResponse(appendToResponse);
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            WrapperImages wrapper = (WrapperImages)mapper.readValue(webpage, WrapperImages.class);
            TmdbResultsList<Artwork> results = new TmdbResultsList<Artwork>(wrapper.getAll(new ArtworkType[0]));
            results.copyWrapper(wrapper);
            return results;
        }
        catch (IOException ex) {
            LOG.warn("Failed to get movie images: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public TmdbResultsList<Keyword> getMovieKeywords(int movieId, String ... appendToResponse) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_MOVIE, "/keywords");
        apiUrl.addArgument("id=", movieId);
        apiUrl.appendToResponse(appendToResponse);
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            WrapperMovieKeywords wrapper = (WrapperMovieKeywords)mapper.readValue(webpage, WrapperMovieKeywords.class);
            TmdbResultsList<Keyword> results = new TmdbResultsList<Keyword>(wrapper.getKeywords());
            results.copyWrapper(wrapper);
            return results;
        }
        catch (IOException ex) {
            LOG.warn("Failed to get movie keywords: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public TmdbResultsList<ReleaseInfo> getMovieReleaseInfo(int movieId, String language, String ... appendToResponse) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_MOVIE, "/releases");
        apiUrl.addArgument("id=", movieId);
        apiUrl.addArgument("language=", language);
        apiUrl.appendToResponse(appendToResponse);
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            WrapperReleaseInfo wrapper = (WrapperReleaseInfo)mapper.readValue(webpage, WrapperReleaseInfo.class);
            TmdbResultsList<ReleaseInfo> results = new TmdbResultsList<ReleaseInfo>(wrapper.getCountries());
            results.copyWrapper(wrapper);
            return results;
        }
        catch (IOException ex) {
            LOG.warn("Failed to get movie release information: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public TmdbResultsList<Trailer> getMovieTrailers(int movieId, String language, String ... appendToResponse) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_MOVIE, "/trailers");
        apiUrl.addArgument("id=", movieId);
        if (StringUtils.isNotBlank((CharSequence)language)) {
            apiUrl.addArgument("language=", language);
        }
        apiUrl.appendToResponse(appendToResponse);
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            WrapperTrailers wrapper = (WrapperTrailers)mapper.readValue(webpage, WrapperTrailers.class);
            TmdbResultsList<Trailer> results = new TmdbResultsList<Trailer>(wrapper.getAll());
            results.copyWrapper(wrapper);
            return results;
        }
        catch (IOException ex) {
            LOG.warn("Failed to get movie trailers: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public TmdbResultsList<Translation> getMovieTranslations(int movieId, String ... appendToResponse) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_MOVIE, "/translations");
        apiUrl.addArgument("id=", movieId);
        apiUrl.appendToResponse(appendToResponse);
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            WrapperTranslations wrapper = (WrapperTranslations)mapper.readValue(webpage, WrapperTranslations.class);
            TmdbResultsList<Translation> results = new TmdbResultsList<Translation>(wrapper.getTranslations());
            results.copyWrapper(wrapper);
            return results;
        }
        catch (IOException ex) {
            LOG.warn("Failed to get movie tranlations: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public TmdbResultsList<MovieDb> getSimilarMovies(int movieId, String language, int page, String ... appendToResponse) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_MOVIE, "/similar_movies");
        apiUrl.addArgument("id=", movieId);
        if (StringUtils.isNotBlank((CharSequence)language)) {
            apiUrl.addArgument("language=", language);
        }
        if (page > 0) {
            apiUrl.addArgument("page=", page);
        }
        apiUrl.appendToResponse(appendToResponse);
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            WrapperMovie wrapper = (WrapperMovie)mapper.readValue(webpage, WrapperMovie.class);
            TmdbResultsList<MovieDb> results = new TmdbResultsList<MovieDb>(wrapper.getMovies());
            results.copyWrapper(wrapper);
            return results;
        }
        catch (IOException ex) {
            LOG.warn("Failed to get similar movies: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public TmdbResultsList<Reviews> getReviews(int movieId, String language, int page, String ... appendToResponse) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_MOVIE, "/reviews");
        apiUrl.addArgument("id=", movieId);
        if (StringUtils.isNotBlank((CharSequence)language)) {
            apiUrl.addArgument("language=", language);
        }
        if (page > 0) {
            apiUrl.addArgument("page=", page);
        }
        apiUrl.appendToResponse(appendToResponse);
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            WrapperReviews wrapper = (WrapperReviews)mapper.readValue(webpage, WrapperReviews.class);
            TmdbResultsList<Reviews> results = new TmdbResultsList<Reviews>(wrapper.getReviews());
            results.copyWrapper(wrapper);
            return results;
        }
        catch (IOException ex) {
            LOG.warn("Failed to get reviews: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public TmdbResultsList<MovieList> getMovieLists(int movieId, String language, int page, String ... appendToResponse) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_MOVIE, "/lists");
        apiUrl.addArgument("id=", movieId);
        if (StringUtils.isNotBlank((CharSequence)language)) {
            apiUrl.addArgument("language=", language);
        }
        if (page > 0) {
            apiUrl.addArgument("page=", page);
        }
        apiUrl.appendToResponse(appendToResponse);
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            WrapperMovieList wrapper = (WrapperMovieList)mapper.readValue(webpage, WrapperMovieList.class);
            TmdbResultsList<MovieList> results = new TmdbResultsList<MovieList>(wrapper.getMovieList());
            results.copyWrapper(wrapper);
            return results;
        }
        catch (IOException ex) {
            LOG.warn("Failed to get movie lists: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public TmdbResultsMap<String, List<ChangedItem>> getMovieChanges(int movieId, String startDate, String endDate) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_MOVIE, "/changes");
        apiUrl.addArgument("id=", movieId);
        if (StringUtils.isNotBlank((CharSequence)startDate)) {
            apiUrl.addArgument("start_date=", startDate);
        }
        if (StringUtils.isNotBlank((CharSequence)endDate)) {
            apiUrl.addArgument("end_date=", endDate);
        }
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            WrapperChanges wrapper = (WrapperChanges)mapper.readValue(webpage, WrapperChanges.class);
            HashMap<String, List<ChangedItem>> results = new HashMap<String, List<ChangedItem>>();
            for (ChangeKeyItem changeItem : wrapper.getChangedItems()) {
                results.put(changeItem.getKey(), changeItem.getChangedItems());
            }
            return new TmdbResultsMap<String, List<ChangedItem>>(results);
        }
        catch (IOException ex) {
            LOG.warn("Failed to get movie changes: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public MovieDb getLatestMovie() throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_MOVIE, "/latest");
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            return (MovieDb)mapper.readValue(webpage, MovieDb.class);
        }
        catch (IOException ex) {
            LOG.warn("Failed to get latest movie: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public TmdbResultsList<MovieDb> getUpcoming(String language, int page) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_MOVIE, "upcoming");
        if (StringUtils.isNotBlank((CharSequence)language)) {
            apiUrl.addArgument("language=", language);
        }
        if (page > 0) {
            apiUrl.addArgument("page=", page);
        }
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            WrapperMovie wrapper = (WrapperMovie)mapper.readValue(webpage, WrapperMovie.class);
            TmdbResultsList<MovieDb> results = new TmdbResultsList<MovieDb>(wrapper.getMovies());
            results.copyWrapper(wrapper);
            return results;
        }
        catch (IOException ex) {
            LOG.warn("Failed to get upcoming movies: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public TmdbResultsList<MovieDb> getNowPlayingMovies(String language, int page) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_MOVIE, "now-playing");
        if (StringUtils.isNotBlank((CharSequence)language)) {
            apiUrl.addArgument("language=", language);
        }
        if (page > 0) {
            apiUrl.addArgument("page=", page);
        }
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            WrapperMovie wrapper = (WrapperMovie)mapper.readValue(webpage, WrapperMovie.class);
            TmdbResultsList<MovieDb> results = new TmdbResultsList<MovieDb>(wrapper.getMovies());
            results.copyWrapper(wrapper);
            return results;
        }
        catch (IOException ex) {
            LOG.warn("Failed to get now playing movies: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public TmdbResultsList<MovieDb> getPopularMovieList(String language, int page) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_MOVIE, "popular");
        if (StringUtils.isNotBlank((CharSequence)language)) {
            apiUrl.addArgument("language=", language);
        }
        if (page > 0) {
            apiUrl.addArgument("page=", page);
        }
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            WrapperMovie wrapper = (WrapperMovie)mapper.readValue(webpage, WrapperMovie.class);
            TmdbResultsList<MovieDb> results = new TmdbResultsList<MovieDb>(wrapper.getMovies());
            results.copyWrapper(wrapper);
            return results;
        }
        catch (IOException ex) {
            LOG.warn("Failed to get popular movie list: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public TmdbResultsList<MovieDb> getTopRatedMovies(String language, int page) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_MOVIE, "top-rated");
        if (StringUtils.isNotBlank((CharSequence)language)) {
            apiUrl.addArgument("language=", language);
        }
        if (page > 0) {
            apiUrl.addArgument("page=", page);
        }
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            WrapperMovie wrapper = (WrapperMovie)mapper.readValue(webpage, WrapperMovie.class);
            TmdbResultsList<MovieDb> results = new TmdbResultsList<MovieDb>(wrapper.getMovies());
            results.copyWrapper(wrapper);
            return results;
        }
        catch (IOException ex) {
            LOG.warn("Failed to get top rated movies: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public List<MovieDb> getRatedMovies(String sessionId, int accountId) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_ACCOUNT, accountId + "/rated_movies");
        apiUrl.addArgument("session_id=", sessionId);
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            return ((WrapperMovie)mapper.readValue(webpage, WrapperMovie.class)).getMovies();
        }
        catch (IOException ex) {
            LOG.warn("Failed to get rated movies: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public boolean postMovieRating(String sessionId, Integer movieId, Integer rating) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_MOVIE, movieId + "/rating");
        apiUrl.addArgument("session_id=", sessionId);
        if (rating < 0 || rating > 10) {
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.UNKNOWN_CAUSE, "Rating out of range");
        }
        String jsonBody = TheMovieDbApi.convertToJson(Collections.singletonMap("value", rating));
        LOG.info("Body: {}", (Object)jsonBody);
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url, jsonBody);
        try {
            StatusCode status = (StatusCode)mapper.readValue(webpage, StatusCode.class);
            LOG.info("Status: {}", (Object)status);
            int code = status.getStatusCode();
            return code == 12;
        }
        catch (IOException ex) {
            LOG.warn("Failed to post movie rating: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public CollectionInfo getCollectionInfo(int collectionId, String language) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_COLLECTION);
        apiUrl.addArgument("id=", collectionId);
        if (StringUtils.isNotBlank((CharSequence)language)) {
            apiUrl.addArgument("language=", language);
        }
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            return (CollectionInfo)mapper.readValue(webpage, CollectionInfo.class);
        }
        catch (IOException ex) {
            LOG.warn("Failed to get collection information: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public TmdbResultsList<Artwork> getCollectionImages(int collectionId, String language) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_COLLECTION, "/images");
        apiUrl.addArgument("id=", collectionId);
        if (StringUtils.isNotBlank((CharSequence)language)) {
            apiUrl.addArgument("language=", language);
        }
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            WrapperImages wrapper = (WrapperImages)mapper.readValue(webpage, WrapperImages.class);
            TmdbResultsList<Artwork> results = new TmdbResultsList<Artwork>(wrapper.getAll(ArtworkType.POSTER, ArtworkType.BACKDROP));
            results.copyWrapper(wrapper);
            return results;
        }
        catch (IOException ex) {
            LOG.warn("Failed to get collection images: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public Person getPersonInfo(int personId, String ... appendToResponse) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_PERSON);
        apiUrl.addArgument("id=", personId);
        apiUrl.appendToResponse(appendToResponse);
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            return (Person)mapper.readValue(webpage, Person.class);
        }
        catch (IOException ex) {
            LOG.warn("Failed to get person info: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public TmdbResultsList<PersonCredit> getPersonCredits(int personId, String ... appendToResponse) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_PERSON, "/credits");
        apiUrl.addArgument("id=", personId);
        apiUrl.appendToResponse(appendToResponse);
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            WrapperPersonCredits wrapper = (WrapperPersonCredits)mapper.readValue(webpage, WrapperPersonCredits.class);
            TmdbResultsList<PersonCredit> results = new TmdbResultsList<PersonCredit>(wrapper.getAll(new PersonType[0]));
            results.copyWrapper(wrapper);
            return results;
        }
        catch (IOException ex) {
            LOG.warn("Failed to get person credits: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public TmdbResultsList<Artwork> getPersonImages(int personId) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_PERSON, "/images");
        apiUrl.addArgument("id=", personId);
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            WrapperImages wrapper = (WrapperImages)mapper.readValue(webpage, WrapperImages.class);
            TmdbResultsList<Artwork> results = new TmdbResultsList<Artwork>(wrapper.getAll(ArtworkType.PROFILE));
            results.copyWrapper(wrapper);
            return results;
        }
        catch (IOException ex) {
            LOG.warn("Failed to get person images: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public void getPersonChanges(int personId, String startDate, String endDate) throws MovieDbException {
        throw new MovieDbException(MovieDbException.MovieDbExceptionType.UNKNOWN_CAUSE, "Not implemented yet");
    }

    public TmdbResultsList<Person> getPersonPopular() throws MovieDbException {
        return this.getPersonPopular(0);
    }

    public TmdbResultsList<Person> getPersonPopular(int page) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_PERSON, "/popular");
        if (page > 0) {
            apiUrl.addArgument("page=", page);
        }
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            WrapperPersonList wrapper = (WrapperPersonList)mapper.readValue(webpage, WrapperPersonList.class);
            TmdbResultsList<Person> results = new TmdbResultsList<Person>(wrapper.getPersonList());
            results.copyWrapper(wrapper);
            return results;
        }
        catch (IOException ex) {
            LOG.warn("Failed to get popular person: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public Person getPersonLatest() throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_PERSON, "/latest");
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            return (Person)mapper.readValue(webpage, Person.class);
        }
        catch (IOException ex) {
            LOG.warn("Failed to get latest person: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public Company getCompanyInfo(int companyId) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_COMPANY);
        apiUrl.addArgument("id=", companyId);
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            return (Company)mapper.readValue(webpage, Company.class);
        }
        catch (IOException ex) {
            LOG.warn("Failed to get company information: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public TmdbResultsList<MovieDb> getCompanyMovies(int companyId, String language, int page) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_COMPANY, "/movies");
        apiUrl.addArgument("id=", companyId);
        if (StringUtils.isNotBlank((CharSequence)language)) {
            apiUrl.addArgument("language=", language);
        }
        if (page > 0) {
            apiUrl.addArgument("page=", page);
        }
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            WrapperCompanyMovies wrapper = (WrapperCompanyMovies)mapper.readValue(webpage, WrapperCompanyMovies.class);
            TmdbResultsList<MovieDb> results = new TmdbResultsList<MovieDb>(wrapper.getResults());
            results.copyWrapper(wrapper);
            return results;
        }
        catch (IOException ex) {
            LOG.warn("Failed to get company movies: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public TmdbResultsList<Genre> getGenreList(String language) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_GENRE, "/list");
        apiUrl.addArgument("language=", language);
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            WrapperGenres wrapper = (WrapperGenres)mapper.readValue(webpage, WrapperGenres.class);
            TmdbResultsList<Genre> results = new TmdbResultsList<Genre>(wrapper.getGenres());
            results.copyWrapper(wrapper);
            return results;
        }
        catch (IOException ex) {
            LOG.warn("Failed to get genre list: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public TmdbResultsList<MovieDb> getGenreMovies(int genreId, String language, int page, boolean includeAllMovies) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_GENRE, "/movies");
        apiUrl.addArgument("id=", genreId);
        if (StringUtils.isNotBlank((CharSequence)language)) {
            apiUrl.addArgument("language=", language);
        }
        if (page > 0) {
            apiUrl.addArgument("page=", page);
        }
        apiUrl.addArgument("include_all_movies=", includeAllMovies);
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            WrapperMovie wrapper = (WrapperMovie)mapper.readValue(webpage, WrapperMovie.class);
            TmdbResultsList<MovieDb> results = new TmdbResultsList<MovieDb>(wrapper.getMovies());
            results.copyWrapper(wrapper);
            return results;
        }
        catch (IOException ex) {
            LOG.warn("Failed to get genre movie list: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public TmdbResultsList<MovieDb> searchMovie(String movieName, int searchYear, String language, boolean includeAdult, int page) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_SEARCH, "movie");
        if (StringUtils.isNotBlank((CharSequence)movieName)) {
            apiUrl.addArgument("query=", movieName);
        }
        if (searchYear > 0) {
            apiUrl.addArgument("year=", Integer.toString(searchYear));
        }
        if (StringUtils.isNotBlank((CharSequence)language)) {
            apiUrl.addArgument("language=", language);
        }
        apiUrl.addArgument("include_adult=", Boolean.toString(includeAdult));
        if (page > 0) {
            apiUrl.addArgument("page=", Integer.toString(page));
        }
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            WrapperMovie wrapper = (WrapperMovie)mapper.readValue(webpage, WrapperMovie.class);
            TmdbResultsList<MovieDb> results = new TmdbResultsList<MovieDb>(wrapper.getMovies());
            results.copyWrapper(wrapper);
            return results;
        }
        catch (IOException ex) {
            LOG.warn("Failed to find movie: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public TmdbResultsList<Collection> searchCollection(String query, String language, int page) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_SEARCH, "collection");
        if (StringUtils.isNotBlank((CharSequence)query)) {
            apiUrl.addArgument("query=", query);
        }
        if (StringUtils.isNotBlank((CharSequence)language)) {
            apiUrl.addArgument("language=", language);
        }
        if (page > 0) {
            apiUrl.addArgument("page=", Integer.toString(page));
        }
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            WrapperCollection wrapper = (WrapperCollection)mapper.readValue(webpage, WrapperCollection.class);
            TmdbResultsList<Collection> results = new TmdbResultsList<Collection>(wrapper.getResults());
            results.copyWrapper(wrapper);
            return results;
        }
        catch (IOException ex) {
            LOG.warn("Failed to find collection: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public TmdbResultsList<Person> searchPeople(String personName, boolean includeAdult, int page) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_SEARCH, "person");
        apiUrl.addArgument("query=", personName);
        apiUrl.addArgument("include_adult=", includeAdult);
        if (page > 0) {
            apiUrl.addArgument("page=", page);
        }
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            WrapperPerson wrapper = (WrapperPerson)mapper.readValue(webpage, WrapperPerson.class);
            TmdbResultsList<Person> results = new TmdbResultsList<Person>(wrapper.getResults());
            results.copyWrapper(wrapper);
            return results;
        }
        catch (IOException ex) {
            LOG.warn("Failed to find person: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public TmdbResultsList<MovieList> searchList(String query, String language, int page) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_SEARCH, "list");
        if (StringUtils.isNotBlank((CharSequence)query)) {
            apiUrl.addArgument("query=", query);
        }
        if (StringUtils.isNotBlank((CharSequence)language)) {
            apiUrl.addArgument("language=", language);
        }
        if (page > 0) {
            apiUrl.addArgument("page=", Integer.toString(page));
        }
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            WrapperMovieList wrapper = (WrapperMovieList)mapper.readValue(webpage, WrapperMovieList.class);
            TmdbResultsList<MovieList> results = new TmdbResultsList<MovieList>(wrapper.getMovieList());
            results.copyWrapper(wrapper);
            return results;
        }
        catch (IOException ex) {
            LOG.warn("Failed to find list: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public TmdbResultsList<Company> searchCompanies(String companyName, int page) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_SEARCH, "company");
        apiUrl.addArgument("query=", companyName);
        if (page > 0) {
            apiUrl.addArgument("page=", page);
        }
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            WrapperCompany wrapper = (WrapperCompany)mapper.readValue(webpage, WrapperCompany.class);
            TmdbResultsList<Company> results = new TmdbResultsList<Company>(wrapper.getResults());
            results.copyWrapper(wrapper);
            return results;
        }
        catch (IOException ex) {
            LOG.warn("Failed to find company: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public TmdbResultsList<Keyword> searchKeyword(String query, int page) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_SEARCH, "keyword");
        if (StringUtils.isNotBlank((CharSequence)query)) {
            apiUrl.addArgument("query=", query);
        }
        if (page > 0) {
            apiUrl.addArgument("page=", Integer.toString(page));
        }
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            WrapperKeywords wrapper = (WrapperKeywords)mapper.readValue(webpage, WrapperKeywords.class);
            TmdbResultsList<Keyword> results = new TmdbResultsList<Keyword>(wrapper.getResults());
            results.copyWrapper(wrapper);
            return results;
        }
        catch (IOException ex) {
            LOG.warn("Failed to find keyword: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public MovieDbList getList(String listId) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_LIST);
        apiUrl.addArgument("id=", listId);
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            return (MovieDbList)mapper.readValue(webpage, MovieDbList.class);
        }
        catch (IOException ex) {
            LOG.warn("Failed to get list: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public List<MovieDbList> getUserLists(String sessionId, int accountID) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_ACCOUNT, accountID + "/lists");
        apiUrl.addArgument("session_id=", sessionId);
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            return ((WrapperMovieDbList)mapper.readValue(webpage, WrapperMovieDbList.class)).getLists();
        }
        catch (IOException ex) {
            LOG.warn("Failed to get user list: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public String createList(String sessionId, String name, String description) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, "list");
        apiUrl.addArgument("session_id=", sessionId);
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("name", StringUtils.trimToEmpty((String)name));
        body.put("description", StringUtils.trimToEmpty((String)description));
        String jsonBody = TheMovieDbApi.convertToJson(body);
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url, jsonBody);
        try {
            return ((MovieDbListStatus)mapper.readValue(webpage, MovieDbListStatus.class)).getListId();
        }
        catch (IOException ex) {
            LOG.warn("Failed to create list: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public boolean isMovieOnList(String listId, Integer movieId) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_LIST, listId + "/item_status");
        apiUrl.addArgument("movie_id", movieId);
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            return ((ListItemStatus)mapper.readValue(webpage, ListItemStatus.class)).isItemPresent();
        }
        catch (IOException ex) {
            LOG.warn("Failed to get item status: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public StatusCode addMovieToList(String sessionId, String listId, Integer movieId) throws MovieDbException {
        return this.modifyMovieList(sessionId, listId, movieId, "/add_item");
    }

    public StatusCode removeMovieFromList(String sessionId, String listId, Integer movieId) throws MovieDbException {
        return this.modifyMovieList(sessionId, listId, movieId, "/remove_item");
    }

    private StatusCode modifyMovieList(String sessionId, String listId, Integer movieId, String operation) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_LIST, listId + operation);
        apiUrl.addArgument("session_id=", sessionId);
        String jsonBody = TheMovieDbApi.convertToJson(Collections.singletonMap("media_id", movieId + ""));
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url, jsonBody);
        try {
            return (StatusCode)mapper.readValue(webpage, StatusCode.class);
        }
        catch (IOException ex) {
            LOG.warn("Failed to remove movie from list: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public List<MovieDb> getWatchList(String sessionId, int accountId) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_ACCOUNT, accountId + "/movie_watchlist");
        apiUrl.addArgument("session_id=", sessionId);
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            return ((WrapperMovie)mapper.readValue(webpage, WrapperMovie.class)).getMovies();
        }
        catch (IOException ex) {
            LOG.warn("Failed to get watch list: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public StatusCode deleteMovieList(String sessionId, String listId) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_LIST, listId);
        apiUrl.addArgument("session_id=", sessionId);
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url, null, true);
        try {
            return (StatusCode)mapper.readValue(webpage, StatusCode.class);
        }
        catch (IOException ex) {
            LOG.warn("Failed to delete movie list: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public Keyword getKeyword(String keywordId) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_KEYWORD);
        apiUrl.addArgument("id=", keywordId);
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            return (Keyword)mapper.readValue(webpage, Keyword.class);
        }
        catch (IOException ex) {
            LOG.warn("Failed to get keyword: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public TmdbResultsList<KeywordMovie> getKeywordMovies(String keywordId, String language, int page) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_KEYWORD, "/movies");
        apiUrl.addArgument("id=", keywordId);
        if (StringUtils.isNotBlank((CharSequence)language)) {
            apiUrl.addArgument("language=", language);
        }
        if (page > 0) {
            apiUrl.addArgument("page=", page);
        }
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            WrapperKeywordMovies wrapper = (WrapperKeywordMovies)mapper.readValue(webpage, WrapperKeywordMovies.class);
            TmdbResultsList<KeywordMovie> results = new TmdbResultsList<KeywordMovie>(wrapper.getResults());
            results.copyWrapper(wrapper);
            return results;
        }
        catch (IOException ex) {
            LOG.warn("Failed to get keyword movies: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public TmdbResultsList<ChangedMovie> getMovieChangesList(int page, String startDate, String endDate) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_MOVIE, "/changes");
        if (page > 0) {
            apiUrl.addArgument("page=", page);
        }
        if (StringUtils.isNotBlank((CharSequence)startDate)) {
            apiUrl.addArgument("start_date=", startDate);
        }
        if (StringUtils.isNotBlank((CharSequence)endDate)) {
            apiUrl.addArgument("end_date=", endDate);
        }
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            WrapperMovieChanges wrapper = (WrapperMovieChanges)mapper.readValue(webpage, WrapperMovieChanges.class);
            TmdbResultsList<ChangedMovie> results = new TmdbResultsList<ChangedMovie>(wrapper.getResults());
            results.copyWrapper(wrapper);
            return results;
        }
        catch (IOException ex) {
            LOG.warn("Failed to get movie changes: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public void getPersonChangesList(int page, String startDate, String endDate) throws MovieDbException {
        throw new MovieDbException(MovieDbException.MovieDbExceptionType.UNKNOWN_CAUSE, "Not implemented yet");
    }

    public TmdbResultsList<JobDepartment> getJobs() throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_JOB, "/list");
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            WrapperJobList wrapper = (WrapperJobList)mapper.readValue(webpage, WrapperJobList.class);
            TmdbResultsList<JobDepartment> results = new TmdbResultsList<JobDepartment>(wrapper.getJobs());
            results.copyWrapper(wrapper);
            return results;
        }
        catch (IOException ex) {
            LOG.warn("Failed to get job list: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public TmdbResultsList<MovieDb> getDiscover(int page, String language, String sortBy, boolean includeAdult, int year, int primaryReleaseYear, int voteCountGte, float voteAverageGte, String withGenres, String releaseDateGte, String releaseDateLte, String certificationCountry, String certificationLte, String withCompanies) throws MovieDbException {
        Discover discover = new Discover();
        discover.page(page).language(language).sortBy(sortBy).includeAdult(includeAdult).year(year).primaryReleaseYear(primaryReleaseYear).voteCountGte(voteCountGte).voteAverageGte(voteAverageGte).withGenres(withGenres).releaseDateGte(releaseDateGte).releaseDateLte(releaseDateLte).certificationCountry(certificationCountry).certificationLte(certificationLte).withCompanies(withCompanies);
        return this.getDiscover(discover);
    }

    public TmdbResultsList<MovieDb> getDiscover(Discover discover) throws MovieDbException {
        ApiUrl apiUrl = new ApiUrl(this.apiKey, BASE_DISCOVER, "/movie");
        apiUrl.setArguments(discover.getParams());
        URL url = apiUrl.buildUrl();
        String webpage = this.requestWebPage(url);
        try {
            WrapperMovie wrapper = (WrapperMovie)mapper.readValue(webpage, WrapperMovie.class);
            TmdbResultsList<MovieDb> results = new TmdbResultsList<MovieDb>(wrapper.getMovies());
            results.copyWrapper(wrapper);
            return results;
        }
        catch (IOException ex) {
            LOG.warn("Failed to get discover list: {}", (Object)ex.getMessage(), (Object)ex);
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, webpage, ex);
        }
    }

    public static String convertToJson(Map<String, ?> map) throws MovieDbException {
        try {
            return mapper.writeValueAsString(map);
        }
        catch (JsonProcessingException jpe) {
            throw new MovieDbException(MovieDbException.MovieDbExceptionType.MAPPING_FAILED, "JSON conversion failed", jpe);
        }
    }
}

