/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty;

import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.HttpResponseHeaders;
import java.net.URI;
import org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import org.jboss.netty.handler.codec.http.HttpResponse;

public class ResponseHeaders
extends HttpResponseHeaders {
    private final HttpChunkTrailer trailingHeaders;
    private final HttpResponse response;
    private final FluentCaseInsensitiveStringsMap headers;

    public ResponseHeaders(URI uri, HttpResponse response, AsyncHttpProvider provider) {
        super(uri, provider, false);
        this.trailingHeaders = null;
        this.response = response;
        this.headers = this.computerHeaders();
    }

    public ResponseHeaders(URI uri, HttpResponse response, AsyncHttpProvider provider, HttpChunkTrailer traillingHeaders) {
        super(uri, provider, true);
        this.trailingHeaders = traillingHeaders;
        this.response = response;
        this.headers = this.computerHeaders();
    }

    private FluentCaseInsensitiveStringsMap computerHeaders() {
        FluentCaseInsensitiveStringsMap h = new FluentCaseInsensitiveStringsMap();
        for (String s : this.response.getHeaderNames()) {
            for (String header : this.response.getHeaders(s)) {
                h.add(s, header);
            }
        }
        if (this.trailingHeaders != null && this.trailingHeaders.getHeaderNames().size() > 0) {
            for (String s : this.trailingHeaders.getHeaderNames()) {
                for (String header : this.response.getHeaders(s)) {
                    h.add(s, header);
                }
            }
        }
        return h;
    }

    public FluentCaseInsensitiveStringsMap getHeaders() {
        return this.headers;
    }
}

